/*
 * RadeonHD R6xx, R7xx Register documentation
 *
 * Copyright (C) 2008-2009  Advanced Micro Devices, Inc.
 * Copyright (C) 2008-2009  Matthias Hopf
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _AUTOREGS
#define _AUTOREGS

enum {

    VGT_VTX_VECT_EJECT_REG                                = 0x000088b0,
	PRIM_COUNT_mask                                   = 0x3ff << 0,
	PRIM_COUNT_shift                                  = 0,
    VGT_LAST_COPY_STATE                                   = 0x000088c0,
	SRC_STATE_ID_mask                                 = 0x07 << 0,
	SRC_STATE_ID_shift                                = 0,
	DST_STATE_ID_mask                                 = 0x07 << 16,
	DST_STATE_ID_shift                                = 16,
    VGT_CACHE_INVALIDATION                                = 0x000088c4,
	CACHE_INVALIDATION_mask                           = 0x03 << 0,
	CACHE_INVALIDATION_shift                          = 0,
	    VC_ONLY                                       = 0x00,
	    TC_ONLY                                       = 0x01,
	    VC_AND_TC                                     = 0x02,
	VS_NO_EXTRA_BUFFER_bit                            = 1 << 5,
    VGT_GS_PER_ES                                         = 0x000088c8,
    VGT_ES_PER_GS                                         = 0x000088cc,
    VGT_GS_VERTEX_REUSE                                   = 0x000088d4,
	VERT_REUSE_mask                                   = 0x1f << 0,
	VERT_REUSE_shift                                  = 0,
    VGT_MC_LAT_CNTL                                       = 0x000088d8,
	MC_TIME_STAMP_RES_mask                            = 0x03 << 0,
	MC_TIME_STAMP_RES_shift                           = 0,
	    X_0_992_MAX_LATENCY                           = 0x00,
	    X_0_496_MAX_LATENCY                           = 0x01,
	    X_0_248_MAX_LATENCY                           = 0x02,
	    X_0_124_MAX_LATENCY                           = 0x03,
    VGT_GS_PER_VS                                         = 0x000088e8,
	GS_PER_VS_mask                                    = 0x0f << 0,
	GS_PER_VS_shift                                   = 0,
    VGT_CNTL_STATUS                                       = 0x000088f0,
	VGT_OUT_INDX_BUSY_bit                             = 1 << 0,
	VGT_OUT_BUSY_bit                                  = 1 << 1,
	VGT_PT_BUSY_bit                                   = 1 << 2,
	VGT_TE_BUSY_bit                                   = 1 << 3,
	VGT_VR_BUSY_bit                                   = 1 << 4,
	VGT_GRP_BUSY_bit                                  = 1 << 5,
	VGT_DMA_REQ_BUSY_bit                              = 1 << 6,
	VGT_DMA_BUSY_bit                                  = 1 << 7,
	VGT_GS_BUSY_bit                                   = 1 << 8,
	VGT_BUSY_bit                                      = 1 << 9,
    VGT_PRIMITIVE_TYPE                                    = 0x00008958,
	VGT_PRIMITIVE_TYPE__PRIM_TYPE_mask                = 0x3f << 0,
	VGT_PRIMITIVE_TYPE__PRIM_TYPE_shift               = 0,
	    DI_PT_NONE                                    = 0x00,
	    DI_PT_POINTLIST                               = 0x01,
	    DI_PT_LINELIST                                = 0x02,
	    DI_PT_LINESTRIP                               = 0x03,
	    DI_PT_TRILIST                                 = 0x04,
	    DI_PT_TRIFAN                                  = 0x05,
	    DI_PT_TRISTRIP                                = 0x06,
	    DI_PT_UNUSED_0                                = 0x07,
	    DI_PT_UNUSED_1                                = 0x08,
	    DI_PT_UNUSED_2                                = 0x09,
	    DI_PT_LINELIST_ADJ                            = 0x0a,
	    DI_PT_LINESTRIP_ADJ                           = 0x0b,
	    DI_PT_TRILIST_ADJ                             = 0x0c,
	    DI_PT_TRISTRIP_ADJ                            = 0x0d,
	    DI_PT_UNUSED_3                                = 0x0e,
	    DI_PT_UNUSED_4                                = 0x0f,
	    DI_PT_TRI_WITH_WFLAGS                         = 0x10,
	    DI_PT_RECTLIST                                = 0x11,
	    DI_PT_LINELOOP                                = 0x12,
	    DI_PT_QUADLIST                                = 0x13,
	    DI_PT_QUADSTRIP                               = 0x14,
	    DI_PT_POLYGON                                 = 0x15,
	    DI_PT_2D_COPY_RECT_LIST_V0                    = 0x16,
	    DI_PT_2D_COPY_RECT_LIST_V1                    = 0x17,
	    DI_PT_2D_COPY_RECT_LIST_V2                    = 0x18,
	    DI_PT_2D_COPY_RECT_LIST_V3                    = 0x19,
	    DI_PT_2D_FILL_RECT_LIST                       = 0x1a,
	    DI_PT_2D_LINE_STRIP                           = 0x1b,
	    DI_PT_2D_TRI_STRIP                            = 0x1c,
    VGT_INDEX_TYPE                                        = 0x0000895c,
	INDEX_TYPE_mask                                   = 0x03 << 0,
	INDEX_TYPE_shift                                  = 0,
	    DI_INDEX_SIZE_16_BIT                          = 0x00,
	    DI_INDEX_SIZE_32_BIT                          = 0x01,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_0                      = 0x00008960,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_1                      = 0x00008964,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_2                      = 0x00008968,
    VGT_STRMOUT_BUFFER_FILLED_SIZE_3                      = 0x0000896c,
    VGT_NUM_INDICES                                       = 0x00008970,
    VGT_NUM_INSTANCES                                     = 0x00008974,
    PA_CL_CNTL_STATUS                                     = 0x00008a10,
	CL_BUSY_bit                                       = 1 << 31,
    PA_CL_ENHANCE                                         = 0x00008a14,
	CLIP_VTX_REORDER_ENA_bit                          = 1 << 0,
	NUM_CLIP_SEQ_mask                                 = 0x03 << 1,
	NUM_CLIP_SEQ_shift                                = 1,
	CLIPPED_PRIM_SEQ_STALL_bit                        = 1 << 3,
	VE_NAN_PROC_DISABLE_bit                           = 1 << 4,
    PA_SU_CNTL_STATUS                                     = 0x00008a50,
	SU_BUSY_bit                                       = 1 << 31,
    PA_SC_LINE_STIPPLE_STATE                              = 0x00008b10,
	CURRENT_PTR_mask                                  = 0x0f << 0,
	CURRENT_PTR_shift                                 = 0,
	CURRENT_COUNT_mask                                = 0xff << 8,
	CURRENT_COUNT_shift                               = 8,
    PA_SC_MULTI_CHIP_CNTL                                 = 0x00008b20,
	LOG2_NUM_CHIPS_mask                               = 0x07 << 0,
	LOG2_NUM_CHIPS_shift                              = 0,
	MULTI_CHIP_TILE_SIZE_mask                         = 0x03 << 3,
	MULTI_CHIP_TILE_SIZE_shift                        = 3,
	    X_16_X_16_PIXEL_TILE_PER_CHIP                 = 0x00,
	    X_32_X_32_PIXEL_TILE_PER_CHIP                 = 0x01,
	    X_64_X_64_PIXEL_TILE_PER_CHIP                 = 0x02,
	    X_128X128_PIXEL_TILE_PER_CHIP                 = 0x03,
	CHIP_TILE_X_LOC_mask                              = 0x07 << 5,
	CHIP_TILE_X_LOC_shift                             = 5,
	CHIP_TILE_Y_LOC_mask                              = 0x07 << 8,
	CHIP_TILE_Y_LOC_shift                             = 8,
	CHIP_SUPER_TILE_B_bit                             = 1 << 11,
    PA_SC_AA_SAMPLE_LOCS_2S                               = 0x00008b40,
	S0_X_mask                                         = 0x0f << 0,
	S0_X_shift                                        = 0,
	S0_Y_mask                                         = 0x0f << 4,
	S0_Y_shift                                        = 4,
	S1_X_mask                                         = 0x0f << 8,
	S1_X_shift                                        = 8,
	S1_Y_mask                                         = 0x0f << 12,
	S1_Y_shift                                        = 12,
    PA_SC_AA_SAMPLE_LOCS_4S                               = 0x00008b44,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
	S2_X_mask                                         = 0x0f << 16,
	S2_X_shift                                        = 16,
	S2_Y_mask                                         = 0x0f << 20,
	S2_Y_shift                                        = 20,
	S3_X_mask                                         = 0x0f << 24,
	S3_X_shift                                        = 24,
	S3_Y_mask                                         = 0x0f << 28,
	S3_Y_shift                                        = 28,
    PA_SC_AA_SAMPLE_LOCS_8S_WD0                           = 0x00008b48,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
/* 	S2_X_mask                                         = 0x0f << 16, */
/* 	S2_X_shift                                        = 16, */
/* 	S2_Y_mask                                         = 0x0f << 20, */
/* 	S2_Y_shift                                        = 20, */
/* 	S3_X_mask                                         = 0x0f << 24, */
/* 	S3_X_shift                                        = 24, */
/* 	S3_Y_mask                                         = 0x0f << 28, */
/* 	S3_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_8S_WD1                           = 0x00008b4c,
	S4_X_mask                                         = 0x0f << 0,
	S4_X_shift                                        = 0,
	S4_Y_mask                                         = 0x0f << 4,
	S4_Y_shift                                        = 4,
	S5_X_mask                                         = 0x0f << 8,
	S5_X_shift                                        = 8,
	S5_Y_mask                                         = 0x0f << 12,
	S5_Y_shift                                        = 12,
	S6_X_mask                                         = 0x0f << 16,
	S6_X_shift                                        = 16,
	S6_Y_mask                                         = 0x0f << 20,
	S6_Y_shift                                        = 20,
	S7_X_mask                                         = 0x0f << 24,
	S7_X_shift                                        = 24,
	S7_Y_mask                                         = 0x0f << 28,
	S7_Y_shift                                        = 28,
    PA_SC_CNTL_STATUS                                     = 0x00008be0,
	MPASS_OVERFLOW_bit                                = 1 << 30,
    PA_SC_ENHANCE                                         = 0x00008bf0,
	FORCE_EOV_MAX_CLK_CNT_mask                        = 0xfff << 0,
	FORCE_EOV_MAX_CLK_CNT_shift                       = 0,
	FORCE_EOV_MAX_TILE_CNT_mask                       = 0xfff << 12,
	FORCE_EOV_MAX_TILE_CNT_shift                      = 12,
    SQ_CONFIG                                             = 0x00008c00,
	VC_ENABLE_bit                                     = 1 << 0,
	EXPORT_SRC_C_bit                                  = 1 << 1,
	DX9_CONSTS_bit                                    = 1 << 2,
	ALU_INST_PREFER_VECTOR_bit                        = 1 << 3,
	SQ_CONFIG__DX10_CLAMP_bit                         = 1 << 4,
	ALU_PREFER_ONE_WATERFALL_bit                      = 1 << 5,
	ALU_MAX_ONE_WATERFALL_bit                         = 1 << 6,
	CLAUSE_SEQ_PRIO_mask                              = 0x03 << 8,
	CLAUSE_SEQ_PRIO_shift                             = 8,
	    SQ_CL_PRIO_RND_ROBIN                          = 0x00,
	    SQ_CL_PRIO_MACRO_SEQ                          = 0x01,
	    SQ_CL_PRIO_NONE                               = 0x02,
	PS_PRIO_mask                                      = 0x03 << 24,
	PS_PRIO_shift                                     = 24,
	VS_PRIO_mask                                      = 0x03 << 26,
	VS_PRIO_shift                                     = 26,
	GS_PRIO_mask                                      = 0x03 << 28,
	GS_PRIO_shift                                     = 28,
	ES_PRIO_mask                                      = 0x03 << 30,
	ES_PRIO_shift                                     = 30,
    SQ_GPR_RESOURCE_MGMT_1                                = 0x00008c04,
	NUM_PS_GPRS_mask                                  = 0xff << 0,
	NUM_PS_GPRS_shift                                 = 0,
	NUM_VS_GPRS_mask                                  = 0xff << 16,
	NUM_VS_GPRS_shift                                 = 16,
	NUM_CLAUSE_TEMP_GPRS_mask                         = 0x0f << 28,
	NUM_CLAUSE_TEMP_GPRS_shift                        = 28,
    SQ_GPR_RESOURCE_MGMT_2                                = 0x00008c08,
	NUM_GS_GPRS_mask                                  = 0xff << 0,
	NUM_GS_GPRS_shift                                 = 0,
	NUM_ES_GPRS_mask                                  = 0xff << 16,
	NUM_ES_GPRS_shift                                 = 16,
    SQ_THREAD_RESOURCE_MGMT                               = 0x00008c0c,
	NUM_PS_THREADS_mask                               = 0xff << 0,
	NUM_PS_THREADS_shift                              = 0,
	NUM_VS_THREADS_mask                               = 0xff << 8,
	NUM_VS_THREADS_shift                              = 8,
	NUM_GS_THREADS_mask                               = 0xff << 16,
	NUM_GS_THREADS_shift                              = 16,
	NUM_ES_THREADS_mask                               = 0xff << 24,
	NUM_ES_THREADS_shift                              = 24,
    SQ_STACK_RESOURCE_MGMT_1                              = 0x00008c10,
	NUM_PS_STACK_ENTRIES_mask                         = 0xfff << 0,
	NUM_PS_STACK_ENTRIES_shift                        = 0,
	NUM_VS_STACK_ENTRIES_mask                         = 0xfff << 16,
	NUM_VS_STACK_ENTRIES_shift                        = 16,
    SQ_STACK_RESOURCE_MGMT_2                              = 0x00008c14,
	NUM_GS_STACK_ENTRIES_mask                         = 0xfff << 0,
	NUM_GS_STACK_ENTRIES_shift                        = 0,
	NUM_ES_STACK_ENTRIES_mask                         = 0xfff << 16,
	NUM_ES_STACK_ENTRIES_shift                        = 16,
    SQ_ESGS_RING_BASE                                     = 0x00008c40,
    SQ_ESGS_RING_SIZE                                     = 0x00008c44,
    SQ_GSVS_RING_BASE                                     = 0x00008c48,
    SQ_GSVS_RING_SIZE                                     = 0x00008c4c,
    SQ_ESTMP_RING_BASE                                    = 0x00008c50,
    SQ_ESTMP_RING_SIZE                                    = 0x00008c54,
    SQ_GSTMP_RING_BASE                                    = 0x00008c58,
    SQ_GSTMP_RING_SIZE                                    = 0x00008c5c,
    SQ_VSTMP_RING_BASE                                    = 0x00008c60,
    SQ_VSTMP_RING_SIZE                                    = 0x00008c64,
    SQ_PSTMP_RING_BASE                                    = 0x00008c68,
    SQ_PSTMP_RING_SIZE                                    = 0x00008c6c,
    SQ_FBUF_RING_BASE                                     = 0x00008c70,
    SQ_FBUF_RING_SIZE                                     = 0x00008c74,
    SQ_REDUC_RING_BASE                                    = 0x00008c78,
    SQ_REDUC_RING_SIZE                                    = 0x00008c7c,
    SQ_ALU_WORD1_OP3                                      = 0x00008dfc,
	SRC2_SEL_mask                                     = 0x1ff << 0,
	SRC2_SEL_shift                                    = 0,
	    SQ_ALU_SRC_0                                  = 0xf8,
	    SQ_ALU_SRC_1                                  = 0xf9,
	    SQ_ALU_SRC_1_INT                              = 0xfa,
	    SQ_ALU_SRC_M_1_INT                            = 0xfb,
	    SQ_ALU_SRC_0_5                                = 0xfc,
	    SQ_ALU_SRC_LITERAL                            = 0xfd,
	    SQ_ALU_SRC_PV                                 = 0xfe,
	    SQ_ALU_SRC_PS                                 = 0xff,
	SRC2_REL_bit                                      = 1 << 9,
	SRC2_CHAN_mask                                    = 0x03 << 10,
	SRC2_CHAN_shift                                   = 10,
	    SQ_CHAN_X                                     = 0x00,
	    SQ_CHAN_Y                                     = 0x01,
	    SQ_CHAN_Z                                     = 0x02,
	    SQ_CHAN_W                                     = 0x03,
	SRC2_NEG_bit                                      = 1 << 12,
	SQ_ALU_WORD1_OP3__ALU_INST_mask                   = 0x1f << 13,
	SQ_ALU_WORD1_OP3__ALU_INST_shift                  = 13,
	    SQ_OP3_INST_MUL_LIT                           = 0x0c,
	    SQ_OP3_INST_MUL_LIT_M2                        = 0x0d,
	    SQ_OP3_INST_MUL_LIT_M4                        = 0x0e,
	    SQ_OP3_INST_MUL_LIT_D2                        = 0x0f,
	    SQ_OP3_INST_MULADD                            = 0x10,
	    SQ_OP3_INST_MULADD_M2                         = 0x11,
	    SQ_OP3_INST_MULADD_M4                         = 0x12,
	    SQ_OP3_INST_MULADD_D2                         = 0x13,
	    SQ_OP3_INST_MULADD_IEEE                       = 0x14,
	    SQ_OP3_INST_MULADD_IEEE_M2                    = 0x15,
	    SQ_OP3_INST_MULADD_IEEE_M4                    = 0x16,
	    SQ_OP3_INST_MULADD_IEEE_D2                    = 0x17,
	    SQ_OP3_INST_CNDE                              = 0x18,
	    SQ_OP3_INST_CNDGT                             = 0x19,
	    SQ_OP3_INST_CNDGE                             = 0x1a,
	    SQ_OP3_INST_CNDE_INT                          = 0x1c,
	    SQ_OP3_INST_CNDGT_INT                         = 0x1d,
	    SQ_OP3_INST_CNDGE_INT                         = 0x1e,
    SQ_TEX_WORD2                                          = 0x00008dfc,
	OFFSET_X_mask                                     = 0x1f << 0,
	OFFSET_X_shift                                    = 0,
	OFFSET_Y_mask                                     = 0x1f << 5,
	OFFSET_Y_shift                                    = 5,
	OFFSET_Z_mask                                     = 0x1f << 10,
	OFFSET_Z_shift                                    = 10,
	SAMPLER_ID_mask                                   = 0x1f << 15,
	SAMPLER_ID_shift                                  = 15,
	SQ_TEX_WORD2__SRC_SEL_X_mask                      = 0x07 << 20,
	SQ_TEX_WORD2__SRC_SEL_X_shift                     = 20,
	    SQ_SEL_X                                      = 0x00,
	    SQ_SEL_Y                                      = 0x01,
	    SQ_SEL_Z                                      = 0x02,
	    SQ_SEL_W                                      = 0x03,
	    SQ_SEL_0                                      = 0x04,
	    SQ_SEL_1                                      = 0x05,
	SRC_SEL_Y_mask                                    = 0x07 << 23,
	SRC_SEL_Y_shift                                   = 23,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SRC_SEL_Z_mask                                    = 0x07 << 26,
	SRC_SEL_Z_shift                                   = 26,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SRC_SEL_W_mask                                    = 0x07 << 29,
	SRC_SEL_W_shift                                   = 29,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
    SQ_CF_ALLOC_EXPORT_WORD1                              = 0x00008dfc,
	BURST_COUNT_mask                                  = 0x0f << 17,
	BURST_COUNT_shift                                 = 17,
	END_OF_PROGRAM_bit                                = 1 << 21,
	VALID_PIXEL_MODE_bit                              = 1 << 22,
	SQ_CF_ALLOC_EXPORT_WORD1__CF_INST_mask            = 0x7f << 23,
	SQ_CF_ALLOC_EXPORT_WORD1__CF_INST_shift           = 23,
	    SQ_CF_INST_MEM_STREAM0                        = 0x20,
	    SQ_CF_INST_MEM_STREAM1                        = 0x21,
	    SQ_CF_INST_MEM_STREAM2                        = 0x22,
	    SQ_CF_INST_MEM_STREAM3                        = 0x23,
	    SQ_CF_INST_MEM_SCRATCH                        = 0x24,
	    SQ_CF_INST_MEM_REDUCTION                      = 0x25,
	    SQ_CF_INST_MEM_RING                           = 0x26,
	    SQ_CF_INST_EXPORT                             = 0x27,
	    SQ_CF_INST_EXPORT_DONE                        = 0x28,
	WHOLE_QUAD_MODE_bit                               = 1 << 30,
	BARRIER_bit                                       = 1 << 31,
    SQ_CF_ALU_WORD1                                       = 0x00008dfc,
	KCACHE_MODE1_mask                                 = 0x03 << 0,
	KCACHE_MODE1_shift                                = 0,
	    SQ_CF_KCACHE_NOP                              = 0x00,
	    SQ_CF_KCACHE_LOCK_1                           = 0x01,
	    SQ_CF_KCACHE_LOCK_2                           = 0x02,
	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03,
	KCACHE_ADDR0_mask                                 = 0xff << 2,
	KCACHE_ADDR0_shift                                = 2,
	KCACHE_ADDR1_mask                                 = 0xff << 10,
	KCACHE_ADDR1_shift                                = 10,
	SQ_CF_ALU_WORD1__COUNT_mask                       = 0x7f << 18,
	SQ_CF_ALU_WORD1__COUNT_shift                      = 18,
	SQ_CF_ALU_WORD1__ALT_CONST_bit                    = 1 << 25,
	SQ_CF_ALU_WORD1__CF_INST_mask                     = 0x0f << 26,
	SQ_CF_ALU_WORD1__CF_INST_shift                    = 26,
	    SQ_CF_INST_ALU                                = 0x08,
	    SQ_CF_INST_ALU_PUSH_BEFORE                    = 0x09,
	    SQ_CF_INST_ALU_POP_AFTER                      = 0x0a,
	    SQ_CF_INST_ALU_POP2_AFTER                     = 0x0b,
	    SQ_CF_INST_ALU_CONTINUE                       = 0x0d,
	    SQ_CF_INST_ALU_BREAK                          = 0x0e,
	    SQ_CF_INST_ALU_ELSE_AFTER                     = 0x0f,
/* 	WHOLE_QUAD_MODE_bit                               = 1 << 30, */
/* 	BARRIER_bit                                       = 1 << 31, */
    SQ_TEX_WORD1                                          = 0x00008dfc,
	SQ_TEX_WORD1__DST_GPR_mask                        = 0x7f << 0,
	SQ_TEX_WORD1__DST_GPR_shift                       = 0,
	SQ_TEX_WORD1__DST_REL_bit                         = 1 << 7,
	SQ_TEX_WORD1__DST_SEL_X_mask                      = 0x07 << 9,
	SQ_TEX_WORD1__DST_SEL_X_shift                     = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	    SQ_SEL_MASK                                   = 0x07,
	SQ_TEX_WORD1__DST_SEL_Y_mask                      = 0x07 << 12,
	SQ_TEX_WORD1__DST_SEL_Y_shift                     = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__DST_SEL_Z_mask                      = 0x07 << 15,
	SQ_TEX_WORD1__DST_SEL_Z_shift                     = 15,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__DST_SEL_W_mask                      = 0x07 << 18,
	SQ_TEX_WORD1__DST_SEL_W_shift                     = 18,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_TEX_WORD1__LOD_BIAS_mask                       = 0x7f << 21,
	SQ_TEX_WORD1__LOD_BIAS_shift                      = 21,
	COORD_TYPE_X_bit                                  = 1 << 28,
	COORD_TYPE_Y_bit                                  = 1 << 29,
	COORD_TYPE_Z_bit                                  = 1 << 30,
	COORD_TYPE_W_bit                                  = 1 << 31,
    SQ_VTX_WORD0                                          = 0x00008dfc,
	VTX_INST_mask                                     = 0x1f << 0,
	VTX_INST_shift                                    = 0,
	    SQ_VTX_INST_FETCH                             = 0x00,
	    SQ_VTX_INST_SEMANTIC                          = 0x01,
	FETCH_TYPE_mask                                   = 0x03 << 5,
	FETCH_TYPE_shift                                  = 5,
	    SQ_VTX_FETCH_VERTEX_DATA                      = 0x00,
	    SQ_VTX_FETCH_INSTANCE_DATA                    = 0x01,
	    SQ_VTX_FETCH_NO_INDEX_OFFSET                  = 0x02,
	FETCH_WHOLE_QUAD_bit                              = 1 << 7,
	BUFFER_ID_mask                                    = 0xff << 8,
	BUFFER_ID_shift                                   = 8,
	SRC_GPR_mask                                      = 0x7f << 16,
	SRC_GPR_shift                                     = 16,
	SRC_REL_bit                                       = 1 << 23,
	SQ_VTX_WORD0__SRC_SEL_X_mask                      = 0x03 << 24,
	SQ_VTX_WORD0__SRC_SEL_X_shift                     = 24,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
	MEGA_FETCH_COUNT_mask                             = 0x3f << 26,
	MEGA_FETCH_COUNT_shift                            = 26,
    SQ_CF_ALLOC_EXPORT_WORD1_SWIZ                         = 0x00008dfc,
	SEL_X_mask                                        = 0x07 << 0,
	SEL_X_shift                                       = 0,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_Y_mask                                        = 0x07 << 3,
	SEL_Y_shift                                       = 3,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_Z_mask                                        = 0x07 << 6,
	SEL_Z_shift                                       = 6,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SEL_W_mask                                        = 0x07 << 9,
	SEL_W_shift                                       = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
    SQ_ALU_WORD1                                          = 0x00008dfc,
	ENCODING_mask                                     = 0x07 << 15,
	ENCODING_shift                                    = 15,
	BANK_SWIZZLE_mask                                 = 0x07 << 18,
	BANK_SWIZZLE_shift                                = 18,
	    SQ_ALU_VEC_012                                = 0x00,
	    SQ_ALU_VEC_021                                = 0x01,
	    SQ_ALU_VEC_120                                = 0x02,
	    SQ_ALU_VEC_102                                = 0x03,
	    SQ_ALU_VEC_201                                = 0x04,
	    SQ_ALU_VEC_210                                = 0x05,
	SQ_ALU_WORD1__DST_GPR_mask                        = 0x7f << 21,
	SQ_ALU_WORD1__DST_GPR_shift                       = 21,
	SQ_ALU_WORD1__DST_REL_bit                         = 1 << 28,
	DST_CHAN_mask                                     = 0x03 << 29,
	DST_CHAN_shift                                    = 29,
	    CHAN_X                                        = 0x00,
	    CHAN_Y                                        = 0x01,
	    CHAN_Z                                        = 0x02,
	    CHAN_W                                        = 0x03,
	SQ_ALU_WORD1__CLAMP_bit                           = 1 << 31,
    SQ_CF_ALU_WORD0                                       = 0x00008dfc,
	SQ_CF_ALU_WORD0__ADDR_mask                        = 0x3fffff << 0,
	SQ_CF_ALU_WORD0__ADDR_shift                       = 0,
	KCACHE_BANK0_mask                                 = 0x0f << 22,
	KCACHE_BANK0_shift                                = 22,
	KCACHE_BANK1_mask                                 = 0x0f << 26,
	KCACHE_BANK1_shift                                = 26,
	KCACHE_MODE0_mask                                 = 0x03 << 30,
	KCACHE_MODE0_shift                                = 30,
/* 	    SQ_CF_KCACHE_NOP                              = 0x00, */
/* 	    SQ_CF_KCACHE_LOCK_1                           = 0x01, */
/* 	    SQ_CF_KCACHE_LOCK_2                           = 0x02, */
/* 	    SQ_CF_KCACHE_LOCK_LOOP_INDEX                  = 0x03, */
    SQ_VTX_WORD2                                          = 0x00008dfc,
	SQ_VTX_WORD2__OFFSET_mask                         = 0xffff << 0,
	SQ_VTX_WORD2__OFFSET_shift                        = 0,
	SQ_VTX_WORD2__ENDIAN_SWAP_mask                    = 0x03 << 16,
	SQ_VTX_WORD2__ENDIAN_SWAP_shift                   = 16,
	    SQ_ENDIAN_NONE                                = 0x00,
	    SQ_ENDIAN_8IN16                               = 0x01,
	    SQ_ENDIAN_8IN32                               = 0x02,
	CONST_BUF_NO_STRIDE_bit                           = 1 << 18,
	MEGA_FETCH_bit                                    = 1 << 19,
	SQ_VTX_WORD2__ALT_CONST_bit                       = 1 << 20,
    SQ_ALU_WORD1_OP2_V2                                   = 0x00008dfc,
	SRC0_ABS_bit                                      = 1 << 0,
	SRC1_ABS_bit                                      = 1 << 1,
	UPDATE_EXECUTE_MASK_bit                           = 1 << 2,
	UPDATE_PRED_bit                                   = 1 << 3,
	WRITE_MASK_bit                                    = 1 << 4,
	SQ_ALU_WORD1_OP2_V2__OMOD_mask                    = 0x03 << 5,
	SQ_ALU_WORD1_OP2_V2__OMOD_shift                   = 5,
	    SQ_ALU_OMOD_OFF                               = 0x00,
	    SQ_ALU_OMOD_M2                                = 0x01,
	    SQ_ALU_OMOD_M4                                = 0x02,
	    SQ_ALU_OMOD_D2                                = 0x03,
	SQ_ALU_WORD1_OP2_V2__ALU_INST_mask                = 0x7ff << 7,
	SQ_ALU_WORD1_OP2_V2__ALU_INST_shift               = 7,
	    SQ_OP2_INST_ADD                               = 0x00,
	    SQ_OP2_INST_MUL                               = 0x01,
	    SQ_OP2_INST_MUL_IEEE                          = 0x02,
	    SQ_OP2_INST_MAX                               = 0x03,
	    SQ_OP2_INST_MIN                               = 0x04,
	    SQ_OP2_INST_MAX_DX10                          = 0x05,
	    SQ_OP2_INST_MIN_DX10                          = 0x06,
	    SQ_OP2_INST_SETE                              = 0x08,
	    SQ_OP2_INST_SETGT                             = 0x09,
	    SQ_OP2_INST_SETGE                             = 0x0a,
	    SQ_OP2_INST_SETNE                             = 0x0b,
	    SQ_OP2_INST_SETE_DX10                         = 0x0c,
	    SQ_OP2_INST_SETGT_DX10                        = 0x0d,
	    SQ_OP2_INST_SETGE_DX10                        = 0x0e,
	    SQ_OP2_INST_SETNE_DX10                        = 0x0f,
	    SQ_OP2_INST_FRACT                             = 0x10,
	    SQ_OP2_INST_TRUNC                             = 0x11,
	    SQ_OP2_INST_CEIL                              = 0x12,
	    SQ_OP2_INST_RNDNE                             = 0x13,
	    SQ_OP2_INST_FLOOR                             = 0x14,
	    SQ_OP2_INST_MOVA                              = 0x15,
	    SQ_OP2_INST_MOVA_FLOOR                        = 0x16,
	    SQ_OP2_INST_MOVA_INT                          = 0x18,
	    SQ_OP2_INST_MOV                               = 0x19,
	    SQ_OP2_INST_NOP                               = 0x1a,
	    SQ_OP2_INST_PRED_SETGT_UINT                   = 0x1e,
	    SQ_OP2_INST_PRED_SETGE_UINT                   = 0x1f,
	    SQ_OP2_INST_PRED_SETE                         = 0x20,
	    SQ_OP2_INST_PRED_SETGT                        = 0x21,
	    SQ_OP2_INST_PRED_SETGE                        = 0x22,
	    SQ_OP2_INST_PRED_SETNE                        = 0x23,
	    SQ_OP2_INST_PRED_SET_INV                      = 0x24,
	    SQ_OP2_INST_PRED_SET_POP                      = 0x25,
	    SQ_OP2_INST_PRED_SET_CLR                      = 0x26,
	    SQ_OP2_INST_PRED_SET_RESTORE                  = 0x27,
	    SQ_OP2_INST_PRED_SETE_PUSH                    = 0x28,
	    SQ_OP2_INST_PRED_SETGT_PUSH                   = 0x29,
	    SQ_OP2_INST_PRED_SETGE_PUSH                   = 0x2a,
	    SQ_OP2_INST_PRED_SETNE_PUSH                   = 0x2b,
	    SQ_OP2_INST_KILLE                             = 0x2c,
	    SQ_OP2_INST_KILLGT                            = 0x2d,
	    SQ_OP2_INST_KILLGE                            = 0x2e,
	    SQ_OP2_INST_KILLNE                            = 0x2f,
	    SQ_OP2_INST_AND_INT                           = 0x30,
	    SQ_OP2_INST_OR_INT                            = 0x31,
	    SQ_OP2_INST_XOR_INT                           = 0x32,
	    SQ_OP2_INST_NOT_INT                           = 0x33,
	    SQ_OP2_INST_ADD_INT                           = 0x34,
	    SQ_OP2_INST_SUB_INT                           = 0x35,
	    SQ_OP2_INST_MAX_INT                           = 0x36,
	    SQ_OP2_INST_MIN_INT                           = 0x37,
	    SQ_OP2_INST_MAX_UINT                          = 0x38,
	    SQ_OP2_INST_MIN_UINT                          = 0x39,
	    SQ_OP2_INST_SETE_INT                          = 0x3a,
	    SQ_OP2_INST_SETGT_INT                         = 0x3b,
	    SQ_OP2_INST_SETGE_INT                         = 0x3c,
	    SQ_OP2_INST_SETNE_INT                         = 0x3d,
	    SQ_OP2_INST_SETGT_UINT                        = 0x3e,
	    SQ_OP2_INST_SETGE_UINT                        = 0x3f,
	    SQ_OP2_INST_KILLGT_UINT                       = 0x40,
	    SQ_OP2_INST_KILLGE_UINT                       = 0x41,
	    SQ_OP2_INST_PRED_SETE_INT                     = 0x42,
	    SQ_OP2_INST_PRED_SETGT_INT                    = 0x43,
	    SQ_OP2_INST_PRED_SETGE_INT                    = 0x44,
	    SQ_OP2_INST_PRED_SETNE_INT                    = 0x45,
	    SQ_OP2_INST_KILLE_INT                         = 0x46,
	    SQ_OP2_INST_KILLGT_INT                        = 0x47,
	    SQ_OP2_INST_KILLGE_INT                        = 0x48,
	    SQ_OP2_INST_KILLNE_INT                        = 0x49,
	    SQ_OP2_INST_PRED_SETE_PUSH_INT                = 0x4a,
	    SQ_OP2_INST_PRED_SETGT_PUSH_INT               = 0x4b,
	    SQ_OP2_INST_PRED_SETGE_PUSH_INT               = 0x4c,
	    SQ_OP2_INST_PRED_SETNE_PUSH_INT               = 0x4d,
	    SQ_OP2_INST_PRED_SETLT_PUSH_INT               = 0x4e,
	    SQ_OP2_INST_PRED_SETLE_PUSH_INT               = 0x4f,
	    SQ_OP2_INST_DOT4                              = 0x50,
	    SQ_OP2_INST_DOT4_IEEE                         = 0x51,
	    SQ_OP2_INST_CUBE                              = 0x52,
	    SQ_OP2_INST_MAX4                              = 0x53,
	    SQ_OP2_INST_MOVA_GPR_INT                      = 0x60,
	    SQ_OP2_INST_EXP_IEEE                          = 0x61,
	    SQ_OP2_INST_LOG_CLAMPED                       = 0x62,
	    SQ_OP2_INST_LOG_IEEE                          = 0x63,
	    SQ_OP2_INST_RECIP_CLAMPED                     = 0x64,
	    SQ_OP2_INST_RECIP_FF                          = 0x65,
	    SQ_OP2_INST_RECIP_IEEE                        = 0x66,
	    SQ_OP2_INST_RECIPSQRT_CLAMPED                 = 0x67,
	    SQ_OP2_INST_RECIPSQRT_FF                      = 0x68,
	    SQ_OP2_INST_RECIPSQRT_IEEE                    = 0x69,
	    SQ_OP2_INST_SQRT_IEEE                         = 0x6a,
	    SQ_OP2_INST_FLT_TO_INT                        = 0x6b,
	    SQ_OP2_INST_INT_TO_FLT                        = 0x6c,
	    SQ_OP2_INST_UINT_TO_FLT                       = 0x6d,
	    SQ_OP2_INST_SIN                               = 0x6e,
	    SQ_OP2_INST_COS                               = 0x6f,
	    SQ_OP2_INST_ASHR_INT                          = 0x70,
	    SQ_OP2_INST_LSHR_INT                          = 0x71,
	    SQ_OP2_INST_LSHL_INT                          = 0x72,
	    SQ_OP2_INST_MULLO_INT                         = 0x73,
	    SQ_OP2_INST_MULHI_INT                         = 0x74,
	    SQ_OP2_INST_MULLO_UINT                        = 0x75,
	    SQ_OP2_INST_MULHI_UINT                        = 0x76,
	    SQ_OP2_INST_RECIP_INT                         = 0x77,
	    SQ_OP2_INST_RECIP_UINT                        = 0x78,
	    SQ_OP2_INST_FLT_TO_UINT                       = 0x79,
    SQ_CF_ALLOC_EXPORT_WORD1_BUF                          = 0x00008dfc,
	ARRAY_SIZE_mask                                   = 0xfff << 0,
	ARRAY_SIZE_shift                                  = 0,
	COMP_MASK_mask                                    = 0x0f << 12,
	COMP_MASK_shift                                   = 12,
    SQ_CF_WORD0                                           = 0x00008dfc,
    SQ_CF_ALLOC_EXPORT_WORD0                              = 0x00008dfc,
	ARRAY_BASE_mask                                   = 0x1fff << 0,
	ARRAY_BASE_shift                                  = 0,
	SQ_CF_ALLOC_EXPORT_WORD0__TYPE_mask               = 0x03 << 13,
	SQ_CF_ALLOC_EXPORT_WORD0__TYPE_shift              = 13,
	    SQ_EXPORT_PIXEL                               = 0x00,
	    SQ_EXPORT_POS                                 = 0x01,
	    SQ_EXPORT_PARAM                               = 0x02,
	    X_UNUSED_FOR_SX_EXPORTS                       = 0x03,
	RW_GPR_mask                                       = 0x7f << 15,
	RW_GPR_shift                                      = 15,
	RW_REL_bit                                        = 1 << 22,
	INDEX_GPR_mask                                    = 0x7f << 23,
	INDEX_GPR_shift                                   = 23,
	ELEM_SIZE_mask                                    = 0x03 << 30,
	ELEM_SIZE_shift                                   = 30,
    SQ_VTX_WORD1                                          = 0x00008dfc,
	SQ_VTX_WORD1__DST_SEL_X_mask                      = 0x07 << 9,
	SQ_VTX_WORD1__DST_SEL_X_shift                     = 9,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_Y_mask                      = 0x07 << 12,
	SQ_VTX_WORD1__DST_SEL_Y_shift                     = 12,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_Z_mask                      = 0x07 << 15,
	SQ_VTX_WORD1__DST_SEL_Z_shift                     = 15,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	SQ_VTX_WORD1__DST_SEL_W_mask                      = 0x07 << 18,
	SQ_VTX_WORD1__DST_SEL_W_shift                     = 18,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
/* 	    SQ_SEL_MASK                                   = 0x07, */
	USE_CONST_FIELDS_bit                              = 1 << 21,
	SQ_VTX_WORD1__DATA_FORMAT_mask                    = 0x3f << 22,
	SQ_VTX_WORD1__DATA_FORMAT_shift                   = 22,
	SQ_VTX_WORD1__NUM_FORMAT_ALL_mask                 = 0x03 << 28,
	SQ_VTX_WORD1__NUM_FORMAT_ALL_shift                = 28,
	    SQ_NUM_FORMAT_NORM                            = 0x00,
	    SQ_NUM_FORMAT_INT                             = 0x01,
	    SQ_NUM_FORMAT_SCALED                          = 0x02,
	SQ_VTX_WORD1__FORMAT_COMP_ALL_bit                 = 1 << 30,
	SQ_VTX_WORD1__SRF_MODE_ALL_bit                    = 1 << 31,
    SQ_ALU_WORD1_OP2                                      = 0x00008dfc,
/* 	SRC0_ABS_bit                                      = 1 << 0, */
/* 	SRC1_ABS_bit                                      = 1 << 1, */
/* 	UPDATE_EXECUTE_MASK_bit                           = 1 << 2, */
/* 	UPDATE_PRED_bit                                   = 1 << 3, */
/* 	WRITE_MASK_bit                                    = 1 << 4, */
	FOG_MERGE_bit                                     = 1 << 5,
	SQ_ALU_WORD1_OP2__OMOD_mask                       = 0x03 << 6,
	SQ_ALU_WORD1_OP2__OMOD_shift                      = 6,
/* 	    SQ_ALU_OMOD_OFF                               = 0x00, */
/* 	    SQ_ALU_OMOD_M2                                = 0x01, */
/* 	    SQ_ALU_OMOD_M4                                = 0x02, */
/* 	    SQ_ALU_OMOD_D2                                = 0x03, */
	SQ_ALU_WORD1_OP2__ALU_INST_mask                   = 0x3ff << 8,
	SQ_ALU_WORD1_OP2__ALU_INST_shift                  = 8,
/* 	    SQ_OP2_INST_ADD                               = 0x00, */
/* 	    SQ_OP2_INST_MUL                               = 0x01, */
/* 	    SQ_OP2_INST_MUL_IEEE                          = 0x02, */
/* 	    SQ_OP2_INST_MAX                               = 0x03, */
/* 	    SQ_OP2_INST_MIN                               = 0x04, */
/* 	    SQ_OP2_INST_MAX_DX10                          = 0x05, */
/* 	    SQ_OP2_INST_MIN_DX10                          = 0x06, */
/* 	    SQ_OP2_INST_SETE                              = 0x08, */
/* 	    SQ_OP2_INST_SETGT                             = 0x09, */
/* 	    SQ_OP2_INST_SETGE                             = 0x0a, */
/* 	    SQ_OP2_INST_SETNE                             = 0x0b, */
/* 	    SQ_OP2_INST_SETE_DX10                         = 0x0c, */
/* 	    SQ_OP2_INST_SETGT_DX10                        = 0x0d, */
/* 	    SQ_OP2_INST_SETGE_DX10                        = 0x0e, */
/* 	    SQ_OP2_INST_SETNE_DX10                        = 0x0f, */
/* 	    SQ_OP2_INST_FRACT                             = 0x10, */
/* 	    SQ_OP2_INST_TRUNC                             = 0x11, */
/* 	    SQ_OP2_INST_CEIL                              = 0x12, */
/* 	    SQ_OP2_INST_RNDNE                             = 0x13, */
/* 	    SQ_OP2_INST_FLOOR                             = 0x14, */
/* 	    SQ_OP2_INST_MOVA                              = 0x15, */
/* 	    SQ_OP2_INST_MOVA_FLOOR                        = 0x16, */
/* 	    SQ_OP2_INST_MOVA_INT                          = 0x18, */
/* 	    SQ_OP2_INST_MOV                               = 0x19, */
/* 	    SQ_OP2_INST_NOP                               = 0x1a, */
/* 	    SQ_OP2_INST_PRED_SETGT_UINT                   = 0x1e, */
/* 	    SQ_OP2_INST_PRED_SETGE_UINT                   = 0x1f, */
/* 	    SQ_OP2_INST_PRED_SETE                         = 0x20, */
/* 	    SQ_OP2_INST_PRED_SETGT                        = 0x21, */
/* 	    SQ_OP2_INST_PRED_SETGE                        = 0x22, */
/* 	    SQ_OP2_INST_PRED_SETNE                        = 0x23, */
/* 	    SQ_OP2_INST_PRED_SET_INV                      = 0x24, */
/* 	    SQ_OP2_INST_PRED_SET_POP                      = 0x25, */
/* 	    SQ_OP2_INST_PRED_SET_CLR                      = 0x26, */
/* 	    SQ_OP2_INST_PRED_SET_RESTORE                  = 0x27, */
/* 	    SQ_OP2_INST_PRED_SETE_PUSH                    = 0x28, */
/* 	    SQ_OP2_INST_PRED_SETGT_PUSH                   = 0x29, */
/* 	    SQ_OP2_INST_PRED_SETGE_PUSH                   = 0x2a, */
/* 	    SQ_OP2_INST_PRED_SETNE_PUSH                   = 0x2b, */
/* 	    SQ_OP2_INST_KILLE                             = 0x2c, */
/* 	    SQ_OP2_INST_KILLGT                            = 0x2d, */
/* 	    SQ_OP2_INST_KILLGE                            = 0x2e, */
/* 	    SQ_OP2_INST_KILLNE                            = 0x2f, */
/* 	    SQ_OP2_INST_AND_INT                           = 0x30, */
/* 	    SQ_OP2_INST_OR_INT                            = 0x31, */
/* 	    SQ_OP2_INST_XOR_INT                           = 0x32, */
/* 	    SQ_OP2_INST_NOT_INT                           = 0x33, */
/* 	    SQ_OP2_INST_ADD_INT                           = 0x34, */
/* 	    SQ_OP2_INST_SUB_INT                           = 0x35, */
/* 	    SQ_OP2_INST_MAX_INT                           = 0x36, */
/* 	    SQ_OP2_INST_MIN_INT                           = 0x37, */
/* 	    SQ_OP2_INST_MAX_UINT                          = 0x38, */
/* 	    SQ_OP2_INST_MIN_UINT                          = 0x39, */
/* 	    SQ_OP2_INST_SETE_INT                          = 0x3a, */
/* 	    SQ_OP2_INST_SETGT_INT                         = 0x3b, */
/* 	    SQ_OP2_INST_SETGE_INT                         = 0x3c, */
/* 	    SQ_OP2_INST_SETNE_INT                         = 0x3d, */
/* 	    SQ_OP2_INST_SETGT_UINT                        = 0x3e, */
/* 	    SQ_OP2_INST_SETGE_UINT                        = 0x3f, */
/* 	    SQ_OP2_INST_KILLGT_UINT                       = 0x40, */
/* 	    SQ_OP2_INST_KILLGE_UINT                       = 0x41, */
/* 	    SQ_OP2_INST_PRED_SETE_INT                     = 0x42, */
/* 	    SQ_OP2_INST_PRED_SETGT_INT                    = 0x43, */
/* 	    SQ_OP2_INST_PRED_SETGE_INT                    = 0x44, */
/* 	    SQ_OP2_INST_PRED_SETNE_INT                    = 0x45, */
/* 	    SQ_OP2_INST_KILLE_INT                         = 0x46, */
/* 	    SQ_OP2_INST_KILLGT_INT                        = 0x47, */
/* 	    SQ_OP2_INST_KILLGE_INT                        = 0x48, */
/* 	    SQ_OP2_INST_KILLNE_INT                        = 0x49, */
/* 	    SQ_OP2_INST_PRED_SETE_PUSH_INT                = 0x4a, */
/* 	    SQ_OP2_INST_PRED_SETGT_PUSH_INT               = 0x4b, */
/* 	    SQ_OP2_INST_PRED_SETGE_PUSH_INT               = 0x4c, */
/* 	    SQ_OP2_INST_PRED_SETNE_PUSH_INT               = 0x4d, */
/* 	    SQ_OP2_INST_PRED_SETLT_PUSH_INT               = 0x4e, */
/* 	    SQ_OP2_INST_PRED_SETLE_PUSH_INT               = 0x4f, */
/* 	    SQ_OP2_INST_DOT4                              = 0x50, */
/* 	    SQ_OP2_INST_DOT4_IEEE                         = 0x51, */
/* 	    SQ_OP2_INST_CUBE                              = 0x52, */
/* 	    SQ_OP2_INST_MAX4                              = 0x53, */
/* 	    SQ_OP2_INST_MOVA_GPR_INT                      = 0x60, */
/* 	    SQ_OP2_INST_EXP_IEEE                          = 0x61, */
/* 	    SQ_OP2_INST_LOG_CLAMPED                       = 0x62, */
/* 	    SQ_OP2_INST_LOG_IEEE                          = 0x63, */
/* 	    SQ_OP2_INST_RECIP_CLAMPED                     = 0x64, */
/* 	    SQ_OP2_INST_RECIP_FF                          = 0x65, */
/* 	    SQ_OP2_INST_RECIP_IEEE                        = 0x66, */
/* 	    SQ_OP2_INST_RECIPSQRT_CLAMPED                 = 0x67, */
/* 	    SQ_OP2_INST_RECIPSQRT_FF                      = 0x68, */
/* 	    SQ_OP2_INST_RECIPSQRT_IEEE                    = 0x69, */
/* 	    SQ_OP2_INST_SQRT_IEEE                         = 0x6a, */
/* 	    SQ_OP2_INST_FLT_TO_INT                        = 0x6b, */
/* 	    SQ_OP2_INST_INT_TO_FLT                        = 0x6c, */
/* 	    SQ_OP2_INST_UINT_TO_FLT                       = 0x6d, */
/* 	    SQ_OP2_INST_SIN                               = 0x6e, */
/* 	    SQ_OP2_INST_COS                               = 0x6f, */
/* 	    SQ_OP2_INST_ASHR_INT                          = 0x70, */
/* 	    SQ_OP2_INST_LSHR_INT                          = 0x71, */
/* 	    SQ_OP2_INST_LSHL_INT                          = 0x72, */
/* 	    SQ_OP2_INST_MULLO_INT                         = 0x73, */
/* 	    SQ_OP2_INST_MULHI_INT                         = 0x74, */
/* 	    SQ_OP2_INST_MULLO_UINT                        = 0x75, */
/* 	    SQ_OP2_INST_MULHI_UINT                        = 0x76, */
/* 	    SQ_OP2_INST_RECIP_INT                         = 0x77, */
/* 	    SQ_OP2_INST_RECIP_UINT                        = 0x78, */
/* 	    SQ_OP2_INST_FLT_TO_UINT                       = 0x79, */
    SQ_CF_WORD1                                           = 0x00008dfc,
	POP_COUNT_mask                                    = 0x07 << 0,
	POP_COUNT_shift                                   = 0,
	CF_CONST_mask                                     = 0x1f << 3,
	CF_CONST_shift                                    = 3,
	COND_mask                                         = 0x03 << 8,
	COND_shift                                        = 8,
	    SQ_CF_COND_ACTIVE                             = 0x00,
	    SQ_CF_COND_FALSE                              = 0x01,
	    SQ_CF_COND_BOOL                               = 0x02,
	    SQ_CF_COND_NOT_BOOL                           = 0x03,
	SQ_CF_WORD1__COUNT_mask                           = 0x07 << 10,
	SQ_CF_WORD1__COUNT_shift                          = 10,
	CALL_COUNT_mask                                   = 0x3f << 13,
	CALL_COUNT_shift                                  = 13,
	COUNT_3_bit                                       = 1 << 19,
/* 	END_OF_PROGRAM_bit                                = 1 << 21, */
/* 	VALID_PIXEL_MODE_bit                              = 1 << 22, */
	SQ_CF_WORD1__CF_INST_mask                         = 0x7f << 23,
	SQ_CF_WORD1__CF_INST_shift                        = 23,
	    SQ_CF_INST_NOP                                = 0x00,
	    SQ_CF_INST_TEX                                = 0x01,
	    SQ_CF_INST_VTX                                = 0x02,
	    SQ_CF_INST_VTX_TC                             = 0x03,
	    SQ_CF_INST_LOOP_START                         = 0x04,
	    SQ_CF_INST_LOOP_END                           = 0x05,
	    SQ_CF_INST_LOOP_START_DX10                    = 0x06,
	    SQ_CF_INST_LOOP_START_NO_AL                   = 0x07,
	    SQ_CF_INST_LOOP_CONTINUE                      = 0x08,
	    SQ_CF_INST_LOOP_BREAK                         = 0x09,
	    SQ_CF_INST_JUMP                               = 0x0a,
	    SQ_CF_INST_PUSH                               = 0x0b,
	    SQ_CF_INST_PUSH_ELSE                          = 0x0c,
	    SQ_CF_INST_ELSE                               = 0x0d,
	    SQ_CF_INST_POP                                = 0x0e,
	    SQ_CF_INST_POP_JUMP                           = 0x0f,
	    SQ_CF_INST_POP_PUSH                           = 0x10,
	    SQ_CF_INST_POP_PUSH_ELSE                      = 0x11,
	    SQ_CF_INST_CALL                               = 0x12,
	    SQ_CF_INST_CALL_FS                            = 0x13,
	    SQ_CF_INST_RETURN                             = 0x14,
	    SQ_CF_INST_EMIT_VERTEX                        = 0x15,
	    SQ_CF_INST_EMIT_CUT_VERTEX                    = 0x16,
	    SQ_CF_INST_CUT_VERTEX                         = 0x17,
	    SQ_CF_INST_KILL                               = 0x18,
/* 	WHOLE_QUAD_MODE_bit                               = 1 << 30, */
/* 	BARRIER_bit                                       = 1 << 31, */
    SQ_VTX_WORD1_SEM                                      = 0x00008dfc,
	SEMANTIC_ID_mask                                  = 0xff << 0,
	SEMANTIC_ID_shift                                 = 0,
    SQ_TEX_WORD0                                          = 0x00008dfc,
	TEX_INST_mask                                     = 0x1f << 0,
	TEX_INST_shift                                    = 0,
	    SQ_TEX_INST_VTX_FETCH                         = 0x00,
	    SQ_TEX_INST_VTX_SEMANTIC                      = 0x01,
	    SQ_TEX_INST_LD                                = 0x03,
	    SQ_TEX_INST_GET_TEXTURE_RESINFO               = 0x04,
	    SQ_TEX_INST_GET_NUMBER_OF_SAMPLES             = 0x05,
	    SQ_TEX_INST_GET_LOD                           = 0x06,
	    SQ_TEX_INST_GET_GRADIENTS_H                   = 0x07,
	    SQ_TEX_INST_GET_GRADIENTS_V                   = 0x08,
	    SQ_TEX_INST_GET_LERP                          = 0x09,
	    SQ_TEX_INST_RESERVED_10                       = 0x0a,
	    SQ_TEX_INST_SET_GRADIENTS_H                   = 0x0b,
	    SQ_TEX_INST_SET_GRADIENTS_V                   = 0x0c,
	    SQ_TEX_INST_PASS                              = 0x0d,
	    X_Z_SET_INDEX_FOR_ARRAY_OF_CUBEMAPS           = 0x0e,
	    SQ_TEX_INST_SAMPLE                            = 0x10,
	    SQ_TEX_INST_SAMPLE_L                          = 0x11,
	    SQ_TEX_INST_SAMPLE_LB                         = 0x12,
	    SQ_TEX_INST_SAMPLE_LZ                         = 0x13,
	    SQ_TEX_INST_SAMPLE_G                          = 0x14,
	    SQ_TEX_INST_SAMPLE_G_L                        = 0x15,
	    SQ_TEX_INST_SAMPLE_G_LB                       = 0x16,
	    SQ_TEX_INST_SAMPLE_G_LZ                       = 0x17,
	    SQ_TEX_INST_SAMPLE_C                          = 0x18,
	    SQ_TEX_INST_SAMPLE_C_L                        = 0x19,
	    SQ_TEX_INST_SAMPLE_C_LB                       = 0x1a,
	    SQ_TEX_INST_SAMPLE_C_LZ                       = 0x1b,
	    SQ_TEX_INST_SAMPLE_C_G                        = 0x1c,
	    SQ_TEX_INST_SAMPLE_C_G_L                      = 0x1d,
	    SQ_TEX_INST_SAMPLE_C_G_LB                     = 0x1e,
	    SQ_TEX_INST_SAMPLE_C_G_LZ                     = 0x1f,
	BC_FRAC_MODE_bit                                  = 1 << 5,
/* 	FETCH_WHOLE_QUAD_bit                              = 1 << 7, */
	RESOURCE_ID_mask                                  = 0xff << 8,
	RESOURCE_ID_shift                                 = 8,
/* 	SRC_GPR_mask                                      = 0x7f << 16, */
/* 	SRC_GPR_shift                                     = 16, */
/* 	SRC_REL_bit                                       = 1 << 23, */
	SQ_TEX_WORD0__ALT_CONST_bit                       = 1 << 24,
    SQ_VTX_WORD1_GPR                                      = 0x00008dfc,
	SQ_VTX_WORD1_GPR__DST_GPR_mask                    = 0x7f << 0,
	SQ_VTX_WORD1_GPR__DST_GPR_shift                   = 0,
	SQ_VTX_WORD1_GPR__DST_REL_bit                     = 1 << 7,
    SQ_ALU_WORD0                                          = 0x00008dfc,
	SRC0_SEL_mask                                     = 0x1ff << 0,
	SRC0_SEL_shift                                    = 0,
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
	SRC0_REL_bit                                      = 1 << 9,
	SRC0_CHAN_mask                                    = 0x03 << 10,
	SRC0_CHAN_shift                                   = 10,
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	SRC0_NEG_bit                                      = 1 << 12,
	SRC1_SEL_mask                                     = 0x1ff << 13,
	SRC1_SEL_shift                                    = 13,
/* 	    SQ_ALU_SRC_0                                  = 0xf8, */
/* 	    SQ_ALU_SRC_1                                  = 0xf9, */
/* 	    SQ_ALU_SRC_1_INT                              = 0xfa, */
/* 	    SQ_ALU_SRC_M_1_INT                            = 0xfb, */
/* 	    SQ_ALU_SRC_0_5                                = 0xfc, */
/* 	    SQ_ALU_SRC_LITERAL                            = 0xfd, */
/* 	    SQ_ALU_SRC_PV                                 = 0xfe, */
/* 	    SQ_ALU_SRC_PS                                 = 0xff, */
	SRC1_REL_bit                                      = 1 << 22,
	SRC1_CHAN_mask                                    = 0x03 << 23,
	SRC1_CHAN_shift                                   = 23,
/* 	    SQ_CHAN_X                                     = 0x00, */
/* 	    SQ_CHAN_Y                                     = 0x01, */
/* 	    SQ_CHAN_Z                                     = 0x02, */
/* 	    SQ_CHAN_W                                     = 0x03, */
	SRC1_NEG_bit                                      = 1 << 25,
	INDEX_MODE_mask                                   = 0x07 << 26,
	INDEX_MODE_shift                                  = 26,
	    SQ_INDEX_AR_X                                 = 0x00,
	    SQ_INDEX_AR_Y                                 = 0x01,
	    SQ_INDEX_AR_Z                                 = 0x02,
	    SQ_INDEX_AR_W                                 = 0x03,
	    SQ_INDEX_LOOP                                 = 0x04,
	PRED_SEL_mask                                     = 0x03 << 29,
	PRED_SEL_shift                                    = 29,
	    SQ_PRED_SEL_OFF                               = 0x00,
	    SQ_PRED_SEL_ZERO                              = 0x02,
	    SQ_PRED_SEL_ONE                               = 0x03,
	LAST_bit                                          = 1 << 31,
    SX_EXPORT_BUFFER_SIZES                                = 0x0000900c,
	COLOR_BUFFER_SIZE_mask                            = 0xff << 0,
	COLOR_BUFFER_SIZE_shift                           = 0,
	POSITION_BUFFER_SIZE_mask                         = 0xff << 8,
	POSITION_BUFFER_SIZE_shift                        = 8,
	SMX_BUFFER_SIZE_mask                              = 0xff << 16,
	SMX_BUFFER_SIZE_shift                             = 16,
    SX_MEMORY_EXPORT_BASE                                 = 0x00009010,
    SX_MEMORY_EXPORT_SIZE                                 = 0x00009014,
    SPI_CONFIG_CNTL                                       = 0x00009100,
	GPR_WRITE_PRIORITY_mask                           = 0x1f << 0,
	GPR_WRITE_PRIORITY_shift                          = 0,
	    X_PRIORITY_ORDER                              = 0x00,
	    X_PRIORITY_ORDER_VS                           = 0x01,
	DISABLE_INTERP_1_bit                              = 1 << 5,
	DEBUG_THREAD_TYPE_SEL_mask                        = 0x03 << 6,
	DEBUG_THREAD_TYPE_SEL_shift                       = 6,
	DEBUG_GROUP_SEL_mask                              = 0x1f << 8,
	DEBUG_GROUP_SEL_shift                             = 8,
	DEBUG_GRBM_OVERRIDE_bit                           = 1 << 13,
    SPI_CONFIG_CNTL_1                                     = 0x0000913c,
	VTX_DONE_DELAY_mask                               = 0x0f << 0,
	VTX_DONE_DELAY_shift                              = 0,
	    X_DELAY_10_CLKS                               = 0x00,
	    X_DELAY_11_CLKS                               = 0x01,
	    X_DELAY_12_CLKS                               = 0x02,
	    X_DELAY_13_CLKS                               = 0x03,
	    X_DELAY_14_CLKS                               = 0x04,
	    X_DELAY_15_CLKS                               = 0x05,
	    X_DELAY_16_CLKS                               = 0x06,
	    X_DELAY_17_CLKS                               = 0x07,
	    X_DELAY_2_CLKS                                = 0x08,
	    X_DELAY_3_CLKS                                = 0x09,
	    X_DELAY_4_CLKS                                = 0x0a,
	    X_DELAY_5_CLKS                                = 0x0b,
	    X_DELAY_6_CLKS                                = 0x0c,
	    X_DELAY_7_CLKS                                = 0x0d,
	    X_DELAY_8_CLKS                                = 0x0e,
	    X_DELAY_9_CLKS                                = 0x0f,
	INTERP_ONE_PRIM_PER_ROW_bit                       = 1 << 4,
    TD_FILTER4                                            = 0x00009400,
	WEIGHT_1_mask                                     = 0x7ff << 0,
	WEIGHT_1_shift                                    = 0,
	WEIGHT_0_mask                                     = 0x7ff << 11,
	WEIGHT_0_shift                                    = 11,
	WEIGHT_PAIR_bit                                   = 1 << 22,
	PHASE_mask                                        = 0x0f << 23,
	PHASE_shift                                       = 23,
	DIRECTION_bit                                     = 1 << 27,
    TD_FILTER4_1                                          = 0x00009404,
	TD_FILTER4_1_num                                  = 35,
/* 	WEIGHT_1_mask                                     = 0x7ff << 0, */
/* 	WEIGHT_1_shift                                    = 0, */
/* 	WEIGHT_0_mask                                     = 0x7ff << 11, */
/* 	WEIGHT_0_shift                                    = 11, */
    TD_CNTL                                               = 0x00009490,
	SYNC_PHASE_SH_mask                                = 0x03 << 0,
	SYNC_PHASE_SH_shift                               = 0,
	SYNC_PHASE_VC_SMX_mask                            = 0x03 << 4,
	SYNC_PHASE_VC_SMX_shift                           = 4,
    TD0_CNTL                                              = 0x00009494,
	TD0_CNTL_num                                      = 4,
	ID_OVERRIDE_mask                                  = 0x03 << 28,
	ID_OVERRIDE_shift                                 = 28,
    TD0_STATUS                                            = 0x000094a4,
	TD0_STATUS_num                                    = 4,
	BUSY_bit                                          = 1 << 31,
    TA_CNTL                                               = 0x00009504,
	GRADIENT_CREDIT_mask                              = 0x1f << 0,
	GRADIENT_CREDIT_shift                             = 0,
	WALKER_CREDIT_mask                                = 0x1f << 8,
	WALKER_CREDIT_shift                               = 8,
	ALIGNER_CREDIT_mask                               = 0x1f << 16,
	ALIGNER_CREDIT_shift                              = 16,
	TD_FIFO_CREDIT_mask                               = 0x3ff << 22,
	TD_FIFO_CREDIT_shift                              = 22,
    TA_CNTL_AUX                                           = 0x00009508,
	DISABLE_CUBE_WRAP_bit                             = 1 << 0,
	SYNC_GRADIENT_bit                                 = 1 << 24,
	SYNC_WALKER_bit                                   = 1 << 25,
	SYNC_ALIGNER_bit                                  = 1 << 26,
	BILINEAR_PRECISION_bit                            = 1 << 31,
    TA0_CNTL                                              = 0x00009510,
/* 	ID_OVERRIDE_mask                                  = 0x03 << 28, */
/* 	ID_OVERRIDE_shift                                 = 28, */
    TA1_CNTL                                              = 0x00009514,
/* 	ID_OVERRIDE_mask                                  = 0x03 << 28, */
/* 	ID_OVERRIDE_shift                                 = 28, */
    TA2_CNTL                                              = 0x00009518,
/* 	ID_OVERRIDE_mask                                  = 0x03 << 28, */
/* 	ID_OVERRIDE_shift                                 = 28, */
    TA3_CNTL                                              = 0x0000951c,
/* 	ID_OVERRIDE_mask                                  = 0x03 << 28, */
/* 	ID_OVERRIDE_shift                                 = 28, */
    TA0_STATUS                                            = 0x00009520,
	FG_PFIFO_EMPTYB_bit                               = 1 << 12,
	FG_LFIFO_EMPTYB_bit                               = 1 << 13,
	FG_SFIFO_EMPTYB_bit                               = 1 << 14,
	FL_PFIFO_EMPTYB_bit                               = 1 << 16,
	FL_LFIFO_EMPTYB_bit                               = 1 << 17,
	FL_SFIFO_EMPTYB_bit                               = 1 << 18,
	FA_PFIFO_EMPTYB_bit                               = 1 << 20,
	FA_LFIFO_EMPTYB_bit                               = 1 << 21,
	FA_SFIFO_EMPTYB_bit                               = 1 << 22,
	IN_BUSY_bit                                       = 1 << 24,
	FG_BUSY_bit                                       = 1 << 25,
	FL_BUSY_bit                                       = 1 << 27,
	TA_BUSY_bit                                       = 1 << 28,
	FA_BUSY_bit                                       = 1 << 29,
	AL_BUSY_bit                                       = 1 << 30,
/* 	BUSY_bit                                          = 1 << 31, */
    TA1_STATUS                                            = 0x00009524,
/* 	FG_PFIFO_EMPTYB_bit                               = 1 << 12, */
/* 	FG_LFIFO_EMPTYB_bit                               = 1 << 13, */
/* 	FG_SFIFO_EMPTYB_bit                               = 1 << 14, */
/* 	FL_PFIFO_EMPTYB_bit                               = 1 << 16, */
/* 	FL_LFIFO_EMPTYB_bit                               = 1 << 17, */
/* 	FL_SFIFO_EMPTYB_bit                               = 1 << 18, */
/* 	FA_PFIFO_EMPTYB_bit                               = 1 << 20, */
/* 	FA_LFIFO_EMPTYB_bit                               = 1 << 21, */
/* 	FA_SFIFO_EMPTYB_bit                               = 1 << 22, */
/* 	IN_BUSY_bit                                       = 1 << 24, */
/* 	FG_BUSY_bit                                       = 1 << 25, */
/* 	FL_BUSY_bit                                       = 1 << 27, */
/* 	TA_BUSY_bit                                       = 1 << 28, */
/* 	FA_BUSY_bit                                       = 1 << 29, */
/* 	AL_BUSY_bit                                       = 1 << 30, */
/* 	BUSY_bit                                          = 1 << 31, */
    TA2_STATUS                                            = 0x00009528,
/* 	FG_PFIFO_EMPTYB_bit                               = 1 << 12, */
/* 	FG_LFIFO_EMPTYB_bit                               = 1 << 13, */
/* 	FG_SFIFO_EMPTYB_bit                               = 1 << 14, */
/* 	FL_PFIFO_EMPTYB_bit                               = 1 << 16, */
/* 	FL_LFIFO_EMPTYB_bit                               = 1 << 17, */
/* 	FL_SFIFO_EMPTYB_bit                               = 1 << 18, */
/* 	FA_PFIFO_EMPTYB_bit                               = 1 << 20, */
/* 	FA_LFIFO_EMPTYB_bit                               = 1 << 21, */
/* 	FA_SFIFO_EMPTYB_bit                               = 1 << 22, */
/* 	IN_BUSY_bit                                       = 1 << 24, */
/* 	FG_BUSY_bit                                       = 1 << 25, */
/* 	FL_BUSY_bit                                       = 1 << 27, */
/* 	TA_BUSY_bit                                       = 1 << 28, */
/* 	FA_BUSY_bit                                       = 1 << 29, */
/* 	AL_BUSY_bit                                       = 1 << 30, */
/* 	BUSY_bit                                          = 1 << 31, */
    TA3_STATUS                                            = 0x0000952c,
/* 	FG_PFIFO_EMPTYB_bit                               = 1 << 12, */
/* 	FG_LFIFO_EMPTYB_bit                               = 1 << 13, */
/* 	FG_SFIFO_EMPTYB_bit                               = 1 << 14, */
/* 	FL_PFIFO_EMPTYB_bit                               = 1 << 16, */
/* 	FL_LFIFO_EMPTYB_bit                               = 1 << 17, */
/* 	FL_SFIFO_EMPTYB_bit                               = 1 << 18, */
/* 	FA_PFIFO_EMPTYB_bit                               = 1 << 20, */
/* 	FA_LFIFO_EMPTYB_bit                               = 1 << 21, */
/* 	FA_SFIFO_EMPTYB_bit                               = 1 << 22, */
/* 	IN_BUSY_bit                                       = 1 << 24, */
/* 	FG_BUSY_bit                                       = 1 << 25, */
/* 	FL_BUSY_bit                                       = 1 << 27, */
/* 	TA_BUSY_bit                                       = 1 << 28, */
/* 	FA_BUSY_bit                                       = 1 << 29, */
/* 	AL_BUSY_bit                                       = 1 << 30, */
/* 	BUSY_bit                                          = 1 << 31, */
    TC_STATUS                                             = 0x00009600,
	TC_BUSY_bit                                       = 1 << 0,
    TC_INVALIDATE                                         = 0x00009604,
	START_bit                                         = 1 << 0,
    TC_CNTL                                               = 0x00009608,
	FORCE_HIT_bit                                     = 1 << 0,
	FORCE_MISS_bit                                    = 1 << 1,
	L2_SIZE_mask                                      = 0x0f << 5,
	L2_SIZE_shift                                     = 5,
	    _256K                                         = 0x00,
	    _224K                                         = 0x01,
	    _192K                                         = 0x02,
	    _160K                                         = 0x03,
	    _128K                                         = 0x04,
	    _96K                                          = 0x05,
	    _64K                                          = 0x06,
	    _32K                                          = 0x07,
	L2_DISABLE_LATE_HIT_bit                           = 1 << 9,
	DISABLE_VERT_PERF_bit                             = 1 << 10,
	DISABLE_INVAL_BUSY_bit                            = 1 << 11,
	DISABLE_INVAL_SAME_SURFACE_bit                    = 1 << 12,
	PARTITION_MODE_mask                               = 0x03 << 13,
	PARTITION_MODE_shift                              = 13,
	    X_VERTEX                                      = 0x00,
	MISS_ARB_MODE_bit                                 = 1 << 15,
	HIT_ARB_MODE_bit                                  = 1 << 16,
	DISABLE_WRITE_DELAY_bit                           = 1 << 17,
	HIT_FIFO_DEPTH_bit                                = 1 << 18,
    VC_CNTL                                               = 0x00009700,
	L2_INVALIDATE_bit                                 = 1 << 0,
	RESERVED_bit                                      = 1 << 1,
	CC_FORCE_MISS_bit                                 = 1 << 2,
	MI_CHAN_SEL_mask                                  = 0x03 << 3,
	MI_CHAN_SEL_shift                                 = 3,
	    X_MC0_USES_CH_0_1                             = 0x00,
	    X_MC0_USES_CH_0_3                             = 0x01,
	    X_VC_MC0_IS_ACTIVE                            = 0x02,
	    X_VC_MC1_IS_DISABLED                          = 0x03,
	MI_STEER_DISABLE_bit                              = 1 << 5,
	MI_CREDIT_CTR_mask                                = 0x0f << 6,
	MI_CREDIT_CTR_shift                               = 6,
	MI_CREDIT_WE_bit                                  = 1 << 10,
	MI_REQ_STALL_THLD_mask                            = 0x07 << 11,
	MI_REQ_STALL_THLD_shift                           = 11,
	    X_LATENCY_EXCEEDS_399_CLOCKS                  = 0x00,
	    X_LATENCY_EXCEEDS_415_CLOCKS                  = 0x01,
	    X_LATENCY_EXCEEDS_431_CLOCKS                  = 0x02,
	    X_LATENCY_EXCEEDS_447_CLOCKS                  = 0x03,
	    X_LATENCY_EXCEEDS_463_CLOCKS                  = 0x04,
	    X_LATENCY_EXCEEDS_479_CLOCKS                  = 0x05,
	    X_LATENCY_EXCEEDS_495_CLOCKS                  = 0x06,
	    X_LATENCY_EXCEEDS_511_CLOCKS                  = 0x07,
	VC_CNTL__MI_TIMESTAMP_RES_mask                    = 0x1f << 14,
	VC_CNTL__MI_TIMESTAMP_RES_shift                   = 14,
	    X_1X_SYSTEM_CLOCK                             = 0x00,
	    X_2X_SYSTEM_CLOCK                             = 0x01,
	    X_4X_SYSTEM_CLOCK                             = 0x02,
	    X_8X_SYSTEM_CLOCK                             = 0x03,
	    X_16X_SYSTEM_CLOCK                            = 0x04,
	    X_32X_SYSTEM_CLOCK                            = 0x05,
	    X_64X_SYSTEM_CLOCK                            = 0x06,
	    X_128X_SYSTEM_CLOCK                           = 0x07,
	    X_256X_SYSTEM_CLOCK                           = 0x08,
	    X_512X_SYSTEM_CLOCK                           = 0x09,
	    X_1024X_SYSTEM_CLOCK                          = 0x0a,
	    X_2048X_SYSTEM_CLOCK                          = 0x0b,
	    X_4092X_SYSTEM_CLOCK                          = 0x0c,
	    X_8192X_SYSTEM_CLOCK                          = 0x0d,
	    X_16384X_SYSTEM_CLOCK                         = 0x0e,
	    X_32768X_SYSTEM_CLOCK                         = 0x0f,
    VC_CNTL_STATUS                                        = 0x00009704,
	RP_BUSY_bit                                       = 1 << 0,
	RG_BUSY_bit                                       = 1 << 1,
	VC_BUSY_bit                                       = 1 << 2,
	CLAMP_DETECT_bit                                  = 1 << 3,
    VC_CONFIG                                             = 0x00009718,
	WRITE_DIS_bit                                     = 1 << 0,
	GPR_DATA_PHASE_ADJ_mask                           = 0x07 << 1,
	GPR_DATA_PHASE_ADJ_shift                          = 1,
	    X_LATENCY_BASE_0_CYCLES                       = 0x00,
	    X_LATENCY_BASE_1_CYCLES                       = 0x01,
	    X_LATENCY_BASE_2_CYCLES                       = 0x02,
	    X_LATENCY_BASE_3_CYCLES                       = 0x03,
	TD_SIMD_SYNC_ADJ_mask                             = 0x07 << 4,
	TD_SIMD_SYNC_ADJ_shift                            = 4,
	    X_0_CYCLES_DELAY                              = 0x00,
	    X_1_CYCLES_DELAY                              = 0x01,
	    X_2_CYCLES_DELAY                              = 0x02,
	    X_3_CYCLES_DELAY                              = 0x03,
	    X_4_CYCLES_DELAY                              = 0x04,
	    X_5_CYCLES_DELAY                              = 0x05,
	    X_6_CYCLES_DELAY                              = 0x06,
	    X_7_CYCLES_DELAY                              = 0x07,
    SMX_DC_CTL0                                           = 0x0000a020,
	WR_GATHER_STREAM0_bit                             = 1 << 0,
	WR_GATHER_STREAM1_bit                             = 1 << 1,
	WR_GATHER_STREAM2_bit                             = 1 << 2,
	WR_GATHER_STREAM3_bit                             = 1 << 3,
	WR_GATHER_SCRATCH_bit                             = 1 << 4,
	WR_GATHER_REDUC_BUF_bit                           = 1 << 5,
	WR_GATHER_RING_BUF_bit                            = 1 << 6,
	WR_GATHER_F_BUF_bit                               = 1 << 7,
	DISABLE_CACHES_bit                                = 1 << 8,
	AUTO_FLUSH_INVAL_EN_bit                           = 1 << 10,
	AUTO_FLUSH_EN_bit                                 = 1 << 11,
	AUTO_FLUSH_CNT_mask                               = 0xffff << 12,
	AUTO_FLUSH_CNT_shift                              = 12,
	MC_RD_STALL_FACTOR_mask                           = 0x03 << 28,
	MC_RD_STALL_FACTOR_shift                          = 28,
	MC_WR_STALL_FACTOR_mask                           = 0x03 << 30,
	MC_WR_STALL_FACTOR_shift                          = 30,
    SMX_DC_CTL1                                           = 0x0000a024,
	OP_FIFO_SKID_mask                                 = 0x7f << 0,
	OP_FIFO_SKID_shift                                = 0,
	CACHE_LINE_SIZE_bit                               = 1 << 8,
	MULTI_FLUSH_MODE_bit                              = 1 << 9,
	MULTI_FLUSH_REQ_ABORT_IDX_FIFO_SKID_mask          = 0x0f << 10,
	MULTI_FLUSH_REQ_ABORT_IDX_FIFO_SKID_shift         = 10,
	DISABLE_WR_GATHER_RD_HIT_FORCE_EVICT_bit          = 1 << 16,
	DISABLE_WR_GATHER_RD_HIT_COMP_VLDS_CHECK_bit      = 1 << 17,
	DISABLE_FLUSH_ES_ALSO_INVALS_bit                  = 1 << 18,
	DISABLE_FLUSH_GS_ALSO_INVALS_bit                  = 1 << 19,
    SMX_DC_CTL2                                           = 0x0000a028,
	INVALIDATE_CACHES_bit                             = 1 << 0,
	CACHES_INVALID_bit                                = 1 << 1,
	CACHES_DIRTY_bit                                  = 1 << 2,
	FLUSH_ALL_bit                                     = 1 << 4,
	FLUSH_GS_THREADS_bit                              = 1 << 8,
	FLUSH_ES_THREADS_bit                              = 1 << 9,
    SMX_DC_MC_INTF_CTL                                    = 0x0000a02c,
	MC_RD_REQ_CRED_mask                               = 0xff << 0,
	MC_RD_REQ_CRED_shift                              = 0,
	MC_WR_REQ_CRED_mask                               = 0xff << 16,
	MC_WR_REQ_CRED_shift                              = 16,
    TD_PS_SAMPLER0_BORDER_RED                             = 0x0000a400,
	TD_PS_SAMPLER0_BORDER_RED_num                     = 18,
	TD_PS_SAMPLER0_BORDER_RED_offset                  = 16,
    TD_PS_SAMPLER0_BORDER_GREEN                           = 0x0000a404,
	TD_PS_SAMPLER0_BORDER_GREEN_num                   = 18,
	TD_PS_SAMPLER0_BORDER_GREEN_offset                = 16,
    TD_PS_SAMPLER0_BORDER_BLUE                            = 0x0000a408,
	TD_PS_SAMPLER0_BORDER_BLUE_num                    = 18,
	TD_PS_SAMPLER0_BORDER_BLUE_offset                 = 16,
    TD_PS_SAMPLER0_BORDER_ALPHA                           = 0x0000a40c,
	TD_PS_SAMPLER0_BORDER_ALPHA_num                   = 18,
	TD_PS_SAMPLER0_BORDER_ALPHA_offset                = 16,
    TD_VS_SAMPLER0_BORDER_RED                             = 0x0000a600,
	TD_VS_SAMPLER0_BORDER_RED_num                     = 18,
	TD_VS_SAMPLER0_BORDER_RED_offset                  = 16,
    TD_VS_SAMPLER0_BORDER_GREEN                           = 0x0000a604,
	TD_VS_SAMPLER0_BORDER_GREEN_num                   = 18,
	TD_VS_SAMPLER0_BORDER_GREEN_offset                = 16,
    TD_VS_SAMPLER0_BORDER_BLUE                            = 0x0000a608,
	TD_VS_SAMPLER0_BORDER_BLUE_num                    = 18,
	TD_VS_SAMPLER0_BORDER_BLUE_offset                 = 16,
    TD_VS_SAMPLER0_BORDER_ALPHA                           = 0x0000a60c,
	TD_VS_SAMPLER0_BORDER_ALPHA_num                   = 18,
	TD_VS_SAMPLER0_BORDER_ALPHA_offset                = 16,
    TD_GS_SAMPLER0_BORDER_RED                             = 0x0000a800,
	TD_GS_SAMPLER0_BORDER_RED_num                     = 18,
	TD_GS_SAMPLER0_BORDER_RED_offset                  = 16,
    TD_GS_SAMPLER0_BORDER_GREEN                           = 0x0000a804,
	TD_GS_SAMPLER0_BORDER_GREEN_num                   = 18,
	TD_GS_SAMPLER0_BORDER_GREEN_offset                = 16,
    TD_GS_SAMPLER0_BORDER_BLUE                            = 0x0000a808,
	TD_GS_SAMPLER0_BORDER_BLUE_num                    = 18,
	TD_GS_SAMPLER0_BORDER_BLUE_offset                 = 16,
    TD_GS_SAMPLER0_BORDER_ALPHA                           = 0x0000a80c,
	TD_GS_SAMPLER0_BORDER_ALPHA_num                   = 18,
	TD_GS_SAMPLER0_BORDER_ALPHA_offset                = 16,
    TD_PS_SAMPLER0_CLEARTYPE_KERNEL                       = 0x0000aa00,
	TD_PS_SAMPLER0_CLEARTYPE_KERNEL_num               = 18,
	TD_PS_SAMPLER0_CLEARTYPE_KERNEL__WIDTH_mask       = 0x07 << 0,
	TD_PS_SAMPLER0_CLEARTYPE_KERNEL__WIDTH_shift      = 0,
	TD_PS_SAMPLER0_CLEARTYPE_KERNEL__HEIGHT_mask      = 0x07 << 3,
	TD_PS_SAMPLER0_CLEARTYPE_KERNEL__HEIGHT_shift     = 3,
    DB_DEPTH_SIZE                                         = 0x00028000,
	PITCH_TILE_MAX_mask                               = 0x3ff << 0,
	PITCH_TILE_MAX_shift                              = 0,
	SLICE_TILE_MAX_mask                               = 0xfffff << 10,
	SLICE_TILE_MAX_shift                              = 10,
    DB_DEPTH_VIEW                                         = 0x00028004,
	SLICE_START_mask                                  = 0x7ff << 0,
	SLICE_START_shift                                 = 0,
	SLICE_MAX_mask                                    = 0x7ff << 13,
	SLICE_MAX_shift                                   = 13,
    DB_DEPTH_BASE                                         = 0x0002800c,
    DB_DEPTH_INFO                                         = 0x00028010,
	DB_DEPTH_INFO__FORMAT_mask                        = 0x07 << 0,
	DB_DEPTH_INFO__FORMAT_shift                       = 0,
	    DEPTH_INVALID                                 = 0x00,
	    DEPTH_16                                      = 0x01,
	    DEPTH_X8_24                                   = 0x02,
	    DEPTH_8_24                                    = 0x03,
	    DEPTH_X8_24_FLOAT                             = 0x04,
	    DEPTH_8_24_FLOAT                              = 0x05,
	    DEPTH_32_FLOAT                                = 0x06,
	    DEPTH_X24_8_32_FLOAT                          = 0x07,
	DB_DEPTH_INFO__READ_SIZE_bit                      = 1 << 3,
	DB_DEPTH_INFO__ARRAY_MODE_mask                    = 0x0f << 15,
	DB_DEPTH_INFO__ARRAY_MODE_shift                   = 15,
	    ARRAY_2D_TILED_THIN1                          = 0x04,
	TILE_SURFACE_ENABLE_bit                           = 1 << 25,
	TILE_COMPACT_bit                                  = 1 << 26,
	ZRANGE_PRECISION_bit                              = 1 << 31,
    DB_HTILE_DATA_BASE                                    = 0x00028014,
    DB_STENCIL_CLEAR                                      = 0x00028028,
	DB_STENCIL_CLEAR__CLEAR_mask                      = 0xff << 0,
	DB_STENCIL_CLEAR__CLEAR_shift                     = 0,
	MIN_mask                                          = 0xff << 16,
	MIN_shift                                         = 16,
    DB_DEPTH_CLEAR                                        = 0x0002802c,
    PA_SC_SCREEN_SCISSOR_TL                               = 0x00028030,
	PA_SC_SCREEN_SCISSOR_TL__TL_X_mask                = 0x7fff << 0,
	PA_SC_SCREEN_SCISSOR_TL__TL_X_shift               = 0,
	PA_SC_SCREEN_SCISSOR_TL__TL_Y_mask                = 0x7fff << 16,
	PA_SC_SCREEN_SCISSOR_TL__TL_Y_shift               = 16,
    PA_SC_SCREEN_SCISSOR_BR                               = 0x00028034,
	PA_SC_SCREEN_SCISSOR_BR__BR_X_mask                = 0x7fff << 0,
	PA_SC_SCREEN_SCISSOR_BR__BR_X_shift               = 0,
	PA_SC_SCREEN_SCISSOR_BR__BR_Y_mask                = 0x7fff << 16,
	PA_SC_SCREEN_SCISSOR_BR__BR_Y_shift               = 16,
    CB_COLOR0_BASE                                        = 0x00028040,
	CB_COLOR0_BASE_num                                = 8,
    CB_COLOR0_SIZE                                        = 0x00028060,
	CB_COLOR0_SIZE_num                                = 8,
/* 	PITCH_TILE_MAX_mask                               = 0x3ff << 0, */
/* 	PITCH_TILE_MAX_shift                              = 0, */
/* 	SLICE_TILE_MAX_mask                               = 0xfffff << 10, */
/* 	SLICE_TILE_MAX_shift                              = 10, */
    CB_COLOR0_VIEW                                        = 0x00028080,
	CB_COLOR0_VIEW_num                                = 8,
/* 	SLICE_START_mask                                  = 0x7ff << 0, */
/* 	SLICE_START_shift                                 = 0, */
/* 	SLICE_MAX_mask                                    = 0x7ff << 13, */
/* 	SLICE_MAX_shift                                   = 13, */
    CB_COLOR0_INFO                                        = 0x000280a0,
	CB_COLOR0_INFO_num                                = 8,
	ENDIAN_mask                                       = 0x03 << 0,
	ENDIAN_shift                                      = 0,
	    ENDIAN_NONE                                   = 0x00,
	    ENDIAN_8IN16                                  = 0x01,
	    ENDIAN_8IN32                                  = 0x02,
	    ENDIAN_8IN64                                  = 0x03,
	CB_COLOR0_INFO__FORMAT_mask                       = 0x3f << 2,
	CB_COLOR0_INFO__FORMAT_shift                      = 2,
	    COLOR_INVALID                                 = 0x00,
	    COLOR_8                                       = 0x01,
	    COLOR_4_4                                     = 0x02,
	    COLOR_3_3_2                                   = 0x03,
	    COLOR_16                                      = 0x05,
	    COLOR_16_FLOAT                                = 0x06,
	    COLOR_8_8                                     = 0x07,
	    COLOR_5_6_5                                   = 0x08,
	    COLOR_6_5_5                                   = 0x09,
	    COLOR_1_5_5_5                                 = 0x0a,
	    COLOR_4_4_4_4                                 = 0x0b,
	    COLOR_5_5_5_1                                 = 0x0c,
	    COLOR_32                                      = 0x0d,
	    COLOR_32_FLOAT                                = 0x0e,
	    COLOR_16_16                                   = 0x0f,
	    COLOR_16_16_FLOAT                             = 0x10,
	    COLOR_8_24                                    = 0x11,
	    COLOR_8_24_FLOAT                              = 0x12,
	    COLOR_24_8                                    = 0x13,
	    COLOR_24_8_FLOAT                              = 0x14,
	    COLOR_10_11_11                                = 0x15,
	    COLOR_10_11_11_FLOAT                          = 0x16,
	    COLOR_11_11_10                                = 0x17,
	    COLOR_11_11_10_FLOAT                          = 0x18,
	    COLOR_2_10_10_10                              = 0x19,
	    COLOR_8_8_8_8                                 = 0x1a,
	    COLOR_10_10_10_2                              = 0x1b,
	    COLOR_X24_8_32_FLOAT                          = 0x1c,
	    COLOR_32_32                                   = 0x1d,
	    COLOR_32_32_FLOAT                             = 0x1e,
	    COLOR_16_16_16_16                             = 0x1f,
	    COLOR_16_16_16_16_FLOAT                       = 0x20,
	    COLOR_32_32_32_32                             = 0x22,
	    COLOR_32_32_32_32_FLOAT                       = 0x23,
	CB_COLOR0_INFO__ARRAY_MODE_mask                   = 0x0f << 8,
	CB_COLOR0_INFO__ARRAY_MODE_shift                  = 8,
	    ARRAY_LINEAR_GENERAL                          = 0x00,
	    ARRAY_LINEAR_ALIGNED                          = 0x01,
/* 	    ARRAY_2D_TILED_THIN1                          = 0x04, */
	NUMBER_TYPE_mask                                  = 0x07 << 12,
	NUMBER_TYPE_shift                                 = 12,
	    NUMBER_UNORM                                  = 0x00,
	    NUMBER_SNORM                                  = 0x01,
	    NUMBER_USCALED                                = 0x02,
	    NUMBER_SSCALED                                = 0x03,
	    NUMBER_UINT                                   = 0x04,
	    NUMBER_SINT                                   = 0x05,
	    NUMBER_SRGB                                   = 0x06,
	    NUMBER_FLOAT                                  = 0x07,
	CB_COLOR0_INFO__READ_SIZE_bit                     = 1 << 15,
	COMP_SWAP_mask                                    = 0x03 << 16,
	COMP_SWAP_shift                                   = 16,
	    SWAP_STD                                      = 0x00,
	    SWAP_ALT                                      = 0x01,
	    SWAP_STD_REV                                  = 0x02,
	    SWAP_ALT_REV                                  = 0x03,
	CB_COLOR0_INFO__TILE_MODE_mask                    = 0x03 << 18,
	CB_COLOR0_INFO__TILE_MODE_shift                   = 18,
	    TILE_DISABLE                                  = 0x00,
	    TILE_CLEAR_ENABLE                             = 0x01,
	    TILE_FRAG_ENABLE                              = 0x02,
	BLEND_CLAMP_bit                                   = 1 << 20,
	CLEAR_COLOR_bit                                   = 1 << 21,
	BLEND_BYPASS_bit                                  = 1 << 22,
	BLEND_FLOAT32_bit                                 = 1 << 23,
	SIMPLE_FLOAT_bit                                  = 1 << 24,
	CB_COLOR0_INFO__ROUND_MODE_bit                    = 1 << 25,
/* 	TILE_COMPACT_bit                                  = 1 << 26, */
	SOURCE_FORMAT_bit                                 = 1 << 27,
    CB_COLOR0_TILE                                        = 0x000280c0,
	CB_COLOR0_TILE_num                                = 8,
    CB_COLOR0_FRAG                                        = 0x000280e0,
	CB_COLOR0_FRAG_num                                = 8,
    CB_COLOR0_MASK                                        = 0x00028100,
	CB_COLOR0_MASK_num                                = 8,
	CMASK_BLOCK_MAX_mask                              = 0xfff << 0,
	CMASK_BLOCK_MAX_shift                             = 0,
	FMASK_TILE_MAX_mask                               = 0xfffff << 12,
	FMASK_TILE_MAX_shift                              = 12,
    CB_CLEAR_RED                                          = 0x00028120,
    CB_CLEAR_GREEN                                        = 0x00028124,
    CB_CLEAR_BLUE                                         = 0x00028128,
    CB_CLEAR_ALPHA                                        = 0x0002812c,
    SQ_ALU_CONST_BUFFER_SIZE_PS_0                         = 0x00028140,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_PS_0__DATA_shift         = 0,
    SQ_ALU_CONST_BUFFER_SIZE_VS_0                         = 0x00028180,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_VS_0__DATA_shift         = 0,
    SQ_ALU_CONST_BUFFER_SIZE_GS_0                         = 0x000281c0,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0_num                 = 16,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0__DATA_mask          = 0x1ff << 0,
	SQ_ALU_CONST_BUFFER_SIZE_GS_0__DATA_shift         = 0,
    PA_SC_WINDOW_OFFSET                                   = 0x00028200,
	WINDOW_X_OFFSET_mask                              = 0x7fff << 0,
	WINDOW_X_OFFSET_shift                             = 0,
	WINDOW_Y_OFFSET_mask                              = 0x7fff << 16,
	WINDOW_Y_OFFSET_shift                             = 16,
    PA_SC_WINDOW_SCISSOR_TL                               = 0x00028204,
	PA_SC_WINDOW_SCISSOR_TL__TL_X_mask                = 0x3fff << 0,
	PA_SC_WINDOW_SCISSOR_TL__TL_X_shift               = 0,
	PA_SC_WINDOW_SCISSOR_TL__TL_Y_mask                = 0x3fff << 16,
	PA_SC_WINDOW_SCISSOR_TL__TL_Y_shift               = 16,
	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31,
    PA_SC_WINDOW_SCISSOR_BR                               = 0x00028208,
	PA_SC_WINDOW_SCISSOR_BR__BR_X_mask                = 0x3fff << 0,
	PA_SC_WINDOW_SCISSOR_BR__BR_X_shift               = 0,
	PA_SC_WINDOW_SCISSOR_BR__BR_Y_mask                = 0x3fff << 16,
	PA_SC_WINDOW_SCISSOR_BR__BR_Y_shift               = 16,
    PA_SC_CLIPRECT_RULE                                   = 0x0002820c,
	CLIP_RULE_mask                                    = 0xffff << 0,
	CLIP_RULE_shift                                   = 0,
    PA_SC_CLIPRECT_0_TL                                   = 0x00028210,
	PA_SC_CLIPRECT_0_TL_num                           = 4,
	PA_SC_CLIPRECT_0_TL_offset                        = 8,
	PA_SC_CLIPRECT_0_TL__TL_X_mask                    = 0x3fff << 0,
	PA_SC_CLIPRECT_0_TL__TL_X_shift                   = 0,
	PA_SC_CLIPRECT_0_TL__TL_Y_mask                    = 0x3fff << 16,
	PA_SC_CLIPRECT_0_TL__TL_Y_shift                   = 16,
    PA_SC_CLIPRECT_0_BR                                   = 0x00028214,
	PA_SC_CLIPRECT_0_BR_num                           = 4,
	PA_SC_CLIPRECT_0_BR_offset                        = 8,
	PA_SC_CLIPRECT_0_BR__BR_X_mask                    = 0x3fff << 0,
	PA_SC_CLIPRECT_0_BR__BR_X_shift                   = 0,
	PA_SC_CLIPRECT_0_BR__BR_Y_mask                    = 0x3fff << 16,
	PA_SC_CLIPRECT_0_BR__BR_Y_shift                   = 16,
    CB_TARGET_MASK                                        = 0x00028238,
	TARGET0_ENABLE_mask                               = 0x0f << 0,
	TARGET0_ENABLE_shift                              = 0,
	TARGET1_ENABLE_mask                               = 0x0f << 4,
	TARGET1_ENABLE_shift                              = 4,
	TARGET2_ENABLE_mask                               = 0x0f << 8,
	TARGET2_ENABLE_shift                              = 8,
	TARGET3_ENABLE_mask                               = 0x0f << 12,
	TARGET3_ENABLE_shift                              = 12,
	TARGET4_ENABLE_mask                               = 0x0f << 16,
	TARGET4_ENABLE_shift                              = 16,
	TARGET5_ENABLE_mask                               = 0x0f << 20,
	TARGET5_ENABLE_shift                              = 20,
	TARGET6_ENABLE_mask                               = 0x0f << 24,
	TARGET6_ENABLE_shift                              = 24,
	TARGET7_ENABLE_mask                               = 0x0f << 28,
	TARGET7_ENABLE_shift                              = 28,
    CB_SHADER_MASK                                        = 0x0002823c,
	OUTPUT0_ENABLE_mask                               = 0x0f << 0,
	OUTPUT0_ENABLE_shift                              = 0,
	OUTPUT1_ENABLE_mask                               = 0x0f << 4,
	OUTPUT1_ENABLE_shift                              = 4,
	OUTPUT2_ENABLE_mask                               = 0x0f << 8,
	OUTPUT2_ENABLE_shift                              = 8,
	OUTPUT3_ENABLE_mask                               = 0x0f << 12,
	OUTPUT3_ENABLE_shift                              = 12,
	OUTPUT4_ENABLE_mask                               = 0x0f << 16,
	OUTPUT4_ENABLE_shift                              = 16,
	OUTPUT5_ENABLE_mask                               = 0x0f << 20,
	OUTPUT5_ENABLE_shift                              = 20,
	OUTPUT6_ENABLE_mask                               = 0x0f << 24,
	OUTPUT6_ENABLE_shift                              = 24,
	OUTPUT7_ENABLE_mask                               = 0x0f << 28,
	OUTPUT7_ENABLE_shift                              = 28,
    PA_SC_GENERIC_SCISSOR_TL                              = 0x00028240,
	PA_SC_GENERIC_SCISSOR_TL__TL_X_mask               = 0x3fff << 0,
	PA_SC_GENERIC_SCISSOR_TL__TL_X_shift              = 0,
	PA_SC_GENERIC_SCISSOR_TL__TL_Y_mask               = 0x3fff << 16,
	PA_SC_GENERIC_SCISSOR_TL__TL_Y_shift              = 16,
/* 	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31, */
    PA_SC_GENERIC_SCISSOR_BR                              = 0x00028244,
	PA_SC_GENERIC_SCISSOR_BR__BR_X_mask               = 0x3fff << 0,
	PA_SC_GENERIC_SCISSOR_BR__BR_X_shift              = 0,
	PA_SC_GENERIC_SCISSOR_BR__BR_Y_mask               = 0x3fff << 16,
	PA_SC_GENERIC_SCISSOR_BR__BR_Y_shift              = 16,
    PA_SC_VPORT_SCISSOR_0_TL                              = 0x00028250,
	PA_SC_VPORT_SCISSOR_0_TL_num                      = 16,
	PA_SC_VPORT_SCISSOR_0_TL_offset                   = 8,
	PA_SC_VPORT_SCISSOR_0_TL__TL_X_mask               = 0x3fff << 0,
	PA_SC_VPORT_SCISSOR_0_TL__TL_X_shift              = 0,
	PA_SC_VPORT_SCISSOR_0_TL__TL_Y_mask               = 0x3fff << 16,
	PA_SC_VPORT_SCISSOR_0_TL__TL_Y_shift              = 16,
/* 	WINDOW_OFFSET_DISABLE_bit                         = 1 << 31, */
    PA_SC_VPORT_SCISSOR_0_BR                              = 0x00028254,
	PA_SC_VPORT_SCISSOR_0_BR_num                      = 16,
	PA_SC_VPORT_SCISSOR_0_BR_offset                   = 8,
	PA_SC_VPORT_SCISSOR_0_BR__BR_X_mask               = 0x3fff << 0,
	PA_SC_VPORT_SCISSOR_0_BR__BR_X_shift              = 0,
	PA_SC_VPORT_SCISSOR_0_BR__BR_Y_mask               = 0x3fff << 16,
	PA_SC_VPORT_SCISSOR_0_BR__BR_Y_shift              = 16,
    PA_SC_VPORT_ZMIN_0                                    = 0x000282d0,
	PA_SC_VPORT_ZMIN_0_num                            = 16,
	PA_SC_VPORT_ZMIN_0_offset                         = 8,
    PA_SC_VPORT_ZMAX_0                                    = 0x000282d4,
	PA_SC_VPORT_ZMAX_0_num                            = 16,
	PA_SC_VPORT_ZMAX_0_offset                         = 8,
    SX_MISC                                               = 0x00028350,
	MULTIPASS_bit                                     = 1 << 0,
    SQ_VTX_SEMANTIC_0                                     = 0x00028380,
	SQ_VTX_SEMANTIC_0_num                             = 32,
/* 	SEMANTIC_ID_mask                                  = 0xff << 0, */
/* 	SEMANTIC_ID_shift                                 = 0, */
    VGT_MAX_VTX_INDX                                      = 0x00028400,
    VGT_MIN_VTX_INDX                                      = 0x00028404,
    VGT_INDX_OFFSET                                       = 0x00028408,
    VGT_MULTI_PRIM_IB_RESET_INDX                          = 0x0002840c,
    SX_ALPHA_TEST_CONTROL                                 = 0x00028410,
	ALPHA_FUNC_mask                                   = 0x07 << 0,
	ALPHA_FUNC_shift                                  = 0,
	    REF_NEVER                                     = 0x00,
	    REF_LESS                                      = 0x01,
	    REF_EQUAL                                     = 0x02,
	    REF_LEQUAL                                    = 0x03,
	    REF_GREATER                                   = 0x04,
	    REF_NOTEQUAL                                  = 0x05,
	    REF_GEQUAL                                    = 0x06,
	    REF_ALWAYS                                    = 0x07,
	ALPHA_TEST_ENABLE_bit                             = 1 << 3,
	ALPHA_TEST_BYPASS_bit                             = 1 << 8,
    CB_BLEND_RED                                          = 0x00028414,
    CB_BLEND_GREEN                                        = 0x00028418,
    CB_BLEND_BLUE                                         = 0x0002841c,
    CB_BLEND_ALPHA                                        = 0x00028420,
    CB_FOG_RED                                            = 0x00028424,
    CB_FOG_GREEN                                          = 0x00028428,
    CB_FOG_BLUE                                           = 0x0002842c,
    DB_STENCILREFMASK                                     = 0x00028430,
	STENCILREF_mask                                   = 0xff << 0,
	STENCILREF_shift                                  = 0,
	STENCILMASK_mask                                  = 0xff << 8,
	STENCILMASK_shift                                 = 8,
	STENCILWRITEMASK_mask                             = 0xff << 16,
	STENCILWRITEMASK_shift                            = 16,
    DB_STENCILREFMASK_BF                                  = 0x00028434,
	STENCILREF_BF_mask                                = 0xff << 0,
	STENCILREF_BF_shift                               = 0,
	STENCILMASK_BF_mask                               = 0xff << 8,
	STENCILMASK_BF_shift                              = 8,
	STENCILWRITEMASK_BF_mask                          = 0xff << 16,
	STENCILWRITEMASK_BF_shift                         = 16,
    SX_ALPHA_REF                                          = 0x00028438,
    PA_CL_VPORT_XSCALE_0                                  = 0x0002843c,
	PA_CL_VPORT_XSCALE_0_num                          = 16,
	PA_CL_VPORT_XSCALE_0_offset                       = 24,
    PA_CL_VPORT_XOFFSET_0                                 = 0x00028440,
	PA_CL_VPORT_XOFFSET_0_num                         = 16,
	PA_CL_VPORT_XOFFSET_0_offset                      = 24,
    PA_CL_VPORT_YSCALE_0                                  = 0x00028444,
	PA_CL_VPORT_YSCALE_0_num                          = 16,
	PA_CL_VPORT_YSCALE_0_offset                       = 24,
    PA_CL_VPORT_YOFFSET_0                                 = 0x00028448,
	PA_CL_VPORT_YOFFSET_0_num                         = 16,
	PA_CL_VPORT_YOFFSET_0_offset                      = 24,
    PA_CL_VPORT_ZSCALE_0                                  = 0x0002844c,
	PA_CL_VPORT_ZSCALE_0_num                          = 16,
	PA_CL_VPORT_ZSCALE_0_offset                       = 24,
    PA_CL_VPORT_ZOFFSET_0                                 = 0x00028450,
	PA_CL_VPORT_ZOFFSET_0_num                         = 16,
	PA_CL_VPORT_ZOFFSET_0_offset                      = 24,
    SPI_VS_OUT_ID_0                                       = 0x00028614,
	SPI_VS_OUT_ID_0_num                               = 10,
	SEMANTIC_0_mask                                   = 0xff << 0,
	SEMANTIC_0_shift                                  = 0,
	SEMANTIC_1_mask                                   = 0xff << 8,
	SEMANTIC_1_shift                                  = 8,
	SEMANTIC_2_mask                                   = 0xff << 16,
	SEMANTIC_2_shift                                  = 16,
	SEMANTIC_3_mask                                   = 0xff << 24,
	SEMANTIC_3_shift                                  = 24,
    SPI_PS_INPUT_CNTL_0                                   = 0x00028644,
	SPI_PS_INPUT_CNTL_0_num                           = 32,
	SEMANTIC_mask                                     = 0xff << 0,
	SEMANTIC_shift                                    = 0,
	DEFAULT_VAL_mask                                  = 0x03 << 8,
	DEFAULT_VAL_shift                                 = 8,
	    X_0_0F                                        = 0x00,
	FLAT_SHADE_bit                                    = 1 << 10,
	SEL_CENTROID_bit                                  = 1 << 11,
	SEL_LINEAR_bit                                    = 1 << 12,
	CYL_WRAP_mask                                     = 0x0f << 13,
	CYL_WRAP_shift                                    = 13,
	PT_SPRITE_TEX_bit                                 = 1 << 17,
	SEL_SAMPLE_bit                                    = 1 << 18,
    SPI_VS_OUT_CONFIG                                     = 0x000286c4,
	VS_PER_COMPONENT_bit                              = 1 << 0,
	VS_EXPORT_COUNT_mask                              = 0x1f << 1,
	VS_EXPORT_COUNT_shift                             = 1,
	VS_EXPORTS_FOG_bit                                = 1 << 8,
	VS_OUT_FOG_VEC_ADDR_mask                          = 0x1f << 9,
	VS_OUT_FOG_VEC_ADDR_shift                         = 9,
    SPI_PS_IN_CONTROL_0                                   = 0x000286cc,
	NUM_INTERP_mask                                   = 0x3f << 0,
	NUM_INTERP_shift                                  = 0,
	POSITION_ENA_bit                                  = 1 << 8,
	POSITION_CENTROID_bit                             = 1 << 9,
	POSITION_ADDR_mask                                = 0x1f << 10,
	POSITION_ADDR_shift                               = 10,
	PARAM_GEN_mask                                    = 0x0f << 15,
	PARAM_GEN_shift                                   = 15,
	PARAM_GEN_ADDR_mask                               = 0x7f << 19,
	PARAM_GEN_ADDR_shift                              = 19,
	BARYC_SAMPLE_CNTL_mask                            = 0x03 << 26,
	BARYC_SAMPLE_CNTL_shift                           = 26,
	    CENTROIDS_ONLY                                = 0x00,
	    CENTERS_ONLY                                  = 0x01,
	    CENTROIDS_AND_CENTERS                         = 0x02,
	    UNDEF                                         = 0x03,
	PERSP_GRADIENT_ENA_bit                            = 1 << 28,
	LINEAR_GRADIENT_ENA_bit                           = 1 << 29,
	POSITION_SAMPLE_bit                               = 1 << 30,
	BARYC_AT_SAMPLE_ENA_bit                           = 1 << 31,
    SPI_PS_IN_CONTROL_1                                   = 0x000286d0,
	GEN_INDEX_PIX_bit                                 = 1 << 0,
	GEN_INDEX_PIX_ADDR_mask                           = 0x7f << 1,
	GEN_INDEX_PIX_ADDR_shift                          = 1,
	FRONT_FACE_ENA_bit                                = 1 << 8,
	FRONT_FACE_CHAN_mask                              = 0x03 << 9,
	FRONT_FACE_CHAN_shift                             = 9,
	FRONT_FACE_ALL_BITS_bit                           = 1 << 11,
	FRONT_FACE_ADDR_mask                              = 0x1f << 12,
	FRONT_FACE_ADDR_shift                             = 12,
	FOG_ADDR_mask                                     = 0x7f << 17,
	FOG_ADDR_shift                                    = 17,
	FIXED_PT_POSITION_ENA_bit                         = 1 << 24,
	FIXED_PT_POSITION_ADDR_mask                       = 0x1f << 25,
	FIXED_PT_POSITION_ADDR_shift                      = 25,
    SPI_INTERP_CONTROL_0                                  = 0x000286d4,
	FLAT_SHADE_ENA_bit                                = 1 << 0,
	PNT_SPRITE_ENA_bit                                = 1 << 1,
	PNT_SPRITE_OVRD_X_mask                            = 0x07 << 2,
	PNT_SPRITE_OVRD_X_shift                           = 2,
	    SPI_PNT_SPRITE_SEL_0                          = 0x00,
	    SPI_PNT_SPRITE_SEL_1                          = 0x01,
	    SPI_PNT_SPRITE_SEL_S                          = 0x02,
	    SPI_PNT_SPRITE_SEL_T                          = 0x03,
	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04,
	PNT_SPRITE_OVRD_Y_mask                            = 0x07 << 5,
	PNT_SPRITE_OVRD_Y_shift                           = 5,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_OVRD_Z_mask                            = 0x07 << 8,
	PNT_SPRITE_OVRD_Z_shift                           = 8,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_OVRD_W_mask                            = 0x07 << 11,
	PNT_SPRITE_OVRD_W_shift                           = 11,
/* 	    SPI_PNT_SPRITE_SEL_0                          = 0x00, */
/* 	    SPI_PNT_SPRITE_SEL_1                          = 0x01, */
/* 	    SPI_PNT_SPRITE_SEL_S                          = 0x02, */
/* 	    SPI_PNT_SPRITE_SEL_T                          = 0x03, */
/* 	    SPI_PNT_SPRITE_SEL_NONE                       = 0x04, */
	PNT_SPRITE_TOP_1_bit                              = 1 << 14,
    SPI_INPUT_Z                                           = 0x000286d8,
	PROVIDE_Z_TO_SPI_bit                              = 1 << 0,
    SPI_FOG_CNTL                                          = 0x000286dc,
	PASS_FOG_THROUGH_PS_bit                           = 1 << 0,
	PIXEL_FOG_FUNC_mask                               = 0x03 << 1,
	PIXEL_FOG_FUNC_shift                              = 1,
	    SPI_FOG_NONE                                  = 0x00,
	    SPI_FOG_EXP                                   = 0x01,
	    SPI_FOG_EXP2                                  = 0x02,
	    SPI_FOG_LINEAR                                = 0x03,
	PIXEL_FOG_SRC_SEL_bit                             = 1 << 3,
	VS_FOG_CLAMP_DISABLE_bit                          = 1 << 4,
    SPI_FOG_FUNC_SCALE                                    = 0x000286e0,
    SPI_FOG_FUNC_BIAS                                     = 0x000286e4,
    CB_BLEND0_CONTROL                                     = 0x00028780,
	CB_BLEND0_CONTROL_num                             = 8,
	COLOR_SRCBLEND_mask                               = 0x1f << 0,
	COLOR_SRCBLEND_shift                              = 0,
	COLOR_COMB_FCN_mask                               = 0x07 << 5,
	COLOR_COMB_FCN_shift                              = 5,
	COLOR_DESTBLEND_mask                              = 0x1f << 8,
	COLOR_DESTBLEND_shift                             = 8,
	OPACITY_WEIGHT_bit                                = 1 << 13,
	ALPHA_SRCBLEND_mask                               = 0x1f << 16,
	ALPHA_SRCBLEND_shift                              = 16,
	ALPHA_COMB_FCN_mask                               = 0x07 << 21,
	ALPHA_COMB_FCN_shift                              = 21,
	ALPHA_DESTBLEND_mask                              = 0x1f << 24,
	ALPHA_DESTBLEND_shift                             = 24,
	SEPARATE_ALPHA_BLEND_bit                          = 1 << 29,
    VGT_DMA_BASE_HI                                       = 0x000287e4,
	VGT_DMA_BASE_HI__BASE_ADDR_mask                   = 0xff << 0,
	VGT_DMA_BASE_HI__BASE_ADDR_shift                  = 0,
    VGT_DMA_BASE                                          = 0x000287e8,
    VGT_DRAW_INITIATOR                                    = 0x000287f0,
	SOURCE_SELECT_mask                                = 0x03 << 0,
	SOURCE_SELECT_shift                               = 0,
	    DI_SRC_SEL_DMA                                = 0x00,
	    DI_SRC_SEL_IMMEDIATE                          = 0x01,
	    DI_SRC_SEL_AUTO_INDEX                         = 0x02,
	    DI_SRC_SEL_RESERVED                           = 0x03,
	MAJOR_MODE_mask                                   = 0x03 << 2,
	MAJOR_MODE_shift                                  = 2,
	    DI_MAJOR_MODE_0                               = 0x00,
	    DI_MAJOR_MODE_1                               = 0x01,
	SPRITE_EN_bit                                     = 1 << 4,
	NOT_EOP_bit                                       = 1 << 5,
	USE_OPAQUE_bit                                    = 1 << 6,
    VGT_IMMED_DATA                                        = 0x000287f4,
    VGT_EVENT_ADDRESS_REG                                 = 0x000287f8,
	ADDRESS_LOW_mask                                  = 0xfffffff << 0,
	ADDRESS_LOW_shift                                 = 0,
    DB_DEPTH_CONTROL                                      = 0x00028800,
	STENCIL_ENABLE_bit                                = 1 << 0,
	Z_ENABLE_bit                                      = 1 << 1,
	Z_WRITE_ENABLE_bit                                = 1 << 2,
	ZFUNC_mask                                        = 0x07 << 4,
	ZFUNC_shift                                       = 4,
	    FRAG_NEVER                                    = 0x00,
	    FRAG_LESS                                     = 0x01,
	    FRAG_EQUAL                                    = 0x02,
	    FRAG_LEQUAL                                   = 0x03,
	    FRAG_GREATER                                  = 0x04,
	    FRAG_NOTEQUAL                                 = 0x05,
	    FRAG_GEQUAL                                   = 0x06,
	    FRAG_ALWAYS                                   = 0x07,
	BACKFACE_ENABLE_bit                               = 1 << 7,
	STENCILFUNC_mask                                  = 0x07 << 8,
	STENCILFUNC_shift                                 = 8,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	STENCILFAIL_mask                                  = 0x07 << 11,
	STENCILFAIL_shift                                 = 11,
	    STENCIL_KEEP                                  = 0x00,
	    STENCIL_ZERO                                  = 0x01,
	    STENCIL_REPLACE                               = 0x02,
	    STENCIL_INCR_CLAMP                            = 0x03,
	    STENCIL_DECR_CLAMP                            = 0x04,
	    STENCIL_INVERT                                = 0x05,
	    STENCIL_INCR_WRAP                             = 0x06,
	    STENCIL_DECR_WRAP                             = 0x07,
	STENCILZPASS_mask                                 = 0x07 << 14,
	STENCILZPASS_shift                                = 14,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZFAIL_mask                                 = 0x07 << 17,
	STENCILZFAIL_shift                                = 17,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILFUNC_BF_mask                               = 0x07 << 20,
	STENCILFUNC_BF_shift                              = 20,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	STENCILFAIL_BF_mask                               = 0x07 << 23,
	STENCILFAIL_BF_shift                              = 23,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZPASS_BF_mask                              = 0x07 << 26,
	STENCILZPASS_BF_shift                             = 26,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
	STENCILZFAIL_BF_mask                              = 0x07 << 29,
	STENCILZFAIL_BF_shift                             = 29,
/* 	    STENCIL_KEEP                                  = 0x00, */
/* 	    STENCIL_ZERO                                  = 0x01, */
/* 	    STENCIL_REPLACE                               = 0x02, */
/* 	    STENCIL_INCR_CLAMP                            = 0x03, */
/* 	    STENCIL_DECR_CLAMP                            = 0x04, */
/* 	    STENCIL_INVERT                                = 0x05, */
/* 	    STENCIL_INCR_WRAP                             = 0x06, */
/* 	    STENCIL_DECR_WRAP                             = 0x07, */
    CB_BLEND_CONTROL                                      = 0x00028804,
/* 	COLOR_SRCBLEND_mask                               = 0x1f << 0, */
/* 	COLOR_SRCBLEND_shift                              = 0, */
	    BLEND_ZERO                                    = 0x00,
	    BLEND_ONE                                     = 0x01,
	    BLEND_SRC_COLOR                               = 0x02,
	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03,
	    BLEND_SRC_ALPHA                               = 0x04,
	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05,
	    BLEND_DST_ALPHA                               = 0x06,
	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07,
	    BLEND_DST_COLOR                               = 0x08,
	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09,
	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a,
	    BLEND_BOTH_SRC_ALPHA                          = 0x0b,
	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c,
	    BLEND_CONSTANT_COLOR                          = 0x0d,
	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e,
	    BLEND_SRC1_COLOR                              = 0x0f,
	    BLEND_INV_SRC1_COLOR                          = 0x10,
	    BLEND_SRC1_ALPHA                              = 0x11,
	    BLEND_INV_SRC1_ALPHA                          = 0x12,
	    BLEND_CONSTANT_ALPHA                          = 0x13,
	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14,
/* 	COLOR_COMB_FCN_mask                               = 0x07 << 5, */
/* 	COLOR_COMB_FCN_shift                              = 5, */
	    COMB_DST_PLUS_SRC                             = 0x00,
	    COMB_SRC_MINUS_DST                            = 0x01,
	    COMB_MIN_DST_SRC                              = 0x02,
	    COMB_MAX_DST_SRC                              = 0x03,
	    COMB_DST_MINUS_SRC                            = 0x04,
/* 	COLOR_DESTBLEND_mask                              = 0x1f << 8, */
/* 	COLOR_DESTBLEND_shift                             = 8, */
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
/* 	OPACITY_WEIGHT_bit                                = 1 << 13, */
/* 	ALPHA_SRCBLEND_mask                               = 0x1f << 16, */
/* 	ALPHA_SRCBLEND_shift                              = 16, */
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
/* 	ALPHA_COMB_FCN_mask                               = 0x07 << 21, */
/* 	ALPHA_COMB_FCN_shift                              = 21, */
/* 	    COMB_DST_PLUS_SRC                             = 0x00, */
/* 	    COMB_SRC_MINUS_DST                            = 0x01, */
/* 	    COMB_MIN_DST_SRC                              = 0x02, */
/* 	    COMB_MAX_DST_SRC                              = 0x03, */
/* 	    COMB_DST_MINUS_SRC                            = 0x04, */
/* 	ALPHA_DESTBLEND_mask                              = 0x1f << 24, */
/* 	ALPHA_DESTBLEND_shift                             = 24, */
/* 	    BLEND_ZERO                                    = 0x00, */
/* 	    BLEND_ONE                                     = 0x01, */
/* 	    BLEND_SRC_COLOR                               = 0x02, */
/* 	    BLEND_ONE_MINUS_SRC_COLOR                     = 0x03, */
/* 	    BLEND_SRC_ALPHA                               = 0x04, */
/* 	    BLEND_ONE_MINUS_SRC_ALPHA                     = 0x05, */
/* 	    BLEND_DST_ALPHA                               = 0x06, */
/* 	    BLEND_ONE_MINUS_DST_ALPHA                     = 0x07, */
/* 	    BLEND_DST_COLOR                               = 0x08, */
/* 	    BLEND_ONE_MINUS_DST_COLOR                     = 0x09, */
/* 	    BLEND_SRC_ALPHA_SATURATE                      = 0x0a, */
/* 	    BLEND_BOTH_SRC_ALPHA                          = 0x0b, */
/* 	    BLEND_BOTH_INV_SRC_ALPHA                      = 0x0c, */
/* 	    BLEND_CONSTANT_COLOR                          = 0x0d, */
/* 	    BLEND_ONE_MINUS_CONSTANT_COLOR                = 0x0e, */
/* 	    BLEND_SRC1_COLOR                              = 0x0f, */
/* 	    BLEND_INV_SRC1_COLOR                          = 0x10, */
/* 	    BLEND_SRC1_ALPHA                              = 0x11, */
/* 	    BLEND_INV_SRC1_ALPHA                          = 0x12, */
/* 	    BLEND_CONSTANT_ALPHA                          = 0x13, */
/* 	    BLEND_ONE_MINUS_CONSTANT_ALPHA                = 0x14, */
/* 	SEPARATE_ALPHA_BLEND_bit                          = 1 << 29, */
    CB_COLOR_CONTROL                                      = 0x00028808,
	FOG_ENABLE_bit                                    = 1 << 0,
	MULTIWRITE_ENABLE_bit                             = 1 << 1,
	DITHER_ENABLE_bit                                 = 1 << 2,
	DEGAMMA_ENABLE_bit                                = 1 << 3,
	SPECIAL_OP_mask                                   = 0x07 << 4,
	SPECIAL_OP_shift                                  = 4,
	    SPECIAL_NORMAL                                = 0x00,
	    SPECIAL_DISABLE                               = 0x01,
	    SPECIAL_FAST_CLEAR                            = 0x02,
	    SPECIAL_FORCE_CLEAR                           = 0x03,
	    SPECIAL_EXPAND_COLOR                          = 0x04,
	    SPECIAL_EXPAND_TEXTURE                        = 0x05,
	    SPECIAL_EXPAND_SAMPLES                        = 0x06,
	    SPECIAL_RESOLVE_BOX                           = 0x07,
	PER_MRT_BLEND_bit                                 = 1 << 7,
	TARGET_BLEND_ENABLE_mask                          = 0xff << 8,
	TARGET_BLEND_ENABLE_shift                         = 8,
	ROP3_mask                                         = 0xff << 16,
	ROP3_shift                                        = 16,
    DB_SHADER_CONTROL                                     = 0x0002880c,
	Z_EXPORT_ENABLE_bit                               = 1 << 0,
	STENCIL_REF_EXPORT_ENABLE_bit                     = 1 << 1,
	Z_ORDER_mask                                      = 0x03 << 4,
	Z_ORDER_shift                                     = 4,
	    LATE_Z                                        = 0x00,
	    EARLY_Z_THEN_LATE_Z                           = 0x01,
	    RE_Z                                          = 0x02,
	    EARLY_Z_THEN_RE_Z                             = 0x03,
	KILL_ENABLE_bit                                   = 1 << 6,
	COVERAGE_TO_MASK_ENABLE_bit                       = 1 << 7,
	MASK_EXPORT_ENABLE_bit                            = 1 << 8,
	DUAL_EXPORT_ENABLE_bit                            = 1 << 9,
	EXEC_ON_HIER_FAIL_bit                             = 1 << 10,
	EXEC_ON_NOOP_bit                                  = 1 << 11,
    PA_CL_CLIP_CNTL                                       = 0x00028810,
	UCP_ENA_0_bit                                     = 1 << 0,
	UCP_ENA_1_bit                                     = 1 << 1,
	UCP_ENA_2_bit                                     = 1 << 2,
	UCP_ENA_3_bit                                     = 1 << 3,
	UCP_ENA_4_bit                                     = 1 << 4,
	UCP_ENA_5_bit                                     = 1 << 5,
	PS_UCP_Y_SCALE_NEG_bit                            = 1 << 13,
	PS_UCP_MODE_mask                                  = 0x03 << 14,
	PS_UCP_MODE_shift                                 = 14,
	CLIP_DISABLE_bit                                  = 1 << 16,
	UCP_CULL_ONLY_ENA_bit                             = 1 << 17,
	BOUNDARY_EDGE_FLAG_ENA_bit                        = 1 << 18,
	DX_CLIP_SPACE_DEF_bit                             = 1 << 19,
	DIS_CLIP_ERR_DETECT_bit                           = 1 << 20,
	VTX_KILL_OR_bit                                   = 1 << 21,
	DX_LINEAR_ATTR_CLIP_ENA_bit                       = 1 << 24,
	VTE_VPORT_PROVOKE_DISABLE_bit                     = 1 << 25,
	ZCLIP_NEAR_DISABLE_bit                            = 1 << 26,
	ZCLIP_FAR_DISABLE_bit                             = 1 << 27,
    PA_SU_SC_MODE_CNTL                                    = 0x00028814,
	CULL_FRONT_bit                                    = 1 << 0,
	CULL_BACK_bit                                     = 1 << 1,
	FACE_bit                                          = 1 << 2,
	POLY_MODE_mask                                    = 0x03 << 3,
	POLY_MODE_shift                                   = 3,
	    X_DISABLE_POLY_MODE                           = 0x00,
	    X_DUAL_MODE                                   = 0x01,
	POLYMODE_FRONT_PTYPE_mask                         = 0x07 << 5,
	POLYMODE_FRONT_PTYPE_shift                        = 5,
	    X_DRAW_POINTS                                 = 0x00,
	    X_DRAW_LINES                                  = 0x01,
	    X_DRAW_TRIANGLES                              = 0x02,
	POLYMODE_BACK_PTYPE_mask                          = 0x07 << 8,
	POLYMODE_BACK_PTYPE_shift                         = 8,
/* 	    X_DRAW_POINTS                                 = 0x00, */
/* 	    X_DRAW_LINES                                  = 0x01, */
/* 	    X_DRAW_TRIANGLES                              = 0x02, */
	POLY_OFFSET_FRONT_ENABLE_bit                      = 1 << 11,
	POLY_OFFSET_BACK_ENABLE_bit                       = 1 << 12,
	POLY_OFFSET_PARA_ENABLE_bit                       = 1 << 13,
	VTX_WINDOW_OFFSET_ENABLE_bit                      = 1 << 16,
	PROVOKING_VTX_LAST_bit                            = 1 << 19,
	PERSP_CORR_DIS_bit                                = 1 << 20,
	MULTI_PRIM_IB_ENA_bit                             = 1 << 21,
    PA_CL_VTE_CNTL                                        = 0x00028818,
	VPORT_X_SCALE_ENA_bit                             = 1 << 0,
	VPORT_X_OFFSET_ENA_bit                            = 1 << 1,
	VPORT_Y_SCALE_ENA_bit                             = 1 << 2,
	VPORT_Y_OFFSET_ENA_bit                            = 1 << 3,
	VPORT_Z_SCALE_ENA_bit                             = 1 << 4,
	VPORT_Z_OFFSET_ENA_bit                            = 1 << 5,
	VTX_XY_FMT_bit                                    = 1 << 8,
	VTX_Z_FMT_bit                                     = 1 << 9,
	VTX_W0_FMT_bit                                    = 1 << 10,
	PERFCOUNTER_REF_bit                               = 1 << 11,
    PA_CL_VS_OUT_CNTL                                     = 0x0002881c,
	CLIP_DIST_ENA_0_bit                               = 1 << 0,
	CLIP_DIST_ENA_1_bit                               = 1 << 1,
	CLIP_DIST_ENA_2_bit                               = 1 << 2,
	CLIP_DIST_ENA_3_bit                               = 1 << 3,
	CLIP_DIST_ENA_4_bit                               = 1 << 4,
	CLIP_DIST_ENA_5_bit                               = 1 << 5,
	CLIP_DIST_ENA_6_bit                               = 1 << 6,
	CLIP_DIST_ENA_7_bit                               = 1 << 7,
	CULL_DIST_ENA_0_bit                               = 1 << 8,
	CULL_DIST_ENA_1_bit                               = 1 << 9,
	CULL_DIST_ENA_2_bit                               = 1 << 10,
	CULL_DIST_ENA_3_bit                               = 1 << 11,
	CULL_DIST_ENA_4_bit                               = 1 << 12,
	CULL_DIST_ENA_5_bit                               = 1 << 13,
	CULL_DIST_ENA_6_bit                               = 1 << 14,
	CULL_DIST_ENA_7_bit                               = 1 << 15,
	USE_VTX_POINT_SIZE_bit                            = 1 << 16,
	USE_VTX_EDGE_FLAG_bit                             = 1 << 17,
	USE_VTX_RENDER_TARGET_INDX_bit                    = 1 << 18,
	USE_VTX_VIEWPORT_INDX_bit                         = 1 << 19,
	USE_VTX_KILL_FLAG_bit                             = 1 << 20,
	VS_OUT_MISC_VEC_ENA_bit                           = 1 << 21,
	VS_OUT_CCDIST0_VEC_ENA_bit                        = 1 << 22,
	VS_OUT_CCDIST1_VEC_ENA_bit                        = 1 << 23,
    PA_CL_NANINF_CNTL                                     = 0x00028820,
	VTE_XY_INF_DISCARD_bit                            = 1 << 0,
	VTE_Z_INF_DISCARD_bit                             = 1 << 1,
	VTE_W_INF_DISCARD_bit                             = 1 << 2,
	VTE_0XNANINF_IS_0_bit                             = 1 << 3,
	VTE_XY_NAN_RETAIN_bit                             = 1 << 4,
	VTE_Z_NAN_RETAIN_bit                              = 1 << 5,
	VTE_W_NAN_RETAIN_bit                              = 1 << 6,
	VTE_W_RECIP_NAN_IS_0_bit                          = 1 << 7,
	VS_XY_NAN_TO_INF_bit                              = 1 << 8,
	VS_XY_INF_RETAIN_bit                              = 1 << 9,
	VS_Z_NAN_TO_INF_bit                               = 1 << 10,
	VS_Z_INF_RETAIN_bit                               = 1 << 11,
	VS_W_NAN_TO_INF_bit                               = 1 << 12,
	VS_W_INF_RETAIN_bit                               = 1 << 13,
	VS_CLIP_DIST_INF_DISCARD_bit                      = 1 << 14,
	VTE_NO_OUTPUT_NEG_0_bit                           = 1 << 20,
    SQ_PGM_START_PS                                       = 0x00028840,
    SQ_PGM_RESOURCES_PS                                   = 0x00028850,
	NUM_GPRS_mask                                     = 0xff << 0,
	NUM_GPRS_shift                                    = 0,
	STACK_SIZE_mask                                   = 0xff << 8,
	STACK_SIZE_shift                                  = 8,
	SQ_PGM_RESOURCES_PS__DX10_CLAMP_bit               = 1 << 21,
	FETCH_CACHE_LINES_mask                            = 0x07 << 24,
	FETCH_CACHE_LINES_shift                           = 24,
	UNCACHED_FIRST_INST_bit                           = 1 << 28,
	CLAMP_CONSTS_bit                                  = 1 << 31,
    SQ_PGM_EXPORTS_PS                                     = 0x00028854,
	EXPORT_MODE_mask                                  = 0x1f << 0,
	EXPORT_MODE_shift                                 = 0,
    SQ_PGM_START_VS                                       = 0x00028858,
    SQ_PGM_RESOURCES_VS                                   = 0x00028868,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	SQ_PGM_RESOURCES_VS__DX10_CLAMP_bit               = 1 << 21,
/* 	FETCH_CACHE_LINES_mask                            = 0x07 << 24, */
/* 	FETCH_CACHE_LINES_shift                           = 24, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_START_GS                                       = 0x0002886c,
    SQ_PGM_RESOURCES_GS                                   = 0x0002887c,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	SQ_PGM_RESOURCES_GS__DX10_CLAMP_bit               = 1 << 21,
/* 	FETCH_CACHE_LINES_mask                            = 0x07 << 24, */
/* 	FETCH_CACHE_LINES_shift                           = 24, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_START_ES                                       = 0x00028880,
    SQ_PGM_RESOURCES_ES                                   = 0x00028890,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	SQ_PGM_RESOURCES_ES__DX10_CLAMP_bit               = 1 << 21,
/* 	FETCH_CACHE_LINES_mask                            = 0x07 << 24, */
/* 	FETCH_CACHE_LINES_shift                           = 24, */
/* 	UNCACHED_FIRST_INST_bit                           = 1 << 28, */
    SQ_PGM_START_FS                                       = 0x00028894,
    SQ_PGM_RESOURCES_FS                                   = 0x000288a4,
/* 	NUM_GPRS_mask                                     = 0xff << 0, */
/* 	NUM_GPRS_shift                                    = 0, */
/* 	STACK_SIZE_mask                                   = 0xff << 8, */
/* 	STACK_SIZE_shift                                  = 8, */
	SQ_PGM_RESOURCES_FS__DX10_CLAMP_bit               = 1 << 21,
    SQ_ESGS_RING_ITEMSIZE                                 = 0x000288a8,
	ITEMSIZE_mask                                     = 0x7fff << 0,
	ITEMSIZE_shift                                    = 0,
    SQ_GSVS_RING_ITEMSIZE                                 = 0x000288ac,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_ESTMP_RING_ITEMSIZE                                = 0x000288b0,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GSTMP_RING_ITEMSIZE                                = 0x000288b4,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_VSTMP_RING_ITEMSIZE                                = 0x000288b8,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_PSTMP_RING_ITEMSIZE                                = 0x000288bc,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_FBUF_RING_ITEMSIZE                                 = 0x000288c0,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_REDUC_RING_ITEMSIZE                                = 0x000288c4,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_GS_VERT_ITEMSIZE                                   = 0x000288c8,
/* 	ITEMSIZE_mask                                     = 0x7fff << 0, */
/* 	ITEMSIZE_shift                                    = 0, */
    SQ_PGM_CF_OFFSET_PS                                   = 0x000288cc,
	PGM_CF_OFFSET_mask                                = 0xfffff << 0,
	PGM_CF_OFFSET_shift                               = 0,
    SQ_PGM_CF_OFFSET_VS                                   = 0x000288d0,
/* 	PGM_CF_OFFSET_mask                                = 0xfffff << 0, */
/* 	PGM_CF_OFFSET_shift                               = 0, */
    SQ_PGM_CF_OFFSET_GS                                   = 0x000288d4,
/* 	PGM_CF_OFFSET_mask                                = 0xfffff << 0, */
/* 	PGM_CF_OFFSET_shift                               = 0, */
    SQ_PGM_CF_OFFSET_ES                                   = 0x000288d8,
/* 	PGM_CF_OFFSET_mask                                = 0xfffff << 0, */
/* 	PGM_CF_OFFSET_shift                               = 0, */
    SQ_PGM_CF_OFFSET_FS                                   = 0x000288dc,
/* 	PGM_CF_OFFSET_mask                                = 0xfffff << 0, */
/* 	PGM_CF_OFFSET_shift                               = 0, */
    SQ_VTX_SEMANTIC_CLEAR                                 = 0x000288e0,
    SQ_ALU_CONST_CACHE_PS_0                               = 0x00028940,
	SQ_ALU_CONST_CACHE_PS_0_num                       = 16,
    SQ_ALU_CONST_CACHE_VS_0                               = 0x00028980,
	SQ_ALU_CONST_CACHE_VS_0_num                       = 16,
    SQ_ALU_CONST_CACHE_GS_0                               = 0x000289c0,
	SQ_ALU_CONST_CACHE_GS_0_num                       = 16,
    PA_SU_POINT_SIZE                                      = 0x00028a00,
	PA_SU_POINT_SIZE__HEIGHT_mask                     = 0xffff << 0,
	PA_SU_POINT_SIZE__HEIGHT_shift                    = 0,
	PA_SU_POINT_SIZE__WIDTH_mask                      = 0xffff << 16,
	PA_SU_POINT_SIZE__WIDTH_shift                     = 16,
    PA_SU_POINT_MINMAX                                    = 0x00028a04,
	MIN_SIZE_mask                                     = 0xffff << 0,
	MIN_SIZE_shift                                    = 0,
	MAX_SIZE_mask                                     = 0xffff << 16,
	MAX_SIZE_shift                                    = 16,
    PA_SU_LINE_CNTL                                       = 0x00028a08,
	PA_SU_LINE_CNTL__WIDTH_mask                       = 0xffff << 0,
	PA_SU_LINE_CNTL__WIDTH_shift                      = 0,
    PA_SC_LINE_STIPPLE                                    = 0x00028a0c,
	LINE_PATTERN_mask                                 = 0xffff << 0,
	LINE_PATTERN_shift                                = 0,
	REPEAT_COUNT_mask                                 = 0xff << 16,
	REPEAT_COUNT_shift                                = 16,
	PATTERN_BIT_ORDER_bit                             = 1 << 28,
	AUTO_RESET_CNTL_mask                              = 0x03 << 29,
	AUTO_RESET_CNTL_shift                             = 29,
    VGT_OUTPUT_PATH_CNTL                                  = 0x00028a10,
	PATH_SELECT_mask                                  = 0x03 << 0,
	PATH_SELECT_shift                                 = 0,
	    VGT_OUTPATH_VTX_REUSE                         = 0x00,
	    VGT_OUTPATH_TESS_EN                           = 0x01,
	    VGT_OUTPATH_PASSTHRU                          = 0x02,
	    VGT_OUTPATH_GS_BLOCK                          = 0x03,
    VGT_HOS_CNTL                                          = 0x00028a14,
	TESS_MODE_mask                                    = 0x03 << 0,
	TESS_MODE_shift                                   = 0,
    VGT_HOS_MAX_TESS_LEVEL                                = 0x00028a18,
    VGT_HOS_MIN_TESS_LEVEL                                = 0x00028a1c,
    VGT_HOS_REUSE_DEPTH                                   = 0x00028a20,
	REUSE_DEPTH_mask                                  = 0xff << 0,
	REUSE_DEPTH_shift                                 = 0,
    VGT_GROUP_PRIM_TYPE                                   = 0x00028a24,
	VGT_GROUP_PRIM_TYPE__PRIM_TYPE_mask               = 0x1f << 0,
	VGT_GROUP_PRIM_TYPE__PRIM_TYPE_shift              = 0,
	    VGT_GRP_3D_POINT                              = 0x00,
	    VGT_GRP_3D_LINE                               = 0x01,
	    VGT_GRP_3D_TRI                                = 0x02,
	    VGT_GRP_3D_RECT                               = 0x03,
	    VGT_GRP_3D_QUAD                               = 0x04,
	    VGT_GRP_2D_COPY_RECT_V0                       = 0x05,
	    VGT_GRP_2D_COPY_RECT_V1                       = 0x06,
	    VGT_GRP_2D_COPY_RECT_V2                       = 0x07,
	    VGT_GRP_2D_COPY_RECT_V3                       = 0x08,
	    VGT_GRP_2D_FILL_RECT                          = 0x09,
	    VGT_GRP_2D_LINE                               = 0x0a,
	    VGT_GRP_2D_TRI                                = 0x0b,
	    VGT_GRP_PRIM_INDEX_LINE                       = 0x0c,
	    VGT_GRP_PRIM_INDEX_TRI                        = 0x0d,
	    VGT_GRP_PRIM_INDEX_QUAD                       = 0x0e,
	    VGT_GRP_3D_LINE_ADJ                           = 0x0f,
	    VGT_GRP_3D_TRI_ADJ                            = 0x10,
	RETAIN_ORDER_bit                                  = 1 << 14,
	RETAIN_QUADS_bit                                  = 1 << 15,
	PRIM_ORDER_mask                                   = 0x07 << 16,
	PRIM_ORDER_shift                                  = 16,
	    VGT_GRP_LIST                                  = 0x00,
	    VGT_GRP_STRIP                                 = 0x01,
	    VGT_GRP_FAN                                   = 0x02,
	    VGT_GRP_LOOP                                  = 0x03,
	    VGT_GRP_POLYGON                               = 0x04,
    VGT_GROUP_FIRST_DECR                                  = 0x00028a28,
	FIRST_DECR_mask                                   = 0x0f << 0,
	FIRST_DECR_shift                                  = 0,
    VGT_GROUP_DECR                                        = 0x00028a2c,
	DECR_mask                                         = 0x0f << 0,
	DECR_shift                                        = 0,
    VGT_GROUP_VECT_0_CNTL                                 = 0x00028a30,
	COMP_X_EN_bit                                     = 1 << 0,
	COMP_Y_EN_bit                                     = 1 << 1,
	COMP_Z_EN_bit                                     = 1 << 2,
	COMP_W_EN_bit                                     = 1 << 3,
	VGT_GROUP_VECT_0_CNTL__STRIDE_mask                = 0xff << 8,
	VGT_GROUP_VECT_0_CNTL__STRIDE_shift               = 8,
	SHIFT_mask                                        = 0xff << 16,
	SHIFT_shift                                       = 16,
    VGT_GROUP_VECT_1_CNTL                                 = 0x00028a34,
/* 	COMP_X_EN_bit                                     = 1 << 0, */
/* 	COMP_Y_EN_bit                                     = 1 << 1, */
/* 	COMP_Z_EN_bit                                     = 1 << 2, */
/* 	COMP_W_EN_bit                                     = 1 << 3, */
	VGT_GROUP_VECT_1_CNTL__STRIDE_mask                = 0xff << 8,
	VGT_GROUP_VECT_1_CNTL__STRIDE_shift               = 8,
/* 	SHIFT_mask                                        = 0xff << 16, */
/* 	SHIFT_shift                                       = 16, */
    VGT_GROUP_VECT_0_FMT_CNTL                             = 0x00028a38,
	X_CONV_mask                                       = 0x0f << 0,
	X_CONV_shift                                      = 0,
	    VGT_GRP_INDEX_16                              = 0x00,
	    VGT_GRP_INDEX_32                              = 0x01,
	    VGT_GRP_UINT_16                               = 0x02,
	    VGT_GRP_UINT_32                               = 0x03,
	    VGT_GRP_SINT_16                               = 0x04,
	    VGT_GRP_SINT_32                               = 0x05,
	    VGT_GRP_FLOAT_32                              = 0x06,
	    VGT_GRP_AUTO_PRIM                             = 0x07,
	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08,
	X_OFFSET_mask                                     = 0x0f << 4,
	X_OFFSET_shift                                    = 4,
	Y_CONV_mask                                       = 0x0f << 8,
	Y_CONV_shift                                      = 8,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	Y_OFFSET_mask                                     = 0x0f << 12,
	Y_OFFSET_shift                                    = 12,
	Z_CONV_mask                                       = 0x0f << 16,
	Z_CONV_shift                                      = 16,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	Z_OFFSET_mask                                     = 0x0f << 20,
	Z_OFFSET_shift                                    = 20,
	W_CONV_mask                                       = 0x0f << 24,
	W_CONV_shift                                      = 24,
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
	W_OFFSET_mask                                     = 0x0f << 28,
	W_OFFSET_shift                                    = 28,
    VGT_GROUP_VECT_1_FMT_CNTL                             = 0x00028a3c,
/* 	X_CONV_mask                                       = 0x0f << 0, */
/* 	X_CONV_shift                                      = 0, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	X_OFFSET_mask                                     = 0x0f << 4, */
/* 	X_OFFSET_shift                                    = 4, */
/* 	Y_CONV_mask                                       = 0x0f << 8, */
/* 	Y_CONV_shift                                      = 8, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	Y_OFFSET_mask                                     = 0x0f << 12, */
/* 	Y_OFFSET_shift                                    = 12, */
/* 	Z_CONV_mask                                       = 0x0f << 16, */
/* 	Z_CONV_shift                                      = 16, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	Z_OFFSET_mask                                     = 0x0f << 20, */
/* 	Z_OFFSET_shift                                    = 20, */
/* 	W_CONV_mask                                       = 0x0f << 24, */
/* 	W_CONV_shift                                      = 24, */
/* 	    VGT_GRP_INDEX_16                              = 0x00, */
/* 	    VGT_GRP_INDEX_32                              = 0x01, */
/* 	    VGT_GRP_UINT_16                               = 0x02, */
/* 	    VGT_GRP_UINT_32                               = 0x03, */
/* 	    VGT_GRP_SINT_16                               = 0x04, */
/* 	    VGT_GRP_SINT_32                               = 0x05, */
/* 	    VGT_GRP_FLOAT_32                              = 0x06, */
/* 	    VGT_GRP_AUTO_PRIM                             = 0x07, */
/* 	    VGT_GRP_FIX_1_23_TO_FLOAT                     = 0x08, */
/* 	W_OFFSET_mask                                     = 0x0f << 28, */
/* 	W_OFFSET_shift                                    = 28, */
    VGT_GS_MODE                                           = 0x00028a40,
	MODE_mask                                         = 0x03 << 0,
	MODE_shift                                        = 0,
	    GS_OFF                                        = 0x00,
	    GS_SCENARIO_A                                 = 0x01,
	    GS_SCENARIO_B                                 = 0x02,
	    GS_SCENARIO_G                                 = 0x03,
	ES_PASSTHRU_bit                                   = 1 << 2,
	CUT_MODE_mask                                     = 0x03 << 3,
	CUT_MODE_shift                                    = 3,
	    GS_CUT_1024                                   = 0x00,
	    GS_CUT_512                                    = 0x01,
	    GS_CUT_256                                    = 0x02,
	    GS_CUT_128                                    = 0x03,
    PA_SC_MPASS_PS_CNTL                                   = 0x00028a48,
	MPASS_PIX_VEC_PER_PASS_mask                       = 0xfffff << 0,
	MPASS_PIX_VEC_PER_PASS_shift                      = 0,
	MPASS_PS_ENA_bit                                  = 1 << 31,
    PA_SC_MODE_CNTL                                       = 0x00028a4c,
	MSAA_ENABLE_bit                                   = 1 << 0,
	CLIPRECT_ENABLE_bit                               = 1 << 1,
	LINE_STIPPLE_ENABLE_bit                           = 1 << 2,
	MULTI_CHIP_PRIM_DISCARD_ENAB_bit                  = 1 << 3,
	WALK_ORDER_ENABLE_bit                             = 1 << 4,
	HALVE_DETAIL_SAMPLE_PERF_bit                      = 1 << 5,
	WALK_SIZE_bit                                     = 1 << 6,
	WALK_ALIGNMENT_bit                                = 1 << 7,
	WALK_ALIGN8_PRIM_FITS_ST_bit                      = 1 << 8,
	TILE_COVER_NO_SCISSOR_bit                         = 1 << 9,
	KILL_PIX_POST_HI_Z_bit                            = 1 << 10,
	KILL_PIX_POST_DETAIL_MASK_bit                     = 1 << 11,
	MULTI_CHIP_SUPERTILE_ENABLE_bit                   = 1 << 12,
	TILE_COVER_DISABLE_bit                            = 1 << 13,
	FORCE_EOV_CNTDWN_ENABLE_bit                       = 1 << 14,
	FORCE_EOV_TILE_ENABLE_bit                         = 1 << 15,
	FORCE_EOV_REZ_ENABLE_bit                          = 1 << 16,
	PS_ITER_SAMPLE_bit                                = 1 << 17,
    VGT_ENHANCE                                           = 0x00028a50,
	VGT_ENHANCE__MI_TIMESTAMP_RES_mask                = 0x03 << 0,
	VGT_ENHANCE__MI_TIMESTAMP_RES_shift               = 0,
	    X_0_992_CLOCKS_LATENCY_RANGE_IN_STEPS_OF_32   = 0x00,
	    X_0_496_CLOCKS_LATENCY_RANGE_IN_STEPS_OF_16   = 0x01,
	    X_0_248_CLOCKS_LATENCY_RANGE_IN_STEPS_OF_8    = 0x02,
	    X_0_124_CLOCKS_LATENCY_RANGE_IN_STEPS_OF_4    = 0x03,
	MISC_mask                                         = 0x3fffffff << 2,
	MISC_shift                                        = 2,
    VGT_GS_OUT_PRIM_TYPE                                  = 0x00028a6c,
	OUTPRIM_TYPE_mask                                 = 0x3f << 0,
	OUTPRIM_TYPE_shift                                = 0,
	    POINTLIST                                     = 0x00,
	    LINESTRIP                                     = 0x01,
	    TRISTRIP                                      = 0x02,
    VGT_DMA_SIZE                                          = 0x00028a74,
    VGT_DMA_INDEX_TYPE                                    = 0x00028a7c,
/* 	INDEX_TYPE_mask                                   = 0x03 << 0, */
/* 	INDEX_TYPE_shift                                  = 0, */
	    VGT_INDEX_16                                  = 0x00,
	    VGT_INDEX_32                                  = 0x01,
	SWAP_MODE_mask                                    = 0x03 << 2,
	SWAP_MODE_shift                                   = 2,
	    VGT_DMA_SWAP_NONE                             = 0x00,
	    VGT_DMA_SWAP_16_BIT                           = 0x01,
	    VGT_DMA_SWAP_32_BIT                           = 0x02,
	    VGT_DMA_SWAP_WORD                             = 0x03,
    VGT_PRIMITIVEID_EN                                    = 0x00028a84,
	PRIMITIVEID_EN_bit                                = 1 << 0,
    VGT_DMA_NUM_INSTANCES                                 = 0x00028a88,
    VGT_EVENT_INITIATOR                                   = 0x00028a90,
	EVENT_TYPE_mask                                   = 0x3f << 0,
	EVENT_TYPE_shift                                  = 0,
	    CACHE_FLUSH_TS                                = 0x04,
	    CONTEXT_DONE                                  = 0x05,
	    CACHE_FLUSH                                   = 0x06,
	    VIZQUERY_START                                = 0x07,
	    VIZQUERY_END                                  = 0x08,
	    SC_WAIT_WC                                    = 0x09,
	    MPASS_PS_CP_REFETCH                           = 0x0a,
	    MPASS_PS_RST_START                            = 0x0b,
	    MPASS_PS_INCR_START                           = 0x0c,
	    RST_PIX_CNT                                   = 0x0d,
	    RST_VTX_CNT                                   = 0x0e,
	    VS_PARTIAL_FLUSH                              = 0x0f,
	    PS_PARTIAL_FLUSH                              = 0x10,
	    CACHE_FLUSH_AND_INV_TS_EVENT                  = 0x14,
	    ZPASS_DONE                                    = 0x15,
	    CACHE_FLUSH_AND_INV_EVENT                     = 0x16,
	    PERFCOUNTER_START                             = 0x17,
	    PERFCOUNTER_STOP                              = 0x18,
	    PIPELINESTAT_START                            = 0x19,
	    PIPELINESTAT_STOP                             = 0x1a,
	    PERFCOUNTER_SAMPLE                            = 0x1b,
	    FLUSH_ES_OUTPUT                               = 0x1c,
	    FLUSH_GS_OUTPUT                               = 0x1d,
	    SAMPLE_PIPELINESTAT                           = 0x1e,
	    SO_VGTSTREAMOUT_FLUSH                         = 0x1f,
	    SAMPLE_STREAMOUTSTATS                         = 0x20,
	    RESET_VTX_CNT                                 = 0x21,
	    BLOCK_CONTEXT_DONE                            = 0x22,
	    CR_CONTEXT_DONE                               = 0x23,
	    VGT_FLUSH                                     = 0x24,
	    CR_DONE_TS                                    = 0x25,
	    SQ_NON_EVENT                                  = 0x26,
	    SC_SEND_DB_VPZ                                = 0x27,
	    BOTTOM_OF_PIPE_TS                             = 0x28,
	    DB_CACHE_FLUSH_AND_INV                        = 0x2a,
	ADDRESS_HI_mask                                   = 0xff << 19,
	ADDRESS_HI_shift                                  = 19,
	EXTENDED_EVENT_bit                                = 1 << 27,
    VGT_MULTI_PRIM_IB_RESET_EN                            = 0x00028a94,
	RESET_EN_bit                                      = 1 << 0,
    VGT_INSTANCE_STEP_RATE_0                              = 0x00028aa0,
    VGT_INSTANCE_STEP_RATE_1                              = 0x00028aa4,
    VGT_STRMOUT_EN                                        = 0x00028ab0,
	STREAMOUT_bit                                     = 1 << 0,
    VGT_REUSE_OFF                                         = 0x00028ab4,
	REUSE_OFF_bit                                     = 1 << 0,
    VGT_VTX_CNT_EN                                        = 0x00028ab8,
	VTX_CNT_EN_bit                                    = 1 << 0,
    VGT_STRMOUT_BUFFER_SIZE_0                             = 0x00028ad0,
    VGT_STRMOUT_VTX_STRIDE_0                              = 0x00028ad4,
	VGT_STRMOUT_VTX_STRIDE_0__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_0__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_0                             = 0x00028ad8,
    VGT_STRMOUT_BUFFER_OFFSET_0                           = 0x00028adc,
    VGT_STRMOUT_BUFFER_SIZE_1                             = 0x00028ae0,
    VGT_STRMOUT_VTX_STRIDE_1                              = 0x00028ae4,
	VGT_STRMOUT_VTX_STRIDE_1__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_1__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_1                             = 0x00028ae8,
    VGT_STRMOUT_BUFFER_OFFSET_1                           = 0x00028aec,
    VGT_STRMOUT_BUFFER_SIZE_2                             = 0x00028af0,
    VGT_STRMOUT_VTX_STRIDE_2                              = 0x00028af4,
	VGT_STRMOUT_VTX_STRIDE_2__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_2__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_2                             = 0x00028af8,
    VGT_STRMOUT_BUFFER_OFFSET_2                           = 0x00028afc,
    VGT_STRMOUT_BUFFER_SIZE_3                             = 0x00028b00,
    VGT_STRMOUT_VTX_STRIDE_3                              = 0x00028b04,
	VGT_STRMOUT_VTX_STRIDE_3__STRIDE_mask             = 0x3ff << 0,
	VGT_STRMOUT_VTX_STRIDE_3__STRIDE_shift            = 0,
    VGT_STRMOUT_BUFFER_BASE_3                             = 0x00028b08,
    VGT_STRMOUT_BUFFER_OFFSET_3                           = 0x00028b0c,
    VGT_STRMOUT_BASE_OFFSET_0                             = 0x00028b10,
    VGT_STRMOUT_BASE_OFFSET_1                             = 0x00028b14,
    VGT_STRMOUT_BASE_OFFSET_2                             = 0x00028b18,
    VGT_STRMOUT_BASE_OFFSET_3                             = 0x00028b1c,
    VGT_STRMOUT_BUFFER_EN                                 = 0x00028b20,
	BUFFER_0_EN_bit                                   = 1 << 0,
	BUFFER_1_EN_bit                                   = 1 << 1,
	BUFFER_2_EN_bit                                   = 1 << 2,
	BUFFER_3_EN_bit                                   = 1 << 3,
    VGT_STRMOUT_DRAW_OPAQUE_OFFSET                        = 0x00028b28,
    VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE            = 0x00028b2c,
    VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                 = 0x00028b30,
    VGT_STRMOUT_BASE_OFFSET_HI_0                          = 0x00028b44,
	VGT_STRMOUT_BASE_OFFSET_HI_0__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_0__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_1                          = 0x00028b48,
	VGT_STRMOUT_BASE_OFFSET_HI_1__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_1__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_2                          = 0x00028b4c,
	VGT_STRMOUT_BASE_OFFSET_HI_2__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_2__BASE_OFFSET_shift   = 0,
    VGT_STRMOUT_BASE_OFFSET_HI_3                          = 0x00028b50,
	VGT_STRMOUT_BASE_OFFSET_HI_3__BASE_OFFSET_mask    = 0x3f << 0,
	VGT_STRMOUT_BASE_OFFSET_HI_3__BASE_OFFSET_shift   = 0,
    PA_SC_LINE_CNTL                                       = 0x00028c00,
	BRES_CNTL_mask                                    = 0xff << 0,
	BRES_CNTL_shift                                   = 0,
	USE_BRES_CNTL_bit                                 = 1 << 8,
	EXPAND_LINE_WIDTH_bit                             = 1 << 9,
	LAST_PIXEL_bit                                    = 1 << 10,
    PA_SC_AA_CONFIG                                       = 0x00028c04,
	MSAA_NUM_SAMPLES_mask                             = 0x03 << 0,
	MSAA_NUM_SAMPLES_shift                            = 0,
	AA_MASK_CENTROID_DTMN_bit                         = 1 << 4,
	MAX_SAMPLE_DIST_mask                              = 0x0f << 13,
	MAX_SAMPLE_DIST_shift                             = 13,
    PA_SU_VTX_CNTL                                        = 0x00028c08,
	PIX_CENTER_bit                                    = 1 << 0,
	PA_SU_VTX_CNTL__ROUND_MODE_mask                   = 0x03 << 1,
	PA_SU_VTX_CNTL__ROUND_MODE_shift                  = 1,
	    X_TRUNCATE                                    = 0x00,
	    X_ROUND                                       = 0x01,
	    X_ROUND_TO_EVEN                               = 0x02,
	    X_ROUND_TO_ODD                                = 0x03,
	QUANT_MODE_mask                                   = 0x07 << 3,
	QUANT_MODE_shift                                  = 3,
	    X_1_16TH                                      = 0x00,
	    X_1_8TH                                       = 0x01,
	    X_1_4TH                                       = 0x02,
	    X_1_2                                         = 0x03,
	    X_1                                           = 0x04,
	    X_1_256TH                                     = 0x05,
    PA_CL_GB_VERT_CLIP_ADJ                                = 0x00028c0c,
    PA_CL_GB_VERT_DISC_ADJ                                = 0x00028c10,
    PA_CL_GB_HORZ_CLIP_ADJ                                = 0x00028c14,
    PA_CL_GB_HORZ_DISC_ADJ                                = 0x00028c18,
    PA_SC_AA_SAMPLE_LOCS_MCTX                             = 0x00028c1c,
/* 	S0_X_mask                                         = 0x0f << 0, */
/* 	S0_X_shift                                        = 0, */
/* 	S0_Y_mask                                         = 0x0f << 4, */
/* 	S0_Y_shift                                        = 4, */
/* 	S1_X_mask                                         = 0x0f << 8, */
/* 	S1_X_shift                                        = 8, */
/* 	S1_Y_mask                                         = 0x0f << 12, */
/* 	S1_Y_shift                                        = 12, */
/* 	S2_X_mask                                         = 0x0f << 16, */
/* 	S2_X_shift                                        = 16, */
/* 	S2_Y_mask                                         = 0x0f << 20, */
/* 	S2_Y_shift                                        = 20, */
/* 	S3_X_mask                                         = 0x0f << 24, */
/* 	S3_X_shift                                        = 24, */
/* 	S3_Y_mask                                         = 0x0f << 28, */
/* 	S3_Y_shift                                        = 28, */
    PA_SC_AA_SAMPLE_LOCS_8S_WD1_MCTX                      = 0x00028c20,
/* 	S4_X_mask                                         = 0x0f << 0, */
/* 	S4_X_shift                                        = 0, */
/* 	S4_Y_mask                                         = 0x0f << 4, */
/* 	S4_Y_shift                                        = 4, */
/* 	S5_X_mask                                         = 0x0f << 8, */
/* 	S5_X_shift                                        = 8, */
/* 	S5_Y_mask                                         = 0x0f << 12, */
/* 	S5_Y_shift                                        = 12, */
/* 	S6_X_mask                                         = 0x0f << 16, */
/* 	S6_X_shift                                        = 16, */
/* 	S6_Y_mask                                         = 0x0f << 20, */
/* 	S6_Y_shift                                        = 20, */
/* 	S7_X_mask                                         = 0x0f << 24, */
/* 	S7_X_shift                                        = 24, */
/* 	S7_Y_mask                                         = 0x0f << 28, */
/* 	S7_Y_shift                                        = 28, */
    CB_CLRCMP_CONTROL                                     = 0x00028c30,
	CLRCMP_FCN_SRC_mask                               = 0x07 << 0,
	CLRCMP_FCN_SRC_shift                              = 0,
	    CLRCMP_DRAW_ALWAYS                            = 0x00,
	    CLRCMP_DRAW_NEVER                             = 0x01,
	    CLRCMP_DRAW_ON_NEQ                            = 0x04,
	    CLRCMP_DRAW_ON_EQ                             = 0x05,
	CLRCMP_FCN_DST_mask                               = 0x07 << 8,
	CLRCMP_FCN_DST_shift                              = 8,
/* 	    CLRCMP_DRAW_ALWAYS                            = 0x00, */
/* 	    CLRCMP_DRAW_NEVER                             = 0x01, */
/* 	    CLRCMP_DRAW_ON_NEQ                            = 0x04, */
/* 	    CLRCMP_DRAW_ON_EQ                             = 0x05, */
	CLRCMP_FCN_SEL_mask                               = 0x03 << 24,
	CLRCMP_FCN_SEL_shift                              = 24,
	    CLRCMP_SEL_DST                                = 0x00,
	    CLRCMP_SEL_SRC                                = 0x01,
	    CLRCMP_SEL_AND                                = 0x02,
    CB_CLRCMP_SRC                                         = 0x00028c34,
    CB_CLRCMP_DST                                         = 0x00028c38,
    CB_CLRCMP_MSK                                         = 0x00028c3c,
    PA_SC_AA_MASK                                         = 0x00028c48,
    VGT_VERTEX_REUSE_BLOCK_CNTL                           = 0x00028c58,
	VTX_REUSE_DEPTH_mask                              = 0xff << 0,
	VTX_REUSE_DEPTH_shift                             = 0,
    VGT_OUT_DEALLOC_CNTL                                  = 0x00028c5c,
	DEALLOC_DIST_mask                                 = 0x7f << 0,
	DEALLOC_DIST_shift                                = 0,
    DB_RENDER_CONTROL                                     = 0x00028d0c,
	DEPTH_CLEAR_ENABLE_bit                            = 1 << 0,
	STENCIL_CLEAR_ENABLE_bit                          = 1 << 1,
	DEPTH_COPY_bit                                    = 1 << 2,
	STENCIL_COPY_bit                                  = 1 << 3,
	RESUMMARIZE_ENABLE_bit                            = 1 << 4,
	STENCIL_COMPRESS_DISABLE_bit                      = 1 << 5,
	DEPTH_COMPRESS_DISABLE_bit                        = 1 << 6,
	COPY_CENTROID_bit                                 = 1 << 7,
	COPY_SAMPLE_mask                                  = 0x07 << 8,
	COPY_SAMPLE_shift                                 = 8,
	ZPASS_INCREMENT_DISABLE_bit                       = 1 << 11,
    DB_RENDER_OVERRIDE                                    = 0x00028d10,
	FORCE_HIZ_ENABLE_mask                             = 0x03 << 0,
	FORCE_HIZ_ENABLE_shift                            = 0,
	    FORCE_OFF                                     = 0x00,
	    FORCE_ENABLE                                  = 0x01,
	    FORCE_DISABLE                                 = 0x02,
	    FORCE_RESERVED                                = 0x03,
	FORCE_HIS_ENABLE0_mask                            = 0x03 << 2,
	FORCE_HIS_ENABLE0_shift                           = 2,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_HIS_ENABLE1_mask                            = 0x03 << 4,
	FORCE_HIS_ENABLE1_shift                           = 4,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_SHADER_Z_ORDER_bit                          = 1 << 6,
	FAST_Z_DISABLE_bit                                = 1 << 7,
	FAST_STENCIL_DISABLE_bit                          = 1 << 8,
	NOOP_CULL_DISABLE_bit                             = 1 << 9,
	FORCE_COLOR_KILL_bit                              = 1 << 10,
	FORCE_Z_READ_bit                                  = 1 << 11,
	FORCE_STENCIL_READ_bit                            = 1 << 12,
	FORCE_FULL_Z_RANGE_mask                           = 0x03 << 13,
	FORCE_FULL_Z_RANGE_shift                          = 13,
/* 	    FORCE_OFF                                     = 0x00, */
/* 	    FORCE_ENABLE                                  = 0x01, */
/* 	    FORCE_DISABLE                                 = 0x02, */
/* 	    FORCE_RESERVED                                = 0x03, */
	FORCE_QC_SMASK_CONFLICT_bit                       = 1 << 15,
	DISABLE_VIEWPORT_CLAMP_bit                        = 1 << 16,
	IGNORE_SC_ZRANGE_bit                              = 1 << 17,
    DB_HTILE_SURFACE                                      = 0x00028d24,
	HTILE_WIDTH_bit                                   = 1 << 0,
	HTILE_HEIGHT_bit                                  = 1 << 1,
	LINEAR_bit                                        = 1 << 2,
	FULL_CACHE_bit                                    = 1 << 3,
	HTILE_USES_PRELOAD_WIN_bit                        = 1 << 4,
	PRELOAD_bit                                       = 1 << 5,
	PREFETCH_WIDTH_mask                               = 0x3f << 6,
	PREFETCH_WIDTH_shift                              = 6,
	PREFETCH_HEIGHT_mask                              = 0x3f << 12,
	PREFETCH_HEIGHT_shift                             = 12,
    DB_SRESULTS_COMPARE_STATE1                            = 0x00028d2c,
	COMPAREFUNC1_mask                                 = 0x07 << 0,
	COMPAREFUNC1_shift                                = 0,
/* 	    REF_NEVER                                     = 0x00, */
/* 	    REF_LESS                                      = 0x01, */
/* 	    REF_EQUAL                                     = 0x02, */
/* 	    REF_LEQUAL                                    = 0x03, */
/* 	    REF_GREATER                                   = 0x04, */
/* 	    REF_NOTEQUAL                                  = 0x05, */
/* 	    REF_GEQUAL                                    = 0x06, */
/* 	    REF_ALWAYS                                    = 0x07, */
	COMPAREVALUE1_mask                                = 0xff << 4,
	COMPAREVALUE1_shift                               = 4,
	COMPAREMASK1_mask                                 = 0xff << 12,
	COMPAREMASK1_shift                                = 12,
	ENABLE1_bit                                       = 1 << 24,
    DB_PRELOAD_CONTROL                                    = 0x00028d30,
	START_X_mask                                      = 0xff << 0,
	START_X_shift                                     = 0,
	START_Y_mask                                      = 0xff << 8,
	START_Y_shift                                     = 8,
	MAX_X_mask                                        = 0xff << 16,
	MAX_X_shift                                       = 16,
	MAX_Y_mask                                        = 0xff << 24,
	MAX_Y_shift                                       = 24,
    DB_PREFETCH_LIMIT                                     = 0x00028d34,
	DEPTH_HEIGHT_TILE_MAX_mask                        = 0x3ff << 0,
	DEPTH_HEIGHT_TILE_MAX_shift                       = 0,
    PA_SU_POLY_OFFSET_DB_FMT_CNTL                         = 0x00028df8,
	POLY_OFFSET_NEG_NUM_DB_BITS_mask                  = 0xff << 0,
	POLY_OFFSET_NEG_NUM_DB_BITS_shift                 = 0,
	POLY_OFFSET_DB_IS_FLOAT_FMT_bit                   = 1 << 8,
    PA_SU_POLY_OFFSET_CLAMP                               = 0x00028dfc,
    PA_SU_POLY_OFFSET_FRONT_SCALE                         = 0x00028e00,
    PA_SU_POLY_OFFSET_FRONT_OFFSET                        = 0x00028e04,
    PA_SU_POLY_OFFSET_BACK_SCALE                          = 0x00028e08,
    PA_SU_POLY_OFFSET_BACK_OFFSET                         = 0x00028e0c,
    PA_CL_POINT_X_RAD                                     = 0x00028e10,
    PA_CL_POINT_Y_RAD                                     = 0x00028e14,
    PA_CL_POINT_SIZE                                      = 0x00028e18,
    PA_CL_POINT_CULL_RAD                                  = 0x00028e1c,
    PA_CL_UCP_0_X                                         = 0x00028e20,
	PA_CL_UCP_0_X_num                                 = 6,
	PA_CL_UCP_0_X_offset                              = 16,
    PA_CL_UCP_0_Y                                         = 0x00028e24,
	PA_CL_UCP_0_Y_num                                 = 6,
	PA_CL_UCP_0_Y_offset                              = 16,
    PA_CL_UCP_0_Z                                         = 0x00028e28,
	PA_CL_UCP_0_Z_num                                 = 6,
	PA_CL_UCP_0_Z_offset                              = 16,
    SQ_ALU_CONSTANT0_0                                    = 0x00030000,
    SQ_ALU_CONSTANT1_0                                    = 0x00030004,
    SQ_ALU_CONSTANT2_0                                    = 0x00030008,
    SQ_ALU_CONSTANT3_0                                    = 0x0003000c,
    SQ_VTX_CONSTANT_WORD0_0                               = 0x00038000,
    SQ_TEX_RESOURCE_WORD0_0                               = 0x00038000,
	DIM_mask                                          = 0x07 << 0,
	DIM_shift                                         = 0,
	    SQ_TEX_DIM_1D                                 = 0x00,
	    SQ_TEX_DIM_2D                                 = 0x01,
	    SQ_TEX_DIM_3D                                 = 0x02,
	    SQ_TEX_DIM_CUBEMAP                            = 0x03,
	    SQ_TEX_DIM_1D_ARRAY                           = 0x04,
	    SQ_TEX_DIM_2D_ARRAY                           = 0x05,
	    SQ_TEX_DIM_2D_MSAA                            = 0x06,
	    SQ_TEX_DIM_2D_ARRAY_MSAA                      = 0x07,
	SQ_TEX_RESOURCE_WORD0_0__TILE_MODE_mask           = 0x0f << 3,
	SQ_TEX_RESOURCE_WORD0_0__TILE_MODE_shift          = 3,
	TILE_TYPE_bit                                     = 1 << 7,
	PITCH_mask                                        = 0x7ff << 8,
	PITCH_shift                                       = 8,
	TEX_WIDTH_mask                                    = 0x1fff << 19,
	TEX_WIDTH_shift                                   = 19,
    SQ_VTX_CONSTANT_WORD1_0                               = 0x00038004,
    SQ_TEX_RESOURCE_WORD1_0                               = 0x00038004,
	TEX_HEIGHT_mask                                   = 0x1fff << 0,
	TEX_HEIGHT_shift                                  = 0,
	TEX_DEPTH_mask                                    = 0x1fff << 13,
	TEX_DEPTH_shift                                   = 13,
	SQ_TEX_RESOURCE_WORD1_0__DATA_FORMAT_mask         = 0x3f << 26,
	SQ_TEX_RESOURCE_WORD1_0__DATA_FORMAT_shift        = 26,
    SQ_VTX_CONSTANT_WORD2_0                               = 0x00038008,
	BASE_ADDRESS_HI_mask                              = 0xff << 0,
	BASE_ADDRESS_HI_shift                             = 0,
	SQ_VTX_CONSTANT_WORD2_0__STRIDE_mask              = 0x7ff << 8,
	SQ_VTX_CONSTANT_WORD2_0__STRIDE_shift             = 8,
	SQ_VTX_CONSTANT_WORD2_0__CLAMP_X_bit              = 1 << 19,
	SQ_VTX_CONSTANT_WORD2_0__DATA_FORMAT_mask         = 0x3f << 20,
	SQ_VTX_CONSTANT_WORD2_0__DATA_FORMAT_shift        = 20,
	SQ_VTX_CONSTANT_WORD2_0__NUM_FORMAT_ALL_mask      = 0x03 << 26,
	SQ_VTX_CONSTANT_WORD2_0__NUM_FORMAT_ALL_shift     = 26,
/* 	    SQ_NUM_FORMAT_NORM                            = 0x00, */
/* 	    SQ_NUM_FORMAT_INT                             = 0x01, */
/* 	    SQ_NUM_FORMAT_SCALED                          = 0x02, */
	SQ_VTX_CONSTANT_WORD2_0__FORMAT_COMP_ALL_bit      = 1 << 28,
	SQ_VTX_CONSTANT_WORD2_0__SRF_MODE_ALL_bit         = 1 << 29,
	SQ_VTX_CONSTANT_WORD2_0__ENDIAN_SWAP_mask         = 0x03 << 30,
	SQ_VTX_CONSTANT_WORD2_0__ENDIAN_SWAP_shift        = 30,
/* 	    SQ_ENDIAN_NONE                                = 0x00, */
/* 	    SQ_ENDIAN_8IN16                               = 0x01, */
/* 	    SQ_ENDIAN_8IN32                               = 0x02, */
    SQ_TEX_RESOURCE_WORD2_0                               = 0x00038008,
    SQ_VTX_CONSTANT_WORD3_0                               = 0x0003800c,
	MEM_REQUEST_SIZE_mask                             = 0x03 << 0,
	MEM_REQUEST_SIZE_shift                            = 0,
    SQ_TEX_RESOURCE_WORD3_0                               = 0x0003800c,
    SQ_TEX_RESOURCE_WORD4_0                               = 0x00038010,
	FORMAT_COMP_X_mask                                = 0x03 << 0,
	FORMAT_COMP_X_shift                               = 0,
	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00,
	    SQ_FORMAT_COMP_SIGNED                         = 0x01,
	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02,
	FORMAT_COMP_Y_mask                                = 0x03 << 2,
	FORMAT_COMP_Y_shift                               = 2,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	FORMAT_COMP_Z_mask                                = 0x03 << 4,
	FORMAT_COMP_Z_shift                               = 4,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	FORMAT_COMP_W_mask                                = 0x03 << 6,
	FORMAT_COMP_W_shift                               = 6,
/* 	    SQ_FORMAT_COMP_UNSIGNED                       = 0x00, */
/* 	    SQ_FORMAT_COMP_SIGNED                         = 0x01, */
/* 	    SQ_FORMAT_COMP_UNSIGNED_BIASED                = 0x02, */
	SQ_TEX_RESOURCE_WORD4_0__NUM_FORMAT_ALL_mask      = 0x03 << 8,
	SQ_TEX_RESOURCE_WORD4_0__NUM_FORMAT_ALL_shift     = 8,
/* 	    SQ_NUM_FORMAT_NORM                            = 0x00, */
/* 	    SQ_NUM_FORMAT_INT                             = 0x01, */
/* 	    SQ_NUM_FORMAT_SCALED                          = 0x02, */
	SQ_TEX_RESOURCE_WORD4_0__SRF_MODE_ALL_bit         = 1 << 10,
	SQ_TEX_RESOURCE_WORD4_0__FORCE_DEGAMMA_bit        = 1 << 11,
	SQ_TEX_RESOURCE_WORD4_0__ENDIAN_SWAP_mask         = 0x03 << 12,
	SQ_TEX_RESOURCE_WORD4_0__ENDIAN_SWAP_shift        = 12,
/* 	    SQ_ENDIAN_NONE                                = 0x00, */
/* 	    SQ_ENDIAN_8IN16                               = 0x01, */
/* 	    SQ_ENDIAN_8IN32                               = 0x02, */
	REQUEST_SIZE_mask                                 = 0x03 << 14,
	REQUEST_SIZE_shift                                = 14,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_X_mask           = 0x07 << 16,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_X_shift          = 16,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Y_mask           = 0x07 << 19,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Y_shift          = 19,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Z_mask           = 0x07 << 22,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_Z_shift          = 22,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_W_mask           = 0x07 << 25,
	SQ_TEX_RESOURCE_WORD4_0__DST_SEL_W_shift          = 25,
/* 	    SQ_SEL_X                                      = 0x00, */
/* 	    SQ_SEL_Y                                      = 0x01, */
/* 	    SQ_SEL_Z                                      = 0x02, */
/* 	    SQ_SEL_W                                      = 0x03, */
/* 	    SQ_SEL_0                                      = 0x04, */
/* 	    SQ_SEL_1                                      = 0x05, */
	BASE_LEVEL_mask                                   = 0x0f << 28,
	BASE_LEVEL_shift                                  = 28,
    SQ_TEX_RESOURCE_WORD5_0                               = 0x00038014,
	LAST_LEVEL_mask                                   = 0x0f << 0,
	LAST_LEVEL_shift                                  = 0,
	BASE_ARRAY_mask                                   = 0x1fff << 4,
	BASE_ARRAY_shift                                  = 4,
	LAST_ARRAY_mask                                   = 0x1fff << 17,
	LAST_ARRAY_shift                                  = 17,
    SQ_TEX_RESOURCE_WORD6_0                               = 0x00038018,
	MPEG_CLAMP_mask                                   = 0x03 << 0,
	MPEG_CLAMP_shift                                  = 0,
	    SQ_TEX_MPEG_CLAMP_OFF                         = 0x00,
	    SQ_TEX_MPEG_9                                 = 0x01,
	    SQ_TEX_MPEG_10                                = 0x02,
	PERF_MODULATION_mask                              = 0x07 << 5,
	PERF_MODULATION_shift                             = 5,
	INTERLACED_bit                                    = 1 << 8,
	SQ_TEX_RESOURCE_WORD6_0__TYPE_mask                = 0x03 << 30,
	SQ_TEX_RESOURCE_WORD6_0__TYPE_shift               = 30,
	    SQ_TEX_VTX_INVALID_TEXTURE                    = 0x00,
	    SQ_TEX_VTX_INVALID_BUFFER                     = 0x01,
	    SQ_TEX_VTX_VALID_TEXTURE                      = 0x02,
	    SQ_TEX_VTX_VALID_BUFFER                       = 0x03,
    SQ_VTX_CONSTANT_WORD6_0                               = 0x00038018,
	SQ_VTX_CONSTANT_WORD6_0__TYPE_mask                = 0x03 << 30,
	SQ_VTX_CONSTANT_WORD6_0__TYPE_shift               = 30,
/* 	    SQ_TEX_VTX_INVALID_TEXTURE                    = 0x00, */
/* 	    SQ_TEX_VTX_INVALID_BUFFER                     = 0x01, */
/* 	    SQ_TEX_VTX_VALID_TEXTURE                      = 0x02, */
/* 	    SQ_TEX_VTX_VALID_BUFFER                       = 0x03, */
    SQ_TEX_SAMPLER_WORD0_0                                = 0x0003c000,
	SQ_TEX_SAMPLER_WORD0_0__CLAMP_X_mask              = 0x07 << 0,
	SQ_TEX_SAMPLER_WORD0_0__CLAMP_X_shift             = 0,
	    SQ_TEX_WRAP                                   = 0x00,
	    SQ_TEX_MIRROR                                 = 0x01,
	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02,
	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03,
	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04,
	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05,
	    SQ_TEX_CLAMP_BORDER                           = 0x06,
	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07,
	CLAMP_Y_mask                                      = 0x07 << 3,
	CLAMP_Y_shift                                     = 3,
/* 	    SQ_TEX_WRAP                                   = 0x00, */
/* 	    SQ_TEX_MIRROR                                 = 0x01, */
/* 	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02, */
/* 	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03, */
/* 	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04, */
/* 	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05, */
/* 	    SQ_TEX_CLAMP_BORDER                           = 0x06, */
/* 	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07, */
	CLAMP_Z_mask                                      = 0x07 << 6,
	CLAMP_Z_shift                                     = 6,
/* 	    SQ_TEX_WRAP                                   = 0x00, */
/* 	    SQ_TEX_MIRROR                                 = 0x01, */
/* 	    SQ_TEX_CLAMP_LAST_TEXEL                       = 0x02, */
/* 	    SQ_TEX_MIRROR_ONCE_LAST_TEXEL                 = 0x03, */
/* 	    SQ_TEX_CLAMP_HALF_BORDER                      = 0x04, */
/* 	    SQ_TEX_MIRROR_ONCE_HALF_BORDER                = 0x05, */
/* 	    SQ_TEX_CLAMP_BORDER                           = 0x06, */
/* 	    SQ_TEX_MIRROR_ONCE_BORDER                     = 0x07, */
	XY_MAG_FILTER_mask                                = 0x07 << 9,
	XY_MAG_FILTER_shift                               = 9,
	    SQ_TEX_XY_FILTER_POINT                        = 0x00,
	    SQ_TEX_XY_FILTER_BILINEAR                     = 0x01,
	    SQ_TEX_XY_FILTER_BICUBIC                      = 0x02,
	XY_MIN_FILTER_mask                                = 0x07 << 12,
	XY_MIN_FILTER_shift                               = 12,
/* 	    SQ_TEX_XY_FILTER_POINT                        = 0x00, */
/* 	    SQ_TEX_XY_FILTER_BILINEAR                     = 0x01, */
/* 	    SQ_TEX_XY_FILTER_BICUBIC                      = 0x02, */
	Z_FILTER_mask                                     = 0x03 << 15,
	Z_FILTER_shift                                    = 15,
	    SQ_TEX_Z_FILTER_NONE                          = 0x00,
	    SQ_TEX_Z_FILTER_POINT                         = 0x01,
	    SQ_TEX_Z_FILTER_LINEAR                        = 0x02,
	MIP_FILTER_mask                                   = 0x03 << 17,
	MIP_FILTER_shift                                  = 17,
/* 	    SQ_TEX_Z_FILTER_NONE                          = 0x00, */
/* 	    SQ_TEX_Z_FILTER_POINT                         = 0x01, */
/* 	    SQ_TEX_Z_FILTER_LINEAR                        = 0x02, */
	BORDER_COLOR_TYPE_mask                            = 0x03 << 22,
	BORDER_COLOR_TYPE_shift                           = 22,
	    SQ_TEX_BORDER_COLOR_TRANS_BLACK               = 0x00,
	    SQ_TEX_BORDER_COLOR_OPAQUE_BLACK              = 0x01,
	    SQ_TEX_BORDER_COLOR_OPAQUE_WHITE              = 0x02,
	    SQ_TEX_BORDER_COLOR_REGISTER                  = 0x03,
	POINT_SAMPLING_CLAMP_bit                          = 1 << 24,
	TEX_ARRAY_OVERRIDE_bit                            = 1 << 25,
	DEPTH_COMPARE_FUNCTION_mask                       = 0x07 << 26,
	DEPTH_COMPARE_FUNCTION_shift                      = 26,
	    SQ_TEX_DEPTH_COMPARE_NEVER                    = 0x00,
	    SQ_TEX_DEPTH_COMPARE_LESS                     = 0x01,
	    SQ_TEX_DEPTH_COMPARE_EQUAL                    = 0x02,
	    SQ_TEX_DEPTH_COMPARE_LESSEQUAL                = 0x03,
	    SQ_TEX_DEPTH_COMPARE_GREATER                  = 0x04,
	    SQ_TEX_DEPTH_COMPARE_NOTEQUAL                 = 0x05,
	    SQ_TEX_DEPTH_COMPARE_GREATEREQUAL             = 0x06,
	    SQ_TEX_DEPTH_COMPARE_ALWAYS                   = 0x07,
	CHROMA_KEY_mask                                   = 0x03 << 29,
	CHROMA_KEY_shift                                  = 29,
	    SQ_TEX_CHROMA_KEY_DISABLED                    = 0x00,
	    SQ_TEX_CHROMA_KEY_KILL                        = 0x01,
	    SQ_TEX_CHROMA_KEY_BLEND                       = 0x02,
	LOD_USES_MINOR_AXIS_bit                           = 1 << 31,
    SQ_TEX_SAMPLER_WORD1_0                                = 0x0003c004,
	MIN_LOD_mask                                      = 0x3ff << 0,
	MIN_LOD_shift                                     = 0,
	MAX_LOD_mask                                      = 0x3ff << 10,
	MAX_LOD_shift                                     = 10,
	SQ_TEX_SAMPLER_WORD1_0__LOD_BIAS_mask             = 0xfff << 20,
	SQ_TEX_SAMPLER_WORD1_0__LOD_BIAS_shift            = 20,
    SQ_TEX_SAMPLER_WORD2_0                                = 0x0003c008,
	LOD_BIAS_SEC_mask                                 = 0xfff << 0,
	LOD_BIAS_SEC_shift                                = 0,
	MC_COORD_TRUNCATE_bit                             = 1 << 12,
	SQ_TEX_SAMPLER_WORD2_0__FORCE_DEGAMMA_bit         = 1 << 13,
	HIGH_PRECISION_FILTER_bit                         = 1 << 14,
	PERF_MIP_mask                                     = 0x07 << 15,
	PERF_MIP_shift                                    = 15,
	PERF_Z_mask                                       = 0x03 << 18,
	PERF_Z_shift                                      = 18,
	FETCH_4_bit                                       = 1 << 26,
	SAMPLE_IS_PCF_bit                                 = 1 << 27,
	SQ_TEX_SAMPLER_WORD2_0__TYPE_bit                  = 1 << 31,
    SQ_VTX_BASE_VTX_LOC                                   = 0x0003cff0,
    SQ_VTX_START_INST_LOC                                 = 0x0003cff4,
    SQ_LOOP_CONST_DX10_0                                  = 0x0003e200,
    SQ_LOOP_CONST_0                                       = 0x0003e200,
	SQ_LOOP_CONST_0__COUNT_mask                       = 0xfff << 0,
	SQ_LOOP_CONST_0__COUNT_shift                      = 0,
	INIT_mask                                         = 0xfff << 12,
	INIT_shift                                        = 12,
	INC_mask                                          = 0xff << 24,
	INC_shift                                         = 24,
    SQ_BOOL_CONST_0                                       = 0x0003e380,
	SQ_BOOL_CONST_0_num                               = 3,

} ;

#endif /* _AUTOREGS */

