//start of LhaImmediateOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaImmediateOutputStream.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.Math;
import java.util.Properties;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.SecurityException;
import java.lang.IllegalStateException;
import java.lang.IllegalArgumentException;

import java.lang.NoSuchMethodError;


/**
 * ڑꂽRandomAccessFile kf[^o͂邽߂̃[eBeBNXB<br>
 * java.util.zip.ZipOutputStream ƎC^[tFCX悤ɍB<br>
 * ks( kTCYkOTCYꍇ )̏
 * 蓮ōsȂ΂ȂȂB
 * ȉ ̂悤ȃR[hB
 * <pre>
 * LhaCompressFiles( String arcfile, File[] files ){
 *   LhaImmediateOutputStream lio = new LhaImmediateOutputStream( arcfile );
 * 
 *   for( int i = 0 ; i &lt files.length ; i++ ){
 *     RandomAccessFile raf = new RandomAccessFile( files[i] );
 *     LhaHeader header = new LhaHeader( files[i].getName() );
 *     header.setLastModified( new Date( files.lastModified() ) );
 *     header.setOriginalSize( files.length() );
 *     byte[] buffer  = new byte[8192];
 *     int    length;
 * 
 *     while( 0 &lt= ( length = raf.read( buffer ) ) ){
 *         lio.write( buffer, 0, length );
 *     }
 * <strong>
 *     if( !lio.closeEntry() ){
 *       header.setCompressMethod( CompressMethod.LH0 );
 *       lio.putNextEntry( lhaheader );
 *       raf.seek( 0 );
 *       while( 0 &lt= ( length = raf.read( buffer ) ) ){
 *           lio.write( buffer, 0, length );
 *       }
 *       lio.closeEntry();
 *     }
 * </strong>
 *   lio.close();
 * }
 * </pre>
 * i񍐂ꍇÂ悤ȏNXɉBƐi񍐂͉bԂ
 * ɂĂ͉\ȂȂB(Ⴆ΃MKoCg̃f[^ꍇ)
 * LhaRetainedOutputStream ŔÂ悤ȎԂ邽߂ɐ݌vĂB<br>
 * ܂AJDK 1.1 ȑOł RandomAccessFile  setLength Ȃ߁A
 * Ƀf[^̌ɑ̃f[^ꍇłt@CTCY؂l߂邱ƂoȂB<br>
 * ̖_͏ɃTCY0̐Vt@CJɂĉ鎖łB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaImmediateOutputStream.java,v $
 * Revision 1.2  2002/12/11 02:25:06  dangan
 * [bug fix]
 *     jdk1.2 ŃRpCłȂӏCB
 *
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     RXgN^  String encode ̂p~A
 *     Properties Ɏ̂ǉB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.2 $
 */
public class LhaImmediateOutputStream extends OutputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private RandomAccessFile archive
    //------------------------------------------------------------------
    /**
     * Ƀt@C
     */
    private RandomAccessFile archive;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  to compress a file
    //------------------------------------------------------------------
    //  private OutputStream out
    //  private LhaHeader header
    //  private String encoding
    //  private long headerpos
    //  private CRC16 crc
    //------------------------------------------------------------------
    /**
     * kpo̓Xg[
     */
    private OutputStream out;

    /**
     * ݈k̃wb_
     */
    private LhaHeader header;

    /**
     * wb_̏o͂ɎgpGR[fBO
     */
    private String encoding;

    /**
     * wb_ʒu
     */
    private long headerpos;

    /**
     * CRClZop
     */
    private CRC16 crc;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  property
    //------------------------------------------------------------------
    //  private Properties property
    //------------------------------------------------------------------
    /**
     * ek`ɑΉ̐܂܂vpeB
     */
    private Properties property;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaImmediateOutputStream()
    //  public LhaImmediateOutputStream( String filename )
    //  public LhaImmediateOutputStream( String filename, Properties property )
    //  public LhaImmediateOutputStream( File file )
    //  public LhaImmediateOutputStream( File file, Properties property )
    //  public LhaImmediateOutputStream( RandomAccessFile archive )
    //  public LhaImmediateOutputStream( RandomAccessFile archive, Properties property )
    //  private void constructerHelper( RandomAccesFile archive, Properties property )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^
     * gps
     */
    private LhaImmediateOutputStream(){ }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaImmediateOutputStream( String filename ) 
                                                throws FileNotFoundException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            Properties property   = LhaProperty.getProperties();
        
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * 
     * @see LhaProperty
     */
    public LhaImmediateOutputStream( String filename, Properties property )
                                                  throws FileNotFoundException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * @exception IOException
     *               JDK1.2 ŃRpC邽߂ɑ݂B
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaImmediateOutputStream( File filename ) throws IOException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException, IOException(jdk1.2)
            Properties property   = LhaProperty.getProperties();
        
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * @exception IOException
     *               JDK1.2 ŃRpC邽߂ɑ݂B
     * 
     * @see LhaProperty
     */
    public LhaImmediateOutputStream( File filename, Properties property )
                                                  throws IOException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException, IOException(jdk1.2)
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * file kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file RandomAccessFile ̃CX^XB<br>
     *             <ul>
     *                <li> close() ĂȂB
     *                <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                    ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *              </ul>
     *              ̏𖞂́B
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaImmediateOutputStream( RandomAccessFile file ){

        if( file != null ){
            Properties property   = LhaProperty.getProperties();
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "out" );
        }
    }

    /**
     * file kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file     RandomAccessFile ̃CX^XB<br>
     *                 <ul>
     *                   <li> close() ĂȂB
     *                   <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                       ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *                 </ul>
     *                 ̏𖞂́B
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @see LhaProperty
     */
    public LhaImmediateOutputStream( RandomAccessFile file, 
                                     Properties       property ){

        if( file != null
         && property != null ){

            this.constructerHelper( file, property );                           //throws UnsupportedEncodingException

        }else if( file == null ){
            throw new NullPointerException( "null" );
        }else{
            throw new NullPointerException( "property" );
        }

    }

    /**
     * RXgN^̏S郁\bhB
     * 
     * @param file     RandomAccessFile ̃CX^XB<br>
     *                 <ul>
     *                   <li> close() ĂȂB
     *                   <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                       ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *                 </ul>
     *                 ̏𖞂́B
     * @param property ek`ɑΉ̐܂܂vpeB
     */
    private void constructerHelper( RandomAccessFile file, 
                                    Properties       property ){

        this.archive   = file;

        this.out       = null;
        this.header    = null;
        this.headerpos = -1;
        this.crc       = new CRC16();
        this.property  = property;
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ݂̃Gg1oCg̃f[^ށB
     * 
     * @param data ރf[^
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( int data ) throws IOException {
        if( this.out != null ){
            if( this.header != null ){
                crc.update( data );
            }

            this.out.write( data );
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ݂̃Gg buffer̓eSďoB
     * 
     * @param buffer of[^̓oCgz
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer ) throws IOException {
        this.write( buffer, 0, buffer.length );
    }

    /**
     * ݂̃Gg buffer index
     * lengthoCg̃f[^oB
     * 
     * @param buffer of[^̓oCgz
     * @param index  buffeȑoׂf[^̊Jnʒu
     * @param length f[^̃oCg
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer, int index, int length ) throws IOException {
        if( this.out != null ){
            if( this.header != null ){
                crc.update( buffer, index, length );
            }

            this.out.write( buffer, index, length );
        }else{
            throw new IOException( "no entry" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ݏݒ̃Gg̃f[^Iɏo͐ɏoB
     *  PostLzssEncoder, LzssOutputStream ̋Kǂ
     * flush() ȂꍇƂ͕ʂ̃f[^o͂B
     * (̏ꍇ PɈkቺ邾łB)
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see LzssOutputStream#flush()
     */
    public void flush() throws IOException {
        if( this.out != null ){
            this.out.flush();                                                   //throws IOException
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * o͐ɑSẴf[^o͂AXg[B<br>
     * ܂AgpĂSẴ\[XB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if( this.out != null ){
            this.closeEntry();                                                  //throws IOException
        }

        //^[~l[^o
        this.archive.write( 0 );                                                //throws IOException
        try{
            this.archive.setLength( this.archive.getFilePointer() );            //After Java1.2 throws IOException
        }catch( NoSuchMethodError error ){
        }
        this.archive.close();                                                   //throws IOException
        this.archive = null;

        this.crc      = null;
        this.property = null;
        this.encoding = null;
    }


    //------------------------------------------------------------------
    //  original method ( on the model of java.util.zip.ZipOutputStream  )
    //------------------------------------------------------------------
    //  manipulate entry
    //------------------------------------------------------------------
    //  public void putNextEntry( LhaHeader header )
    //  public void putNextEntryAlreadyCompressed( LhaHeader header )
    //  public void putNextEntryNotYetCompressed( LhaHeader header )
    //  public void closeEntry()
    //------------------------------------------------------------------
    /**
     * VGgނ悤ɃXg[ݒ肷B<br>
     * ̃\bh Ɉkς݂̃Gg̏ꍇ
     * putNextEntryAlreadyCompressed(),
     * ɈkĂȂꍇ
     * putNextEntryNotYetCompressed() ĂяoB<br>
     * kĂ邩̔́A
     * <ul>
     *   <li>header.getCompressedSize()<br>
     *   <li>header.getCRC()<br>
     * </ul>
     * ̂ǂꂩł LhaHeader.UNKNOWN łΖɈkĂȂƂB<br>
     * header ɂ͐m OriginalSize w肳ĂKvB<br>
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *                        header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     */
    public void putNextEntry( LhaHeader header ) throws IOException {
        if( header.getCompressedSize() == LhaHeader.UNKNOWN
         || header.getCRC()            == LhaHeader.UNKNOWN ){
            this.putNextEntryNotYetCompressed( header );                        //throws IOException
        }else{
            this.putNextEntryAlreadyCompressed( header );                       //throws IOException
        }
    }

    /**
     * Ɉkς݂̃Ggނ悤ɃXg[ݒ肷B<br>
     * kς݃f[^́AĂяoۏ؂鎖B
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *               <ol>
     *                  <li>header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getComressedSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getCRC()  LhaHeader.UNKNOWN Ԃꍇ
     *               </ol>
     *               ̉ꂩB
     * @exception IllegalStateException
     *               ȑÕGg closeEntry() ĂȂꍇ
     */
    public void putNextEntryAlreadyCompressed( LhaHeader header )
                                                            throws IOException {

        if( this.out == null ){

            if( header.getOriginalSize()   != LhaHeader.UNKNOWN
             && header.getCompressedSize() != LhaHeader.UNKNOWN
             && header.getCRC()            != LhaHeader.UNKNOWN ){

                this.headerpos = this.archive.getFilePointer();

                this.encoding = this.property.getProperty( "lha.encoding" );
                if( this.encoding == null ){
                    this.encoding = LhaProperty.getProperty( "lha.encoding" );
                }

                this.archive.write( header.getBytes( encoding ) );                  //throws IOException
                this.out = new RandomAccessFileOutputStream( this.archive, header.getCompressedSize() );

            }else if( header.getOriginalSize() == LhaHeader.UNKNOWN ){
                throw new IllegalArgumentException( "OriginalSize must not \"LhaHeader.UNKNOWN\"." );
            }else if( header.getCompressedSize() == LhaHeader.UNKNOWN ){
                throw new IllegalArgumentException( "CompressedSize must not \"LhaHeader.UNKNOWN\"." );
            }else{
                throw new IllegalArgumentException( "CRC must not \"LhaHeader.UNKNOWN\"." );
            }

        }else{
            throw new IllegalStateException( "entry is not closed." );
        }
    }

    /**
     * ɈkĂȂGgނ悤ɃXg[
     * ݒ肷Bheader  CompressedSize,CRCw肳ĂĂ
     * B̃\bhɓn header ɂ
     * LhaHeader.setOriginalSize() p mȃIWiTCY
     * w肳ĂKvB
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *                        header.getOriginalSize() 
     *                        LhaHeader.UNKNOWN Ԃꍇ
     * @exception IllegalStateException
     *                        ȑÕGg
     *                        closeEntry() ĂȂꍇ
     */
    public void putNextEntryNotYetCompressed( LhaHeader header ) 
                                                        throws IOException {

        if( out == null ){

            if( header.getOriginalSize() != LhaHeader.UNKNOWN ){

                this.crc.reset();
                this.headerpos = this.archive.getFilePointer();
                this.header    = (LhaHeader)header.clone();
                this.header.setCompressedSize( 0 );
                this.header.setCRC( 0 );

                this.encoding = this.property.getProperty( "lha.encoding" );
                if( this.encoding == null ){
                    this.encoding = LhaProperty.getProperty( "lha.encoding" );
                }

                this.archive.write( this.header.getBytes( encoding ) );
                this.out = new RandomAccessFileOutputStream( this.archive, header.getOriginalSize() );
                this.out = CompressMethod.connectEncoder( this.out, 
                                                          header.getCompressMethod(), 
                                                          this.property  );

            }else{
                throw new IllegalArgumentException( "OriginalSize must not \"LhaHeader.UNKNOWN\"." );
            }

        }else{
            throw new IllegalStateException( "entry is not closed." );
        }
    }

    /**
     * ݏo͒̃GgÃGgo͉\ȏԂɂB<br>
     * putNextEntryNotYetCompressed() ŊJGgꍇ
     * ̃\bh͈kɎs(kTCYkOTCY)ꍇA
     * GgŜݐ  RandomAccessFile 폜B<br>
     * ̍폜͒P t@C|C^ GgJnʒu܂Ŋ߂Ȃ̂
     * RandomAccessFile  setLength()  jdk1.1 ȑOł 
     * Gg𖳈k(͑̈k@)ōďo͂ȂꍇA
     * Ƀf[^̏I[ȍ~ɈkɎssSȃf[^c܂܂ɂȂB<br>
     * 
     * @return Ggo͂ꂽꍇ trueA
     *         kOk̕TCY傫Ȃ߁A
     *         Gg폜ꂽꍇ falseB
     *         ܂Aݏ̃Ggꍇ true ԂB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public boolean closeEntry() throws IOException {
        if( this.out != null ){

            this.out.close();
            if( this.header != null ){

                long pos = this.archive.getFilePointer();
                long size = ( pos - this.headerpos
                                  - this.header.getBytes( this.encoding ).length );

                this.header.setCompressedSize( size );
                if( this.header.getCRC() != LhaHeader.NO_CRC ){
                    this.header.setCRC( (int)this.crc.getValue() );
                }

                this.archive.seek( this.headerpos );
                if( this.header.getCompressMethod().equals( CompressMethod.LH0 )
                 || this.header.getCompressMethod().equals( CompressMethod.LHD )
                 || this.header.getCompressMethod().equals( CompressMethod.LZ4 )
                 || this.header.getCompressedSize() < this.header.getOriginalSize() ){

                    this.archive.write( this.header.getBytes( this.encoding ) );
                    this.archive.seek( pos );
                    this.header = null;
                    this.out    = null;
                    return true;
                }else{
                    this.header = null;
                    this.out    = null;
                    return false;
                }
            }else{
                this.out    = null;
                return true;
            }
        }else{
            return true;
        }
    }


    //------------------------------------------------------------------
    //  inner classes
    //------------------------------------------------------------------
    //  private static class RandomAccessFileOutputStream
    //------------------------------------------------------------------
    /**
     * RandomAccessFileOutputStream̃C^tFCXɍ킹邽߂̃bpNX
     */
    private static class RandomAccessFileOutputStream extends OutputStream {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  sink
        //------------------------------------------------------------------
        //  private RandomAccessFile archive
        //------------------------------------------------------------------
        /**
         * o͐RandomAccessFile
         */
        private RandomAccessFile archive;

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  position
        //------------------------------------------------------------------
        //  private long pos
        //  private long limit
        //------------------------------------------------------------------
        /**
         * ݏʒu
         */
        private long pos;

        /**
         * i[E
         */
        private long limit;

        //------------------------------------------------------------------
        //  consutructor
        //------------------------------------------------------------------
        //  public RandomAccessFileOutputStream( RandomAccessFile archive,
        //                                       long length )
        //------------------------------------------------------------------
        /**
         * RandomAccessFile bv OutputStream \zB
         * 
         * @param archive o͐RandomAccessFile
         * @param length  o͌E
         * 
         * @exception IOException o̓G[G[ꍇ
         */
        public RandomAccessFileOutputStream( RandomAccessFile archive,
                                             long length ) throws IOException {
            this.archive = archive;
            this.pos     = this.archive.getFilePointer();                       //throws IOException
            this.limit   = this.pos + length;
        }

        //------------------------------------------------------------------
        //  method of java.io.OutputStream
        //------------------------------------------------------------------
        //  write
        //------------------------------------------------------------------
        //  public void write( int data )
        //  public void write( byte[] buffer )
        //  public void write( byte[] buffer, int index, int length )
        //------------------------------------------------------------------
        /**
         * ڑꂽRandomAccessFile1oCgށB<br>
         * RXgN^ɓnꂽE𒴂ďƂꍇ
         * sȂB
         * 
         * @param data 1bytẽf[^
         * 
         * @exception IOException  o̓G[ꍇ
         */
        public void write( int data ) throws IOException {
            if( this.pos < this.limit ){
                this.pos++;
                this.archive.write( data );                                     //throws IOException
            }
        }

        /**
         * ڑꂽRandomAccessFilebuffer̓eSďށB
         * RXgN^ɓnꂽE𒴂ďƂꍇ
         * sȂB
         * 
         * @param buffer ރf[^̓oCgz
         * 
         * @exception IOException  o̓G[ꍇ
         */
        public void write( byte[] buffer ) throws IOException {
            this.write( buffer, 0, buffer.length );                             //throws IOException
        }

        /**
         * ڑꂽRandomAccessFilebuffer̓eindex lengthoCgށB
         * RXgN^ɓnꂽE𒴂ďƂꍇ
         * sȂB
         * 
         * @param buffer ރf[^̓oCgz
         * @param index  buffeȑރf[^̊Jnʒu
         * @param length ރf[^
         * 
         * @exception IOException  o̓G[ꍇ
         */
        public void write( byte[] buffer, int index, int length )
                                                        throws IOException {

            if( this.limit < this.pos + length ){
                length = (int)Math.max( this.limit - this.pos, 0 );
            }
            this.archive.write( buffer, index, length );                        //throws IOException
            this.pos += length;
        }

        //------------------------------------------------------------------
        //  method of java.io.OutputStream
        //------------------------------------------------------------------
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ̃Xg[ gpĂ\[XJB<br>
         */
        public void close(){
            this.archive = null;
        }

    }

}
//end of LhaImmediateOutputStream.java
