---
name: Bug Report
about: File an issue about a bug
title: "[BUG] "
---


Make sure you've completed the following steps before submitting your issue -- thank you!

1. Make sure you've read the [documentation][]. Your issue may be addressed there.
2. Search the [issue tracker][] to verify that this hasn't already been reported. +1 or comment there if it has.
3. Consider asking first in the [Gitter chat room][].
4. Include a self-contained and minimal piece of code that reproduces the problem. If that's not possible, try to make the description as clear as possible.
    a. If possible, make a PR with a new, failing test to give us a starting point to work on!

[documentation]: https://pybind11.readthedocs.io
[issue tracker]: https://github.com/pybind/pybind11/issues
[Gitter chat room]: https://gitter.im/pybind/Lobby

*After reading, remove this checklist and the template text in parentheses below.*

## Issue description

(Provide a short description, state the expected behavior and what actually happens.)

## Reproducible example code

(The code should be minimal, have no external dependencies, isolate the function(s) that cause breakage. Submit matched and complete C++ and Python snippets that can be easily compiled and run to diagnose the issue.)
