## Security issues

If you have found a security related issue, please do not file an issue on
GitHub or send a PR addressing the issue. Contact
[Jonas](mailto:jonas.nicklas@gmail.com) directly. You will be given public
credit for your disclosure.

## Reporting issues

Please try to answer the following questions in your bug report:

- What did you do?
- What did you expect to happen?
- What happened instead?

Make sure to include as much relevant information as possible. Ruby version,
Pundit version, OS version and any stack traces you have are very valuable.

## Pull Requests

- **Add tests!** Your patch won't be accepted if it doesn't have tests.

- **Document any change in behaviour**. Make sure the README and any other
  relevant documentation are kept up-to-date.

- **Create topic branches**. Please don't ask us to pull from your master branch.

- **One pull request per feature**. If you want to do more than one thing, send
  multiple pull requests.

- **Send coherent history**. Make sure each individual commit in your pull
  request is meaningful. If you had to make multiple intermediate commits while
  developing, please squash them before sending them to us.
