--[[
Copyright (C) 2013-2018 Draios Inc dba Sysdig.

This file is part of sysdig.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

--]]

view_info = 
{
	id = "spy_syslog",
	name = "Spy Syslog",
	description = "Show the entries written to syslog.",
	tips = {"This view can be applied to the whole system, to watch overall syslog activity, but is also useful when applied to a container or a process. In that case, the view will only show the syslog writes generated by the selected entity."},
	tags = {"Default"},
	view_type = "list",
	applies_to = {"", "container.id", "proc.pid", "thread.nametid", "proc.name", "thread.tid", "fd.sport", "fd.sproto", "k8s.pod.id", "k8s.rc.id", "k8s.rs.id", "k8s.svc.id", "k8s.ns.id", "marathon.app.id", "marathon.group.name", "mesos.task.id", "mesos.framework.name"},
	filter = "fd.name contains /dev/log and evt.is_io_write=true and evt.dir=< and evt.failed=false",
	columns = 
	{
		{
			name = "PID",
			field = "proc.pid",
			description = "PID of the process generating the message.",
			colsize = 8,
		},
		{
			name = "PROC",
			field = "proc.name",
			description = "Name of the process generating the message.",
			colsize = 8,
		},
		{
			name = "FAC",
			field = "syslog.facility.str",
			description = "syslog facility of the message.",
			colsize = 8,
		},
		{
			name = "SEV",
			field = "syslog.severity.str",
			description = "syslog severity of the message.",
			colsize = 8,
		},
		{
			tags = {"containers"},
			name = "Container",
			field = "container.name",
			colsize = 20
		},
		{
			name = "MESSAGE",
			field = "syslog.message",
			description = "Message sent to syslog",
			colsize = 0
		}
	}
}
