
DEBUG=1

PROJ=wintest

LDEBUG=/m /co
LNODEBUG=/m
DBGOBJS=
NODBGOBJS=
ADEBUG=-DDEBUG -Zi
CDEBUG=-Od -Zi

BOGUS_OBJS=bogus.obj bogusa.obj
PROJ_OBJS=$(PROJ).obj

CC=cl
LINK=link /F
RC=rc
MAPSYM=mapsym
AS=masm
ASFLAT=masm5
LINKFLAT=link386

!IF $(DEBUG)
AFLAGS=-p -w2 -Mx -I..\..\include $(ADEBUG)
LFLAGS=/batch /nologo /NOI /NOD /NOP $(LDEBUG)
CFLAGS=-nologo -G2 -A$(MODEL) -I..\..\include -Aw -W4 -Gs -Oas -Zpe $(CDEBUG)
!ELSE
AFLAGS=-p -w2 -Mx -I..\..\include
LFLAGS=/batch /nologo /NOI /NOD /NOP $(LNODEBUG)
CFLAGS=-nologo -G2 -A$(MODEL) -I..\..\include -Aw -W4 -Gs -Oas -Zpe
!ENDIF

.asm.obj:
	$(AS) $(AFLAGS) $* ;

.asm.lst:
	$(AS) -l $(AFLAGS) $* ;

all: bogus.dll $(PROJ).exe

bogusa.obj: bogusa.asm

bogusa.lst: bogusa.asm

bogus.obj: bogus.c 
    $(CC) -c $(CFLAGS) -NT_TEXT $*.c

bogus.lnk: makefile
	if exist $@ del $@
	echo $(BOGUS_OBJS) >>$@
	echo bogus.dll >>$@
	echo bogus.map	   >>$@
	echo /NOI /NOD:$(MODEL)libce libw $(MODEL)dllcew >>$@
	echo bogus.def ;   >>$@

bogus.dll: $(BOGUS_OBJS) bogus.def bogus.res bogus.lnk
    $(LINK) $(LFLAGS) @bogus.lnk
    $(RC) bogus.res $@
    $(MAPSYM) bogus

bogus.lib: bogus.dll
    implib $@ $*.dll

$(PROJ).obj: $(PROJ).c
    $(CC) -c $(CFLAGS) -NT_TEXT $*.c

$(PROJ).lnk: makefile
	if exist $@ del $@
	echo $(PROJ_OBJS) >>$@
	echo $(PROJ).exe >>$@
	echo $(PROJ).map     >>$@
	echo /NOI /NOD:$(MODEL)libce libw bogus $(MODEL)libcew >>$@
	echo $(PROJ).def ;   >>$@

$(PROJ).exe: $(BOGUS_OBJS) $(PROJ).def $(PROJ).res $(PROJ).lnk bogus.lib
    $(LINK) $(LFLAGS) @$(PROJ).lnk
    $(RC) $(PROJ).res $@
    $(MAPSYM) $(PROJ)
