/* find_prev_wnd(): Find the main window of the previous
   instance by searching all top-level windows */
HWND                   prev_wnd;
FARPROC                find_prev_wndi;
BOOL CALLBACK _export  find_prev_wnd(HWND wnd, LPARAM lParam)
   {
   /* Look for a top-level window having the same instance */
   if (!GetParent(wnd) && GetWindowWord(wnd, GWW_HINSTANCE) ==
      (HINSTANCE)lParam)
      {
      prev_wnd = wnd;
      return FALSE; /* Stop enumerating */
      }
    return TRUE; /* Continue enumerating */
   } /* find_prev_wnd() */
/* Main application function */
int pascal    WinMain(HINSTANCE hinst, HINSTANCE hPrevInst,
                      LPSTR pCmdLine, int Show)
   {
   /* If there is a previous task instance, return to it */
   if (hPrevInst)
      {
      find_prev_wndi =
         MakeProcInstance((FARPROC)find_prev_wnd, instance);
      EnumWindows(find_prev_wndi, hPrevInst);
      FreeProcInstance(find_prev_wndi);

      /* Window not found error */
      if (!prev_wnd)
         return 0; /* Fail silently */

      /* Return to the last active popup window, if any,
         of the previous instance */
      prev_wnd = GetLastActivePopup(prev_wnd);

      /* If the existing window is minimized, restore it */
      ShowWindow(prev_wnd, SW_SHOWNORMAL);
      SetActiveWindow(prev_wnd);
      return 0;
      } /* There is a previous instance */
   . . .
   } /* WinMain() */
      
