/*                         USAGE.C
**
*/
#include <stdio.h>
#include <string.h>
#include "config.h"

/****************** usage () ******************/

usage() {
#ifdef COMPRESS
	fprintf(stderr,"\nusage: "PACK_PROGRAM_NAME
	  " [-f] [-oPATH] <filename> [filename...]\n");
#else
	fprintf(stderr,"\nusage: "UNPACK_PROGRAM_NAME
	  " [-f] [-oPATH] <filename> [filename...]\n");
#endif
	fprintf(stderr,"       -f for: force"
	 " overwrite of existing file\n");
	fprintf(stderr,"       -o followed by"
	 " name of output directory\n");
	fprintf(stderr,
	 "\nSpecify any number of compressed files\n");
	fprintf(stderr,
	  "Arguments may appear in any order.\n");
}


/*********** get_arguments() *********************/

char **get_arguments(int argc, char **argv,
	 int *overwrite, char *output_directory) {

char **filelist, **fileptr;

	/* We build our own list of pointers to
	** filenames on command line. */

	filelist = fileptr =
	 (char **)(malloc(argc * sizeof(*argv)));
    *filelist = NULL;

	 /* Process flags. All flags are optional.
	 * if a string is left, must be input filename. */

	for (argc--, argv++; argc > 0; argc--, argv++) {
        if (**argv == '-') {    /* A flag argument */
			while (*++(*argv)) {
				/* Process all flags in this arg */
                switch (**argv) {
					case 'f': /*force*/
                    case 'F':
						*overwrite = 1;
						argv++;
						break;
					case 'o':  /*output_directory*/
					case 'O':
						strcpy(output_directory,
						  (*argv+1));
						argv++;
						break;
                    default:
						fprintf(stderr,
						 "Unknown flag: '%c'; ", **argv);
                        usage();
                        exit(1);
				} /* switch*/
            }
        }
        else {          /* Input file name */
			*fileptr++ = *argv;
            *fileptr = NULL;
        }
		continue;
    }
	return filelist;
}
