/*
** Exception Library -- General exception handling for ANSI C programs
** 
** Copyright (C) 1992 Computational Vision and Active Perception Lab. (CVAP),
**                    Royal Institute of Technology, Stockholm.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library (see COPYING-LIB); if not, write to 
** the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
** USA.
** 
**                            Written by
**
**                   Harald Winroth, Matti Rendahl
**         Computational Vision and Active Perception Laboratory
**		    Royal Institute of Technology
**			  S-100 44 Stockholm
**				Sweden
**
** Report bugs to candela-bug@bion.kth.se, and direct all inquiries to 
** candela@bion.kth.se.
**
*/

/*
 * NOTE: This header file should be included in source files which _define_
 * excErr structures. It must _not_ be included in any other header file.
 */

#include <exception/exc-err.h>

/*
 * Now redefine the EXC_ERR_CREATE macro defined in exc-err.h to also
 * declare AND define the excErr structures.
 */

#undef EXC_ERR_DESCRIPTION

#define EXC_ERR_DESCRIPTION(NAME, REST)					      \
  EXC_ERR_DECLARE(NAME, REST);						      \
  EXC_ERR_DEFINE(NAME, REST)
