/*
** Exception Library -- General exception handling for ANSI C programs
** 
** Copyright (C) 1993 Computational Vision and Active Perception Lab. (CVAP),
**                    Royal Institute of Technology, Stockholm.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library (see COPYING-LIB); if not, write to 
** the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
** USA.
** 
**                            Written by
**                                 
**                  Harald Winroth, Matti Rendahl
**      Computational Vision and Active Perception Laboratory
**                  Royal Institute of Technology
**                        S-100 44 Stockholm
**                              Sweden
**                                 
** Report bugs to candela-bug@bion.kth.se, and direct all inquiries to 
** candela@bion.kth.se.
**
*/

/*
 * exc-sig-macros.h.
 *
 * This file contains macros for expanding a list of signal names to a type 
 * definition (excSigDomain), a structure initialization (exc_sig) and an
 * exception handler (exc_sig_handler).
 */

#ifndef _exception_exc_sig_macros_h
#define _exception_exc_sig_macros_h

/*
 * Iterators
 */

#define _EXC_SIG_EVAL_1A(OP, F1, F2, F3, ARGS) OP(F1, ARGS, _EXC_SIG_EVAL_1B)
#define _EXC_SIG_EVAL_1B(OP, F1, F2, F3, ARGS) OP(F1, ARGS, _EXC_SIG_EVAL_1A)

#define _EXC_SIG_EVAL_2A(OP, F1, F2, F3, ARGS) OP(F2, ARGS, _EXC_SIG_EVAL_2B)
#define _EXC_SIG_EVAL_2B(OP, F1, F2, F3, ARGS) OP(F2, ARGS, _EXC_SIG_EVAL_2A)

#define _EXC_SIG_EVAL_3A(OP, F1, F2, F3, ARGS) OP(F3, ARGS, _EXC_SIG_EVAL_3B)
#define _EXC_SIG_EVAL_3B(OP, F1, F2, F3, ARGS) OP(F3, ARGS, _EXC_SIG_EVAL_3A)

#define _EXC_SIG_EVAL_1(FORMS) _EXC_SIG_EVAL_1A FORMS
#define _EXC_SIG_EVAL_2(FORMS) _EXC_SIG_EVAL_2A FORMS
#define _EXC_SIG_EVAL_3(FORMS) _EXC_SIG_EVAL_3A FORMS

#define _EXC_SIG_APPLY(FUNC, ARGS, NEXT) FUNC ARGS NEXT
#define _EXC_SIG_APPLY_STOP(FUNC, ARGS, NEXT) FUNC ARGS

/*
 * Misc
 */ 

#define _EXC_SIG_ALLOW_SEMICOLON_HERE					      \
    extern int _exc_sig_allow_semicolon_here /* dummy declaration */

/*
 * Signal name entries
 */

#define _EXC_SIG_ENTRY_DCL(UP_NAME, LOW_NAME, PRINT_NAME)		      \
    excSig LOW_NAME;

#define _EXC_SIG_ENTRY_DEF(UP_NAME, LOW_NAME, PRINT_NAME)		      \
    {PRINT_NAME, UP_NAME},

#define _EXC_SIG_ENTRY_HDL(UP_NAME, LOW_NAME, PRINT_NAME)		      \
    case UP_NAME: THROW_TYPED (exc_sig.LOW_NAME, exc_sig_type);

#define _EXC_SIG_ENTRY(UP_NAME, LOW_NAME)				      \
  (_EXC_SIG_APPLY, _EXC_SIG_ENTRY_DCL, _EXC_SIG_ENTRY_DEF, _EXC_SIG_ENTRY_HDL,\
   (UP_NAME, LOW_NAME, #UP_NAME))

/*
 * Signal struct
 */

#define _EXC_SIG_DCL1() typedef struct {
#define _EXC_SIG_DCL2() excSig unknown; } excSigDomain

#define _EXC_SIG_DEF1() excSigDomain exc_sig = {
#define _EXC_SIG_DEF2() {"<unknown signal>", 0}}

/*
  * Exception handler.
  *
  * Note: This signal handler may be exited with a longjmp. The signal mask
  * will not be restored in that case. Therefore, the mask must be reset
  * before the corresponding exception is thrown. For SYSV, this has been
  * taken care of by specifying SA_NODEFER to sigaction. For BSD, we
  * manipulate the mask directly.
 */

#if defined(SVR4) || defined(SYSV) || defined(_SYSV_)
#define _EXC_SIG_HDL1() 						      \
    void exc_sig_handler (_EXC_SIG_HANDLER_ARGS(sig))			      \
    { 									      \
	switch (sig) 							      \
	{
#else
#define _EXC_SIG_HDL1() 						      \
    void exc_sig_handler (_EXC_SIG_HANDLER_ARGS(sig))			      \
    { 									      \
	sigsetmask (sigblock (0) & ~sigmask(sig));			      \
	switch (sig) 							      \
	{
#endif
#define _EXC_SIG_HDL2()							      \
        default:							      \
	    THROW_TYPED (exc_sig.unknown, exc_sig_type);		      \
	}								      \
    } 									      \
    _EXC_SIG_ALLOW_SEMICOLON_HERE

/*
 * Resulting declaration/definition
 */

#define _EXC_SIG_FORMS(LIST)						      \
  (_EXC_SIG_APPLY, _EXC_SIG_DCL1, _EXC_SIG_DEF1, _EXC_SIG_HDL1, ())	      \
  LIST									      \
  (_EXC_SIG_APPLY_STOP, _EXC_SIG_DCL2, _EXC_SIG_DEF2, _EXC_SIG_HDL2, ())

#define _EXC_SIG_DECLARE(LIST) _EXC_SIG_EVAL_1 (_EXC_SIG_FORMS(LIST))
#define _EXC_SIG_DEFINE(LIST)  _EXC_SIG_EVAL_2 (_EXC_SIG_FORMS(LIST))
#define _EXC_SIG_HANDLER(LIST) _EXC_SIG_EVAL_3 (_EXC_SIG_FORMS(LIST))

/*
 * Let _EXC_SIG expand to a declaration only (it will be redefined later).
 */

#define _EXC_SIG(LIST) _EXC_SIG_DECLARE (LIST)

#endif /* !_exception_exc_sig_macros_h */
