#include "date.h"

char *month_names[12] = { "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL",
         "AUG", "SEP", "OCT", "NOV", "DEC" };

#define T0 1721060L

long dmy_to_day(int day, int month, long year, int julian)
{
   static int m[13] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 };
                 /*       Ja  Fe  Ma  Apr  May  Jun  Jul  Aug  Sep  Oct  Nov  Dec   */
   long rval;

   if( year >= 0L)
      {
      rval = year*365L + year / 4L;
      if( !julian)
         rval += -year / 100L + year / 400L;
      }
   else
      {
      rval = year*365L + (year-3L) / 4L;
      if( !julian)
         rval += - (year-99L) / 100L + (year-399L) / 400L;
      }

   if( julian)
      rval -= 2L;
   if( month < 3 && !(year % 4L))
      if( (year % 100L) || !(year % 400L) || julian)
         rval--;
   rval += (long)m[month - 1] + (long)day;
   return( rval + T0);
}

void day_to_dmy( long day, int *d, int *m, long *y, int julian)
{
   *y = ( day - T0) / 365L - 3L;
   while( dmy_to_day( 1, 1, *y, julian) < day)
      (*y)++;
   while( dmy_to_day( 1, 1, *y, julian) > day)
      (*y)--;
   for( *m = 1; dmy_to_day(0, (*m)+1, *y, julian) < day; (*m)++);
   *d = (int)( day - dmy_to_day(0, *m, *y, julian));
}
