#include <stdio.h>
#include <stdlib.h>
#include "date.h"

void main( int argc, char *argv[])
{
   int d, m;
   long jul_day, y;

   if( argc < 4)
      {
      printf( "DATTEST expects a day,  month,  and year as command line\n");
      printf( "arguments.  For example,  28 Nov 1929 would be run as:\n\n");
      printf( "dattest 28 11 1929\n");
      exit( 0);
      }

   d = atoi( argv[1]);
   m = atoi( argv[2]);
   y = atol( argv[3]);

   jul_day = dmy_to_day( d, m, y, 0);
   printf( "julian day = %ld\n", jul_day);
   day_to_dmy( jul_day, &d, &m, &y, 0);
   printf( "converted back: %d %d %ld (greg calendar)\n", d, m, y);

   day_to_dmy( jul_day, &d, &m, &y, 1);
   printf( "%d %d %ld (julian calendar)\n", d, m, y);
   jul_day = dmy_to_day( d, m, y, 1);
   printf( "converted back: day = %ld\n", jul_day);

   islam_day_to_dmy( jul_day, &d, &m, &y);
   printf( "%d %d %ld (Islamic calendar)\n", d, m, y);
   jul_day = islam_dmy_to_day( d, m, y);
   printf( "converted back: day = %ld\n", jul_day);
}
