/*** File Class Interface: file.h ***/
#include "objects.h"

DCL_METHODS(File,Object,(void))
    DCL_ABSTRACT(Seek,(long offset, int whence), long);
    DCL_ABSTRACT(Read,(void *buffer, int nbytes), int);
    DCL_ABSTRACT(Write,(void *buffer, int nbytes), int);
END_METHODS

DCL_MEMBERS(File,Object)
END_MEMBERS

#define FileSeek(file,offset,whence) \
    SEND(file,File,Seek,(offset,whence))

#define FileRead(file,buffer,nbytes) \
    SEND(file,File,Read,(buffer,nbytes))

#define FileWrite(file,buffer,nbytes) \
    SEND(file,File,Write,(buffer,nbytes))
