#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "date.h"

#define THIRTY_YEARS 10631L
#define T0 1948086L

char *leap = "aaabbbccdddeeefffgghhhiiijjkkkl";
           /* 012345678901234567890123456789 */

extern char *islam_month_name[12] = {
      "Muharram", "Safar", "Rabia I", "Rabia II", "Jumada I", "Jumada II",
      "Rajab", "Shaban", "Ramadan", "Shawwai", "Zu'lkadah", "Zu'lhijah" };

long islam_dmy_to_day(int day, int month, long year)
{
   long rval;

   month--;
   rval = (long)(year / 30L) * THIRTY_YEARS;
   year %= 30L;
   rval += year * 354L + (long)(leap[year] - 'a');
   rval += (long)((month / 2) * 59 + (month & 1) * 30 + day - 1);
   return( rval + T0);
}

void islam_day_to_dmy( long day, int *d, int *m, long *y)
{
   int i;

   *y = ((day - T0) / THIRTY_YEARS) * 30L;
   day = (day - T0) % THIRTY_YEARS;
   for( i = 1; i < 31; i++)
      if( (int)day < 354 * i + (int)(leap[i] - 'a'))
         {
         i--;
         *y += i;
         day -= (long)i * 354L + (long)(leap[i] - 'a');
         *m = 2 * (int)(day / 59L);
         if( *m == 12)        /* leap day fix */
            *m = 10;
         day -= (long)*m * 59L / 2L;
         if( day >= 30L)
            {
            day -= 30L;
            (*m)++;
            }
         *d = (int)day + 1;
         (*m)++;
         return;
         }
}
