/*** StdFile Class Implementation: stdfile.c ***/

#include "file.h"
#include "stdfile.h"

CONSTRUCTOR(StdFile,(const char *name,const char *access))
    CONSTRUCT(File,());
    this->handle = fopen(name,access);
    assert(this->handle);
END_CONSTRUCTOR

DESTRUCTOR(StdFile)
    fclose(this->handle);
END_DESTRUCTOR

METHOD(StdFile, Seek, (long offset, int whence), long)
    if (fseek(this->handle,offset,whence))
        return -1;
    return ftell(this->handle);
END_METHOD

METHOD(StdFile, Read, (void *buffer, int nbytes), int)
    if (fread(buffer,nbytes,1,this->handle) < 1)
        return -1;
    return nbytes;
END_METHOD

METHOD(StdFile, Write, (void *buffer, int nbytes), int)
    if (fwrite(buffer,nbytes,1,this->handle) < 1)
        return -1;
    return nbytes;
END_METHOD

DEF_CLASS(StdFile,File)
    REDEF_METHOD(StdFile,File,Seek);
    REDEF_METHOD(StdFile,File,Read);
    REDEF_METHOD(StdFile,File,Write);
    REDEF_METHOD(StdFile,Object,destroy);
END_CLASS
