/*** UnixFile Class Implementation: unixfile.c ***/

#include "file.h"
#include "unixfile.h"

CONSTRUCTOR(UnixFile,(const char *name,int flags,int mode))
CONSTRUCT(File,())
    this->descriptor = open(name,flags,mode);
    assert(this->descriptor >= 0);
END_CONSTRUCTOR

DESTRUCTOR(UnixFile)
    close(this->descriptor);
END_DESTRUCTOR

METHOD(UnixFile, Seek, (long offset, int whence), long)
   return lseek(this->descriptor,offset,whence);
END_METHOD

METHOD(UnixFile, Read, (void *buffer, int nbytes), int)
   return read(this->descriptor,buffer,nbytes);
END_METHOD

METHOD(UnixFile, Write, (void *buffer, int nbytes), int)
   return write(this->descriptor,buffer,nbytes);
END_METHOD

DEF_CLASS(UnixFile,File)
    REDEF_METHOD(UnixFile,File,Seek);
    REDEF_METHOD(UnixFile,File,Read);
    REDEF_METHOD(UnixFile,File,Write);
END_CLASS
