// File: invoice.cpp
// Copyright Norman Wilde 1993
// Code for the invoice example
#include "invoice.h"
#include <stdio.h>
ostream& operator << (ostream& s, Item& i) {
  s << "Item - code: " << i.prodCode
    << " quant: " << i.quant
    << " basePrice: " << i.basePrice;
  return s;
}
Item::Item(long aCode, long aQuant, float aPrice ) {
  prodCode = aCode;
  quant = aQuant;
  basePrice = aPrice;
}
float Item::value(){
  return quant * basePrice;
}
long Item::code(){
  return prodCode;
}
ItemList::ItemList(Item * anItem ) {
  theItem = anItem;
  nextItem = NULL;
}
void ItemList::addItem(Item * anItem ) {
  ItemList * newList = new ItemList(anItem);
  ItemList *i;
  for(i = this; ; i = i->next()) {
    if( NULL == i->nextItem) {
      i->nextItem = newList;
      break;
    }
  }
}
Item * ItemList::currentItem() {
  return theItem;
}
ItemList * ItemList::next() {
  return nextItem;
}
ItemList::~ItemList() {
  if (nextItem != NULL)
    delete nextItem;
  delete theItem;
}
ostream& operator << (ostream& s, Client& c) {
  s << "Client - cType: ";
  if(RETAIL == c.cType) s << "RETAIL";
  if(WHOLESALE == c.cType) s << "WHOLESALE";
  if(FOREIGN == c.cType) s << "FOREIGN";
  return s;
}
Client::Client(ClientType aClientType) {
  cType = aClientType;
}
ClientType Client::type() {
  return cType;
}
ostream& operator << (ostream&s, Invoice& i) {
  s << "Invoice - client: " << * i.iClient << "\n"
    << " items: \n";
  for(ItemList *iL = i.iList; NULL != iL; iL = iL->next())
    s << *(iL->currentItem()) << "\n";
  return s;
}
Invoice::Invoice(Client *aClient) {
  iClient = aClient;
  iList = NULL;
}
void Invoice::addItem(Item *anItem) {
  if( NULL == iList)
    iList = new ItemList(anItem);
  else
    iList->addItem(anItem);
}
float Invoice::totalDiscount(){
  switch (iClient->type()) {
    case RETAIL: return 0.0;
    case WHOLESALE: {
      float disc = 0.0;
      for ( ItemList *i = iList; i != NULL; i = i->next())
        disc += 0.1 * (i->currentItem())->value();
      return disc;
    }
    case FOREIGN: {
      float disc = 0.0;
      for ( ItemList *i = iList; i != NULL; i = i->next())
        if((i->currentItem())->code() > 1000)
          disc += 0.1 * (i->currentItem())->value();
      return disc;
    }
  }
}
