LISTING 2 - Sets and Resets Individual Bits */
/* bit1.c:  Set and reset individual bits */

#include <stdio.h>
#include <limits.h>

#define WORD     unsigned int
#define NBYTES   sizeof(WORD)
#define NBITS    (NBYTES * CHAR_BIT)
#define NXDIGITS (NBYTES * 2)

main()
{
    unsigned n = 0;
    int i;

    /* Set each bit in turn */
    for (i = 0; i < NBITS; ++i)
    {
        n |= (1u << i);
        printf("%0*X\n",NXDIGITS,n);
    }

    /* Now turn them off */
    for (i = 0; i < NBITS; ++i)
    {
        n &= ~(1u << i);
        printf("%0*X\n",NXDIGITS,n);
    }
    return 0;
}

/* Output
0001
0003
0007
000F
001F
003F
007F
00FF
01FF
03FF
07FF
0FFF
1FFF
3FFF
7FFF
FFFF
FFFE
FFFC
FFF8
FFF0
FFE0
FFC0
FF80
FF00
FE00
FC00
F800
F000
E000
C000
8000
0000
*/
