LISTING 5 - Illustrates the Bit Access Functions from bit.h
/* tbit.c:  Use bit operations from bit.h */

#include <stdio.h>
#include "bit.h"

main()
{
    int i;
    unsigned n = 0;
    size_t nb = nbits(n);

    /* Set the even bits */
    for (i = 0; i < nb; i += 2)
        n = set(n,i);
    printf("n == %04X (",n);
    fputb(n,stdout);
    printf("), count == %d\n",count(n));

    /* Toggle the upper half */
    for (i = nb/2; i < nb; ++i)
        n = toggle(n,i);
    printf("n == %04X (",n);
    fputb(n,stdout);
    printf("), count == %d\n",count(n));

    /* Reset the lower half */
    for (i = 0; i < nb/2; ++i)
        n = reset(n,i);
    printf("n == %04X (",n);
    fputb(n,stdout);
    printf("), count == %d\n",count(n));

    /* Read a bit string */
    fputs("Enter a bit string: ",stderr);
    n = fgetb(stdin);
    printf("n == %04X (",n);
    fputb(n,stdout);
    printf("), count == %d\n",count(n));

    return 0;
}

/* Sample Execution:

n == 5555 (0101010101010101), count == 8
n == AA55 (1010101001010101), count == 8
n == AA00 (1010101000000000), count == 4
Enter a bit string: 101001000100001
n == 5221 (0101001000100001), count == 5
/*
