LISTING 8 - Illustrates Bits Objects
/* tbits.c:  Test the Bits Interface */

#include <stdio.h>
#include <assert.h>
#include "bits.h"

#define NBITS 24

main()
{
    int i;
    unsigned n;
    Bits *bp = bits_create(NBITS);

    assert(bp);

    /* Set the even bits */
    for (i = 0; i < NBITS; i += 2)
        bits_set(bp,i);
    bits_put(bp,stdout);
    printf(" (%d)\n",bits_count(bp));

    /* Toggle the upper half */
    for (i = NBITS/2; i < NBITS; ++i)
        bits_toggle(bp,i);
    bits_put(bp,stdout);
    printf(" (%d)\n",bits_count(bp));

    /* Reset the lower half */
    for (i = 0; i < NBITS/2; ++i)
        bits_reset(bp,i);
    bits_put(bp,stdout);
    printf(" (%d)\n",bits_count(bp));

    /* Read a bit string */
    fputs("Enter a bit string: ",stderr);
    bits_put(bits_get(bp,stdin),stdout);
    printf(" (%d)\n",bits_count(bp));

    /* Convert to and from unsigned */
    n = bits_to_uint(bp);
    printf("n: %u\n",n);
    bp = bits_from_uint(bp,n);
    bits_put(bp,stdout);
    printf(" (%d)\n",bits_count(bp));

    /* Test any() and test() */
    printf("any? %d\n",bits_any(bp));
    printf("test(0)? %d\n",bits_test(bp,0));

    /* Test toggle and reset */
    bits_put(bits_toggle_all(bp),stdout);
    printf(" (%d)\n",bits_count(bp));
    bits_put(bits_reset_all(bp),stdout);
    printf(" (%d)\n",bits_count(bp));
    bits_put(bits_set_all(bp),stdout);
    printf(" (%d)\n",bits_count(bp));

    return 0;
}

/* Sample Execution:
010101010101010101010101 (12)
101010101010010101010101 (12)
101010101010000000000000 (6)
Enter a bit string: 101001000100001
000000000101001000100001 (5)
n: 21025
000000000101001000100001 (5)
any? 1
test(0)? 1
111111111010110111011110 (19)
000000000000000000000000 (0)
111111111111111111111111 (24)
