LISTING 11 - Illustrate Bitstr Objects
/* tbitstr.c:  Test the Bitstr Interface */

#include <stdio.h>
#include <assert.h>
#include "bitstr.h"

#define NBITS 24

main()
{
    int i;
    unsigned n;
    Bitstr *bp = bitstr_create(NBITS);

    assert(bp);

    /* Set the even bits */
    for (i = 0; i < NBITS; i += 2)
        bitstr_set(bp,i);
    bitstr_put(bp,stdout);
    printf(" (%d)\n",bitstr_count(bp));

    /* Toggle the upper half */
    for (i = NBITS/2; i < NBITS; ++i)
        bitstr_toggle(bp,i);
    bitstr_put(bp,stdout);
    printf(" (%d)\n",bitstr_count(bp));

    /* Reset the lower half */
    for (i = 0; i < NBITS/2; ++i)
        bitstr_reset(bp,i);
    bitstr_put(bp,stdout);
    printf(" (%d)\n",bitstr_count(bp));

    /* Read a bit string */
    fputs("Enter a bit string: ",stderr);
    bitstr_put(bitstr_get(bp,stdin),stdout);
    printf(" (%d)\n",bitstr_count(bp));

    printf("any? %d\n",bitstr_any(bp));
    printf("test(0)? %d\n",bitstr_test(bp,0));

    bitstr_put(bitstr_toggle_all(bp),stdout);
    printf(" (%d)\n",bitstr_count(bp));
    bitstr_put(bitstr_reset_all(bp),stdout);
    printf(" (%d)\n",bitstr_count(bp));
    bitstr_put(bitstr_set_all(bp),stdout);
    printf(" (%d)\n",bitstr_count(bp));

    return 0;
}

/* Sample Execution:
101010101010101010101010 (12)
101010101010010101010101 (12)
000000000000010101010101 (6)
Enter a bit string: 101001000100001
101001000100001000000000 (5)
any? 1
test(0)? 1
010110111011110111111111 (19)
000000000000000000000000 (0)
111111111111111111111111 (24)
/*

