		  LISTING 3
		Program Flags

/*
MyFlags.h       Program Codes and/or Errors.

The masks should be ORed with the programs' 
status variable to set the flag bit.

To clear a flag bit in the program's status 
variable AND with 1's complement of the mask.
*/

unsigned int flag=0; // Program status flag.

#define WRITEFAILED   0x0001 // Write to file failed.
#define WINSIZEICON   0x0002 // Window is minimized.
#define RETAKEDATA    0x0004 // Retry a data reading.
#define SIZEREQUEST   0x0008 // Size of window changed.
#define DEBUGPROGMAN  0x0010 // Info for debugging.
#define DATASTORED    0x0020 // Data loaded in program.
#define GRIDREQUEST   0x0040 // Display grid on graph.
#define AUTOSCALING   0x0080 // Autoscale graph.
#define INITIALIZED   0x1000 // Program variables 
// initialized from parameter file at load time.

#define ACQUIRINGDATA 0x4000 // Data acq is running.
#define USERABORT     0x8000 // User aborted last 
// operation, e.g. data acq, dialog box, program, etc.
/*
    Common Statements using the program's 
    status variable: 
    e.g. if ( IsAbort) return(FALSE);
*/
#define IsAbort         (flag &   USERABORT)
#define SetAbort        (flag |=  USERABORT)
#define ResetAbort      (flag &= ~USERABORT)

#define IsDataAcq       (flag &   ACQURINGDATA)
#define SetDataAcq      (flag |=  ACQURINGDATA)
#define ResetDataAcq    (flag &= ~ACQURINGDATA)

#define IsRetry         (flag &   RETAKEDATA)
#define SetRetry        (flag |=  RETAKEDATA)
#define ResetRetry      (flag &= ~RETAKEDATA)

#define IsDebug         (flag &   DEBUGPROGMAN)
#define SetDebug        (flag |=  DEBUGPROGMAN)
#define ResetDebug      (flag &= ~DEBUGPROGMAN)

#define IsData          (flag &   DATASTORED)
#define SetData         (flag |=  DATASTORED)
#define ResetData       (flag &= ~DATASTORED)

etc.
etc.
etc.

#define IsResize        (flag &   SIZEREQUEST)
#define SetResize       (flag |=  SIZEREQUEST)
#define ResetResize     (flag &= ~SIZEREQUEST)

