				 LISTING 1
				HEADER FILE
/*
 MyHeader.h     Constants.
*/
#define InfoMsg 0
#define VerMsg  1
#define WarnMsg 2
#define ErrMsg  3
#define BadMsg  4
#define TimMsg  ("COULD NOT SETUP TIMER")
#define TryMsg  ("COULD NOT SAMPLE POINT")
/* 
  Retry sampling data maximum of 5 times if
  any errors are encountered.
*/
#define _nDATATRIES     5

// Memory space will be available for 10 scans max.
#define nSETs   10

#define SetSampleTimer ( SetTimer(hWnd, IDM_SAMPLE, 
			 Dat.TimeDelay, 0L) )
#define SetPeriodTimer ( SetTimer(hWnd, IDM_PERIOD, 
			 Dat.ScanTime, 0L) )

#define _Wavelength     0
#define _TimeDrive      1
/*
  Data
*/
struct MyData {
  int  Mode,      // Time-drive or Wavelenght? 
       iScan,     // Array Index to current scan.
       iPnt,      // Data Array index being acquiring.
       Points,    // Maximum # of points to acquire.
       pts[nSETs];// # of points in each loaded scan.
  long TimeDelay, // Sampling delay between points.
       ScanTime;  // Max acq. time at wavelength.
  float Position, // Current point, time or wavelength.
	Start, Stop, // 1st and Last Wavelength 
		     //   in nanometers (nm).
	Step,     // Wavelength Increment in nm.
		  // Time-drive only parameters
		  // in seconds (s)
	TDStart,  // Time to begin, usually 0
	TDStop,   // Time to stop scan, e.g. 300
	TDStep;   // Time increment, e.g. 0.25
} Dat = {
  _Wavelength, 0, 0, nPOINTs, {0, NULL}, 250, 2000,
  (float) 400, (float) 700, (float) 2,  (float) 0, 
  (float) 300, (float) 0.5
};
/*
  Function prototypes.
*/
BOOL  yes_no( char * );
BOOL  Sleep( long );
BOOL  Timer( long );
BOOL  SampleTimer(HWND,unsigned,WORD,LONG);
BOOL  SampleTimerExpired(HWND,unsigned,WORD,LONG);
BOOL  SampleTimerTicked(HWND,unsigned,WORD,LONG);
BOOL  StartScan(HWND,unsigned,WORD,LONG);
BOOL  StopScan(HWND,unsigned,WORD,LONG);
BOOL  ShowBox(HWND,FARPROC,LPSTR);

long FAR PASCAL MainWndProc(HWND,unsigned,WORD,LONG);

