	      LISTING 5
  An Improved WINDOWS Timer Function

/*
  Wait until delay has expired,
  but yield control back to WINDOWS
  to let other tasks run.

  delay in milliseconds.
*/
BOOL Timer( long delay ) {
  MSG  msg;    // Windows message to process.
  long timer,  // current time
       base;   // start time.

  if ( !delay || (base=clock()) == -1L ) {
    return(FALSE);  // Return if problems
  }
  delay += base;    // Time at which to exit.
  do {
    while (PeekMessage(&msg,0,0,0, PM_REMOVE)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    if ((timer = clock()) == -1L ) return(FALSE);
  } while ( delay > timer );
  return(TRUE);
}
