EXAMPLE TWO (2):

#include <iostream.h>
#include <math.h>
#include <stdlib.h>

class fzy_set
{
    private:
        int dimension;
        fuzzy *fzy_data;
    public:
        fzy_set(const int);
        fzy_set(const fzy_set&);
        ~fzy_set(void);
        fzy_set& operator=(const fzy_set&);
        fuzzy& operator[](const int len);
        fuzzy& operator[](const int len) const;
        friend int operator<(const fzy_set&, 
                             const fzy_set&);
        friend int operator<=(const fzy_set&, 
                              const fzy_set&);
        friend int operator==(const fzy_set&,
                              const fzy_set&);
        friend int operator>=(const fzy_set&, 
                              const fzy_set&);
        friend int operator>(const fzy_set&, 
                             const fzy_set&);
        friend int operator!=(const fzy_set&, 
                              const fzy_set&);
        friend ostream& operator<<(ostream& s, 
                                   fzy_set& z);
        friend fuzzy fzy_set_max(const fzy_set&);
        friend fzy_set operator*(const fzy_set&, 
                                 const class fam_2&);
};

fzy_set::fzy_set(const int size = 1) // constructor
{
    dimension = ((size >= 0) ? size : 1);
    fzy_data = new fuzzy[dimension];
    return;
}

fzy_set::fzy_set(const fzy_set& fzy_set_in)
{
    fzy_data = new fuzzy[dimension 
             = fzy_set_in.dimension];
    memcpy(fzy_data, fzy_set_in.fzy_data, 
            dimension * sizeof (fuzzy));
    return;
}

fzy_set::~fzy_set(void)
{
    delete[] fzy_data;
    return;
}

fzy_set& fzy_set::operator=(const fzy_set& r_value)
{
    if (this != &r_value)
    {
        delete[] fzy_data;
        fzy_data = new fuzzy(r_value.dimension);
        memcpy(fzy_data, r_value.fzy_data,
               r_value.dimension 
                * sizeof(fuzzy));
    }
    return *this;
}

fuzzy& fzy_set::operator[](const int len)
{
    return ((len >= 0) && (len <= dimension)) ? 
           fzy_data[len] : fzy_data[0];
}

fuzzy& fzy_set::operator[](const int len) const
{
    return ((len >= 0) && (len <= dimension)) ? 
           fzy_data[len] : fzy_data[0];
}

int operator<(const fzy_set& value_a, 
              const fzy_set& value_b)
{
    auto int    result  = 0,
                ctr     = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result = (value_a[ctr] < value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return result;
}

int operator<=(const fzy_set& value_a, 
               const fzy_set& value_b)
{
    auto int    result = 0,
                ctr = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result = (value_a[ctr] 
                <= value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return result;
}

int operator==(const fzy_set& value_a, 
               const fzy_set& value_b)
{
    auto int    result = 0,
                ctr = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result = (value_a[ctr] 
               == value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return result;
}

int operator>=(const fzy_set& value_a, 
               const fzy_set& value_b)
{
    auto int    result = 0,
                ctr = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result 
        = (value_a[ctr] >= value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return result;
}

int operator>(const fzy_set& value_a, 
              const fzy_set& value_b)
{
    auto int    result = 0,
                ctr = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result = (value_a[ctr] > value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return result;
}

int operator!=(const fzy_set& value_a, 
               const fzy_set& value_b)
{
    auto int    result = 0,
                ctr = 0;

    if (value_a.dimension == value_b.dimension)
    {
        while ((result = 
             (value_a[ctr] == value_b[ctr]))
               && (ctr < value_a.dimension))
        {
            ctr++;
        }
    }
    return !result;
}

ostream& operator<<(ostream& s, fzy_set& z)
{
    static int ctr;
    s << "(";
    fuzzy *set = z.fzy_data;
    int ind = z.dimension - 1;
    for (ctr = 0; ctr < ind; ctr++)
    {
        s << *set++ << "  ";
    }
    return s << *set << ")\n";
}

fuzzy fzy_set_max(const fzy_set& set)
{
    auto fuzzy tmp_fuzzy(0.0);

    for (int i = 0; i < set.dimension; i++)
    {
        tmp_fuzzy |= set[i];
    }
    return tmp_fuzzy;
}


