/* DYN2DARR.C */

/*  Copyright 1993 by P. J. LaBrocca
    All rights reserved.

    Compiles with Microsoft C versions 6, 7 & 8 (MS-DOS)
    and Symantec THINK C 5 (Macintosh).
*/

#include <stdlib.h>

/******************
    Allocates a block of memory that can
    be accessed as a two-dimensional
    array using subscript operators.
    Use macro defined in DYN2DARR.H, Dyn2dArray,
    instead of function.
*******************/    
void **dyn2darray( unsigned row, unsigned col, 
                                 unsigned el_size )
{
    unsigned c;
    char *p = NULL;
    void **arr = (void **)
         calloc( row * sizeof( void * ) +  /* for pointers */
           row * col * el_size +           /* for elements */
           2 * sizeof( unsigned ),      /* repetition counts */
           sizeof( char )       );

    if( arr == NULL )
        return NULL;
                          /* Store row and col */
    p = (char *) arr + row * sizeof( void * );
    * (unsigned *) p = row;
    p += sizeof( unsigned );    /* p is a pointer to char */
    * (unsigned *) p = col;
    p += sizeof( unsigned );
                          /* Link rows to pointers */
    for( c = 0; c < row; ++c ) {
        arr[c] =  p + ( c * col * el_size) ;
    }

    return arr;
}
/* End of File */