/*  MAGIC.C */

/*  Copyright 1993 by P. J. LaBrocca
    All rights reserved.

    Compiles with Microsoft C versions 6, 7 & 8 (MS-DOS)
    and Symantec THINK C 5 (Macintosh).
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#if defined( THINK_C )  /* Macintosh */
#include <console.h>
#endif

#include "dyn2darr.h"

/* Prototypes */
void magic( int **, int );
void show_mag( int ** );

/*****************
    Solves a magic square puzzle as described in
    D. E. Knuth, The Art of Computer Programming,
    Volume 1/Fundamental Algorithms, 2nd Edition. p 158.
******************/
void magic( int **mag, int size )
{
    int count = 1;
    int r = 1;
    int c = (size + 1) / 2;

    mag[r][c] =  count;
    for( count = 2; count < (size * size + 1); ++count ) {
        --r;
        --c;
        if( ((r == 0) && (c == 0)) || mag[r][c] != 0 ) {
            ++c;
            r += 2;
        }
        else if( r == 0 )
            r = size;
        else if( c == 0 )
            c = size;
        mag[r][c] = count;
    }
}

/*******************
    Displays a magic square on screen.
    show_mag doesn't need to be told how big
    a side is. It gets the information
    from the macro Dyn2dRows
*********************/
void show_mag( int **mag )
{
    unsigned r, c;
    int sum = 0;

    putchar('\n');
    for( r = 1; r < Dyn2dRows( mag ); ++r ) {
        sum += mag[r][1];
        for( c = 1; c < Dyn2dCols( mag ); ++c )
            printf( "%4d", mag[r][c] );
        putchar('\n');
    }
    printf( "\nMagic Sum is %d\n", sum );
}

void main( int argc, char **argv )
{
    int side;
    int **arr;         /* For D2D array */

#if defined( THINK_C )         /* Macintosh */
    argc = ccommand( &argv );
#endif
    
    if( argc != 2 || !isdigit( *argv[1] ) ) {
        printf("\nUsage: magic 'positve odd integer'\n\n");
        exit( 0 );
    }

    side = atoi( argv[1] );
    if( side % 2 == 0 ) {
        printf("\nUsage: magic 'positve odd integer'\n\n");
        exit( 0 );
    }

    arr = (int **) Dyn2dArray( side + 1, side + 1, int );
    magic( arr, side );
    show_mag( arr );
    free( arr );
}
/* End of File */
