/* TEST.C */
/* Copyright 1993 by P. J. LaBrocca
   All rights reserved.
*/
/*
**  Torture test for Dyn2dArray()
**
**      Creates and destroys many dynamic two-dimensional
**      arrays. Displays memory usage (MS-DOS only).
**
**      Compiles with Microsoft C versions 6, 7 & 8 MS-DOS
**      and Symantec THINK C 5 (Macintosh).
*/
#include <stdio.h>
#include <stdlib.h>

#if defined( _MSC_VER )
#include <malloc.h>
#endif

#include "dyn2darr.h"

struct S {
    char c;
    double dd;
//    double xd[100];      /* force failure */
};

void main( void )
{
    int i, j, k, l;
    int high = 10; /* Increase to apply greater stress. */
    int count = 0;
//    double **d;
    struct S **d;
    struct S * **pd;
    
    for( i = 1; i < high; ++i ) {
        for( j = high; j > 0; --j ) {

#if defined( _MSC_VER )
            printf("memmax: %u ", _memmax() );
#endif
/* D2D array of structures */
            d = (struct S **) Dyn2dArray( i, j, struct S );
            if( d == NULL) {
                printf("\nOut of memory: i: %d j: %d\n",i,j );
                exit( 0 );
            }
/* D2D array of pointers-to-structures */
            pd = (struct S * **) Dyn2dArray(i, j, struct S *);
            if( pd == NULL) {
                printf("\n!!Out of memory: 2");
                exit( 0 );
            }    
//            d = Dyn2dArray( i, j, double );
            printf("******** count : %d ::d[%d][%d]******",
                    ++count, i, j );
#if defined( _MSC_VER )
            printf(" memmax: %u\n", _memmax() );
#else
            putchar('\n');
#endif

/* Assign some values */
            for( k = 0; k < i; ++k ) {
                for( l = 0; l < j; ++l  ) {
                    d[k][l].dd = k + l;
                } /* for( l = 0; l < */
            } /* for( k = 0; k < */

/* Assign addresses of structs to pointers-to-structs */
            for( k = 0; k < i; ++k ) {
                for( l = 0; l < j; ++l  ) {
                    pd[k][l] = &d[k][l];
                } /* for( l = 0; l < */
            } /* for( k = 0; k < */

/* See if everything wound up where it was supposed to go. */
            for( k = 0; k < i; ++k ) {
                for( l = 0; l < j; ++l  ) {
                    if( k + l != pd[k][l]->dd )
                        exit(0);
                    printf( "%d %d %d %d : %f",
                                i, j, k, l, pd[k][l]->dd );
                    printf( "  - r: %d -- c: %d\n",
                                     Dyn2dRows( pd ),
                                     Dyn2dCols( pd ) );
                } /* for( l = 0; l < */
            } /* for( k = 0; k < */

/* Clean up D2D arrays in preparation for new ones. */
            free( d );
            free( pd );

        } /* for( j = high; j  */
    } /* for( i = 0; i < */
} /* main */
/* End of File */
