/***************************************************/
 * HPLTIT - For plotting hardcopy on the HP LaserJet.
 ***************************************************/
void hpltit(FILE *hpfile)
{ int i,j,k,m;
  unsigned char ch, ch1, bcn[]={
  /* Reset and position cursor at 600,400 dots x,y.  
           bcn[0] - bcn[12])  */
     0x1B,0x45,0x1B,0X2A,0x70,0x36,0x30,0x30,0x78,
             0x34,0x30,0x30,0x59,
  /* Initiate raster graphics at 150 dots per inch.
           bcn[13] - bcn[19] */
     0x1B,0x2A,0x74,0x31,0x35,0x30,0x52,
  /* Start a row of graphics at current left margin.
           bcn[20] - bcn[24] */
     0x1B,0x2A,0x72,0x31,0x41,
  /* Transfer 80 bytes of raster graphics data.
           bcn[25] - bcn[30] */
     0x1B,0x2A,0x62,0x38,0x30,0x57,
  /* End graphics and reset printer
           bcn[31] - bcn[37] */
	 0x1B,0x2A,0x72,0x42,0x1B,0x45};

  /* HP graphics header */
  for (k=0; k<20; ++k) fputc(bcn[k],hpfile);
  for (j=0; j<480; ++j)
  /* HP graphics row */
  { for (k=20; k<31; ++k) fputc(bcn[k],hpfile); 
    for (k=0; k<80; ++k)
    { ch=0;
      for (i=0; i<8; ++i) 
      { if (getpixel(k*8+i,j)) ch1 = 0x80 >> i; 
        else ch1=0;
        ch=ch1 | ch;
      }
      fputc(ch,hpfile); 
    } 
  }
  /* End HP graphics, reset printer with formfeed */
  for (k=31; k<37; ++k) fputc(bcn[k],hpfile); 
}  /* End HPLTIT */

