LISTING 7 - Illustrates Namespaces

*** NOTE to EDITOR: This must be set in small type and perhaps
span across the page to stay intact - IT MUST NOT WRAP!
Thank you. ***

/* namspace.c:  Illustrate namespaces */

#include <stdio.h>

struct foo                                      /* tag-global */
{
    int foo;                                    /* global-foo-member */
};

struct foo foo;                                 /* ordinary-global
                                                   (not used) */

main()
{
    struct foo foo;                             /* tag-global, ordinary-main-1 */

    goto foo;                                   /* label-main */

foo:                                            /* label-main */
    foo.foo = 1;                                /* ordinary-main-1, global-foo-member */
    printf("struct foo == {%d}\n",foo.foo);     /* ordinary-main-1, global-foo-member */

    {
        int foo = 2;                            /* ordinary-main-2 (new scope) */
        struct foo x;                           /* tag-global */

        x.foo = foo+1;                          /* global-foo-member, ordinary-main-2 */
        printf("foo == %d\n",foo);              /* ordinary-main-2 */
        printf("struct foo == {%d}\n",x.foo);   /* global-foo-member */
    }
    return 0;
}

/* Output:
struct foo == {1}
foo == 2
struct foo == {3}
*/

