/* listing 1 */

#include <stdio.h>

int freq_match(mask, test)
   char *mask;
   char *test;
{
   static int freq_count[256];   /* the frequency */
                                 /* distribution  */
   int divergence;
   int i;

   /* freq_match("maskword", ""); */
   if (test[0] == '\0') {
      /* initialize the distribution array */
      for (i=0; i<256; i++)
         freq_count[i++] = 0;

      /* compute the distribution */
      for (i=0; mask[i] != '\0'; i++)
         freq_count[mask[i]] += 1;

      /* return a zero for initialization */
      return 0;
   } /* if */
   
   /* freq_match("don't care", "testword"); */
   else {
      /* subtract the freq. dist. of the test word */
      for (i=0; test[i]!='\0'; i++)
         freq_count[test[i]] -= 1;
	 
      /* compute the divergence */
      for (divergence=0, i=0; i<256; i++)
         divergence += abs(freq_count[i]);

      /* this code is to reset the freq. dist.  */
      /* back to the settings for the mask word */
      for (i=0; test[i]!='\0'; i++)
         freq_count[test[i]] += 1;

      return divergence;
   } /* else */
} /* freq_match() */

void main()
{
   char mask[80], test[80];

   printf("Mask:");
   gets(mask);

   printf("Test:");
   gets(test);

   freq_match(mask, "");
   printf("The divergence is %d.\n",
          freq_match("", test));
} /* main() */
