
Figure 5
--------

A program to illustrate the use of the data compression functions.

#include <stdio.h>
#include <string.h>
#define MAIN
#include "hufftree.h"

#define MAXBUF 1024

/*
     --------------------------- filer - main ------------------------------
*/

main(int argc, char *argv[])
{
  FILE *ftree, *indx, *in, *out;
  long nrecs, end, zero = 0;
  int inlen, outlen;
  char bufin[MAXBUF];
  char bufout[MAXBUF];
  long ncharin = 0, ncharout = 0;

  if (argc != 3)
  { fprintf(stderr,"Usage: %s input output\n", argv[0]);
    exit(0);
  }

  if ((in = fopen(argv[1], "rb")) == NULL)
  { fprintf(stderr,"Unable to open input file %s\n", argv[1]);
    exit(1);
  }

  if ((out = fopen(argv[2], "wb")) == NULL)
  { fprintf(stderr,"Unable to open output file %s\n", argv[2]);
    exit(1);
  }

  /* read in Huffman tree */
  if ((ftree = fopen("htree.dat","rb")) == NULL)
  { fprintf(stderr,"Unable to open htree.dat\n");
    exit(1);
  }
  else
  { fread(&root, sizeof(root), 1, ftree);
    fread(ht, sizeof(ht), 1, ftree);
    fclose(ftree);
  }

  /* create index file */
  if ((indx = fopen("index", "wb")) == NULL)
  { fprintf(stderr,"Unable to open index file index\n");
    exit(1);
  }
  else
  { fwrite(&zero, sizeof(zero), 1, indx);
    fwrite(&zero, sizeof(zero), 1, indx);
    nrecs = 0;
    end = 0;
  }

  while (fgets(bufin, MAXBUF-1, in) != NULL)
  { inlen = strlen(bufin);
    ncharin += inlen;
    outlen = 0;
    compress(inlen, bufin, &outlen, (char *)bufout);
    ncharout += outlen;
    nrecs++;
    end += outlen;
    fwrite(&end, sizeof(end), 1, indx);
    fwrite(bufout, sizeof(char), outlen, out);
  }
  rewind(indx);
  fwrite(&nrecs, sizeof(nrecs), 1, indx);

  printf("avg chars/record in: %.2f  out:%.2f\n",
    (float)ncharin/nrecs, (float)ncharout/nrecs);
  printf("compression ratio: %.3f\n",(float)ncharout/(float)ncharin);
}

