

Figure 6
--------

A program to illustrate the use of the data decompression function.


#include <stdio.h>
#define MAIN
#include "hufftree.h"

#define MAXBUF 1024

/*
     --------------------------- unfiler - main ------------------------------
*/

main(int argc, char *argv[])
{
  FILE *ftree, *indx, *in, *out;
  char bufin[MAXBUF];
  char bufout[MAXBUF];
  long ofst, nrecs, start, end;
  int i, len, outlen;

  if (argc != 3)
  { fprintf(stderr,"Usage: %s input \n", argv[0]);
    exit(0);
  }

  if ((in = fopen(argv[1], "rb")) == NULL)
  { fprintf(stderr,"Unable to open input file %s\n", argv[1]);
    exit(1);
  }

  if ((out = fopen(argv[2], "wb")) == NULL)
  { fprintf(stderr,"Unable to open output file %s\n", argv[2]);
    exit(1);
  }

  if ((ftree = fopen("htree.dat","rb")) == NULL)
  { fprintf(stderr,"Unable to open htree.dat\n");
    exit(1);
  }
  else
  { fread(&root, sizeof(root), 1, ftree);
    fread(ht, sizeof(ht), 1, ftree);
    fclose(ftree);
  }

  if ((indx = fopen("index", "rb")) == NULL)
  { fprintf(stderr,"Unable to open index file\n");
    exit(1);
  }
  else
  { fread(&nrecs, sizeof(nrecs), 1, indx);
  }

  for (i=0; i<nrecs; i++)
  {
    ofst = sizeof(nrecs) + sizeof(start) * i;
    fseek(indx, ofst, SEEK_SET);
    fread(&start, sizeof(start), 1, indx);
    fread(&end, sizeof(end), 1, indx);
    fseek(in, sizeof(char) * (start), SEEK_SET);
    len = end - start;
    fread(bufin, sizeof(char), len, in);
    decode(bufin, &outlen, bufout);
    bufout[outlen] = '\0';
    fprintf(out,"%s",bufout);
  }

}



