
----------

Listing 11 - The Cheshire Cat implementation for lns using a pair of 
pointers

//
// lns1b.cpp - line number sequence implementation
//
#include <stdio.h>

#include "lns.h"

class lns::details
    {
public:
    class node;
    node *first, *last;
    };

class lns::details::node
    {
public:
    node(unsigned n);
    unsigned number;
    node *next;
    };

inline lns::details::node::node(unsigned n)
    : number(n), next(0)
    {
    }

lns::lns(unsigned n)
    {
    dp = new details;
    dp->first = dp->last = new node(n);
    }

lns::~lns()
    {
    node *first = dp->first;
    node *p;
    while ((p = first) != 0)
        {
        first = first->next;
        delete p;
        }
    }

void lns::add(unsigned n)
    {
    if (dp->last->number != n)
        dp->last = dp->last->next = new node(n);
    }

void lns::print()
    {
    node *p;
    for (p = dp->first; p != 0; p = p->next)
        printf("%4d ", p->number);
    }


