
----------

Listing 10 - The Cheshire Cat implementation for lns using a single 
pointer

//
// lns2a.cpp - line number sequence implementation
//
#include <stdio.h>

#include "lns.h"

class lns::details
    {
public:
    details(unsigned n);
    ~details();
    void add(unsigned n);
    void print();
private:
    class node;
    node *first;
    };

class lns::details::node
    {
public:
    node(unsigned n);
    unsigned number;
    node *next;
    };

inline lns::details::node::node(unsigned n)
    : number(n), next(0)
    {
    }

inline lns::details::details(unsigned n)
    {
    first = new node(n);
    }

lns::details::~details()
    {
    node *p;
    while ((p = first) != 0)
        {
        first = first->next;
        delete p;
        }
    }

void lns::details::add(unsigned n)
    {
    node *p = first;
    while (p->next != 0 && p->number != n)
        p = p->next;
    if (p->number != n)
        p = p->next = new node(n);
    }

void lns::details::print()
    {
    node *p;
    for (p = first; p != 0; p = p->next)
        printf("%4d ", p->number);
    }

lns::lns(unsigned n)
    {
    dp = new details(n);
    }

lns::~lns()
    {
    delete dp;
    }

void lns::add(unsigned n)
    {
    dp->add(n);
    }

void lns::print()
    {
    dp->print();
    }

