Listing 1       The expansion code for time
 
 
/* Copyright (c) 1993 Russell Suereth                */
 
#include "natural.h"
#define  PROBABILITY                  220
#define  CHARACTERISTIC               221
#define  LOGICAL_NECESSITY            222
#define  TENSES_ERROR                 210
#define  TIME_MEANING_ERROR           211
#define  NUMBER_ERROR                 212
#define  POINT_OF_TIME                100
#define  DAY                          101
#define  PERIOD_OF_TIME               102
#define  DURATION                     103
#define  BEFORE                       104
#define  AFTER                        105
#define  SINCE                        106
#define  BETWEEN                      107
#define  UNTIL                        108
#define  LAST                         111
#define  NEXT                         112
#define  EACH                         113
#define  EVERY                        114
#define  ALL                          115
int  ask_meaning(void);
void check_time(void);
void derive_aux_meaning(void);
void derive_time_meaning(void);
int  check_agreement(void);
void check_time(void);
void agreement_error(int);
void aux_meaning_response(void);
int  check_underlying3(void);
char times[20][31];
unsigned char time_meaning[20];
 
/*****************************************************/
/* Determine if the input sentence contains a known, */
/* underlying structure. If it does, then assign the */
/* correct types and phrases for the words.          */
/*****************************************************/
int  check_underlying()
{
    int i = 0;
    /* Structure PRON-AUX-VERB-PREP-DET-NOUN         */
    if ( (check_type("PRON",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("VERB", i+2) == 0) &&
         (check_type("PREP", i+3) == 0) &&
         (check_type("DET",  i+4) == 0) &&
         (check_type("NOUN", i+5) == 0) ) {
        strcpy(prime_types[i],   "PRON");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "VERB");
        strcpy(prime_types[i+3], "PREP");
        strcpy(prime_types[i+4], "DET");
        strcpy(prime_types[i+5], "NOUN");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "PREPPHRASE");
        strcpy(phrases[i+4], "PREPPHRASE");
        strcpy(phrases[i+5], "PREPPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-VERB-PREP-DET-NOUN         */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("VERB", i+2) == 0) &&
         (check_type("PREP", i+3) == 0) &&
         (check_type("DET",  i+4) == 0) &&
         (check_type("NOUN", i+5) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "VERB");
        strcpy(prime_types[i+3], "PREP");
        strcpy(prime_types[i+4], "DET");
        strcpy(prime_types[i+5], "NOUN");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "PREPPHRASE");
        strcpy(phrases[i+4], "PREPPHRASE");
        strcpy(phrases[i+5], "PREPPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-AUX-VERB-PREP-TIME-TIME*/
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("AUX",  i+3) == 0) &&
         (check_type("VERB", i+4) == 0) &&
         (check_type("PREP", i+5) == 0) &&
         (check_type("TIME", i+6) == 0) &&
         (check_type("TIME", i+7) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "AUX");
        strcpy(prime_types[i+4], "VERB");
        strcpy(prime_types[i+5], "TIME");
        strcpy(prime_types[i+6], "TIME");
        strcpy(prime_types[i+7], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "VERBPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(phrases[i+6], "TIMEPHRASE");
        strcpy(phrases[i+7], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+3]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-AUX-VERB-PREP-TIME     */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("AUX",  i+3) == 0) &&
         (check_type("VERB", i+4) == 0) &&
         (check_type("PREP", i+5) == 0) &&
         (check_type("TIME", i+6) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "AUX");
        strcpy(prime_types[i+4], "VERB");
        strcpy(prime_types[i+5], "TIME");
        strcpy(prime_types[i+6], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "VERBPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(phrases[i+6], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+3]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-AUX-VERB-TIME-TIME     */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("AUX",  i+3) == 0) &&
         (check_type("VERB", i+4) == 0) &&
         (check_type("TIME", i+5) == 0) &&
         (check_type("TIME", i+6) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "AUX");
        strcpy(prime_types[i+4], "VERB");
        strcpy(prime_types[i+5], "TIME");
        strcpy(prime_types[i+6], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "VERBPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(phrases[i+6], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+3]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-VERB-PREP-TIME-TIME    */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("VERB", i+3) == 0) &&
         (check_type("PREP", i+4) == 0) &&
         (check_type("TIME", i+5) == 0) &&
         (check_type("TIME", i+6) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "VERB");
        strcpy(prime_types[i+4], "TIME");
        strcpy(prime_types[i+5], "TIME");
        strcpy(prime_types[i+6], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(phrases[i+6], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-VERB-PREP-TIME         */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("VERB", i+3) == 0) &&
         (check_type("PREP", i+4) == 0) &&
         (check_type("TIME", i+5) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "VERB");
        strcpy(prime_types[i+4], "TIME");
        strcpy(prime_types[i+5], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-AUX-VERB-TIME-TIME         */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("AUX",  i+2) == 0) &&
         (check_type("VERB", i+3) == 0) &&
         (check_type("TIME", i+4) == 0) &&
         (check_type("TIME", i+5) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "AUX");
        strcpy(prime_types[i+3], "VERB");
        strcpy(prime_types[i+4], "TIME");
        strcpy(prime_types[i+5], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "VERBPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        strcat(auxiliaries[sentence], " ");
        strcat(auxiliaries[sentence], word_array[i+2]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-VERB-PREP-TIME-TIME        */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("VERB", i+2) == 0) &&
         (check_type("PREP", i+3) == 0) &&
         (check_type("TIME", i+4) == 0) &&
         (check_type("TIME", i+5) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "VERB");
        strcpy(prime_types[i+3], "TIME");
        strcpy(prime_types[i+4], "TIME");
        strcpy(prime_types[i+5], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "TIMEPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(phrases[i+5], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-VERB-PREP-TIME             */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("VERB", i+2) == 0) &&
         (check_type("PREP", i+3) == 0) &&
         (check_type("TIME", i+4) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "VERB");
        strcpy(prime_types[i+3], "TIME");
        strcpy(prime_types[i+4], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "TIMEPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        get_aux();
        return(0);
    }
 
    /* Structure NAME-AUX-VERB-TIME-TIME             */
    if ( (check_type("NAME",   i) == 0) &&
         (check_type("AUX",  i+1) == 0) &&
         (check_type("VERB", i+2) == 0) &&
         (check_type("TIME", i+3) == 0) &&
         (check_type("TIME", i+4) == 0) ) {
        strcpy(prime_types[i],   "NAME");
        strcpy(prime_types[i+1], "AUX");
        strcpy(prime_types[i+2], "VERB");
        strcpy(prime_types[i+3], "TIME");
        strcpy(prime_types[i+4], "TIME");
        strcpy(phrases[i],   "NOUNPHRASE");
        strcpy(phrases[i+1], "VERBPHRASE");
        strcpy(phrases[i+2], "VERBPHRASE");
        strcpy(phrases[i+3], "TIMEPHRASE");
        strcpy(phrases[i+4], "TIMEPHRASE");
        strcpy(auxiliaries[sentence], word_array[i+1]);
        get_aux();
        return(0);
    }
    return(1);
}
 
/*****************************************************/
/* If the phrase is a "TIMEPHRASE", then all the     */
/* words in the phrase refer to a time. Concatenate  */
/* these words to the times array.                   */
/*****************************************************/
void check_time()
{
    int i;
    for (i=0; i<word_ct; i++) {
        if (strcmp(phrases[i], "TIMEPHRASE") == 0) {
            if (strlen(times[sentence]) > 0)
                strcat(times[sentence], " ");
            strcat(times[sentence], word_array[i]);
        }
    }
    return;
}
 
/*****************************************************/
/* Generate a response with information from a       */
/* matching, previous sentence.                      */
/*****************************************************/
void make_response()
{
  int i;
 
  if (check_agreement() != 0) return;
 
  if (strcmpi(word_array[0], "where") != 0) {
    if (ask_meaning() != 0)  aux_meaning_response();
    return;
  }
 
  /***************************************************/
  /* Match subject, action, tense, and meaning.      */
  /***************************************************/
  for (i=sentence-1; i>=0; i--) {
    if ((strcmpi(subjects[i],subjects[sentence])==0) &&
        (strcmpi(actions[i], actions[sentence]) ==0) &&
        (strlen(places[i])                      > 0) &&
        (tenses[i]              == tenses[sentence]) &&
        (strpbrk(aux_meaning[i],aux_meaning[sentence])
                                            != NULL)) {
       make_answer(i);
       return;
    }
  }
  /***************************************************/
  /* Match subject, action, and tense.               */
  /***************************************************/
  for (i=sentence-1; i>=0; i--) {
    if ((strcmpi(subjects[i],subjects[sentence])==0) &&
        (strcmpi(actions[i], actions[sentence]) ==0) &&
        (strlen(places[i])                      > 0) &&
        (tenses[i]              == tenses[sentence])) {
       make_answer(i);
       return;
    }
  }
  /***************************************************/
  /* Match subject, action, and meaning.             */
  /***************************************************/
  for (i=sentence-1; i>=0; i--) {
    if ((strcmpi(subjects[i],subjects[sentence])==0) &&
        (strcmpi(actions[i], actions[sentence]) ==0) &&
        (strlen(places[i])                      > 0) &&
        (strpbrk(aux_meaning[i],aux_meaning[sentence])
                                            != NULL)) {
        strcpy(response, "I'm not sure, but ");
       make_answer(i);
       return;
    }
  }
  /***************************************************/
  /* Match subject and action.                       */
  /***************************************************/
  for (i=sentence-1; i>=0; i--) {
    if ((strcmpi(subjects[i],subjects[sentence])==0) &&
        (strcmpi(actions[i], actions[sentence]) ==0) &&
        (strlen(places[i])                      > 0)) {
       strcpy(response, "I'm not sure, but ");
       make_answer(i);
       return;
    }
  }
  strcpy(response, "I don't know");
  return;
}
 
/*****************************************************/
/* Obtain a clear auxiliary meaning from an          */
/* ambiguous meaning.                                */
/*****************************************************/
void derive_aux_meaning()
{
   if (strlen(auxiliaries[sentence]) == 0) {
      if (tenses[sentence] == PAST)
          aux_meaning[sentence][0] =
              PARTICULAR_POINT_OF_TIME;
      if (tenses[sentence] == PRESENT)
          aux_meaning[sentence][0] = LIMITED_DURATION;
      if (tenses[sentence] == FUTURE)
          aux_meaning[sentence][0] = FIXED_PLAN;
   }
 
   if (strcmpi(auxiliaries[sentence], "is") == 0) {
      if (tenses[sentence] == PRESENT) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = LIMITED_DURATION;
      }
      if (tenses[sentence] == FUTURE) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = FIXED_PLAN;
      }
   }
 
   if ( ((strcmpi(auxiliaries[sentence],
                  "could") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "could be") == 0)) &&
         (tenses[sentence] == FUTURE)) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = POSSIBILITY;
   }
 
   if ( ((strcmpi(auxiliaries[sentence],
                  "may be") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "may have") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "may have been") == 0)) &&
         ((tenses[sentence] == PAST)   ||
          (tenses[sentence] == PRESENT)) ) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = POSSIBILITY;
   }
 
   if ( ((strcmpi(auxiliaries[sentence],
                  "would") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "would have") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "would have been") == 0)) &&
         (tenses[sentence] == PAST)) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = CHARACTERISTIC;
   }
 
   if (strcmpi(auxiliaries[sentence],
               "would be") == 0) {
          memset(aux_meaning[sentence], '\0', 5);
          aux_meaning[sentence][0] = PROBABILITY;
   }
 
   if (strcmpi(auxiliaries[sentence],
               "must have been") == 0) {
       memset(aux_meaning[sentence], '\0', 5);
       aux_meaning[sentence][0] = LOGICAL_NECESSITY;
   }
 
   if ((strcmpi(auxiliaries[sentence], "must") == 0) ||
       (strcmpi(auxiliaries[sentence],
                "must be") == 0)) {
       memset(aux_meaning[sentence], '\0', 5);
       aux_meaning[sentence][0] = OBLIGATION;
   }
 
   return;
}
 
/*****************************************************/
/* Obtain the meaning of time words in the sentence. */
/*****************************************************/
void derive_time_meaning()
{
   int i;
   for (i=0; i<word_ct; i++) {
       if (strcmp(phrases[i],"TIMEPHRASE") == 0) {
           if (strcmpi(word_array[i], "at") == 0)
               time_meaning[sentence] = POINT_OF_TIME;
           if (strcmpi(word_array[i], "on") == 0)
               time_meaning[sentence] = DAY;
           if (strcmpi(word_array[i], "in") == 0)
               time_meaning[sentence] = PERIOD_OF_TIME;
           if (strcmpi(word_array[i], "for") == 0)
              time_meaning[sentence] = DURATION;
           if (strcmpi(word_array[i], "before") == 0)
               time_meaning[sentence] = BEFORE;
           if (strcmpi(word_array[i], "after") == 0)
               time_meaning[sentence] = AFTER;
           if (strcmpi(word_array[i], "since") == 0)
               time_meaning[sentence] = SINCE;
           if (strcmpi(word_array[i], "until") == 0)
               time_meaning[sentence] = UNTIL;
           if (strcmpi(word_array[i], "between") == 0)
               time_meaning[sentence] = BETWEEN;
           if (strcmpi(word_array[i], "by") == 0)
               time_meaning[sentence] = BEFORE;
           if (strcmpi(word_array[i], "up to") == 0)
               time_meaning[sentence] = UNTIL;
           if (strcmpi(word_array[i], "last") == 0)
               time_meaning[sentence] = LAST;
           if (strcmpi(word_array[i], "next") == 0)
               time_meaning[sentence] = NEXT;
           if (strcmpi(word_array[i], "each") == 0)
               time_meaning[sentence] = EACH;
           if (strcmpi(word_array[i], "every") == 0)
               time_meaning[sentence] = EVERY;
           if (strcmpi(word_array[i], "all") == 0)
               time_meaning[sentence] = ALL;
           break;
       }
   }
   return;
}
 
/*****************************************************/
/* Create a response that asks for more specific     */
/* meaning.                                          */
/*****************************************************/
int  ask_meaning()
{
   if ((strcmpi(auxiliaries[sentence],
                "can") == 0) ||
       (strcmpi(auxiliaries[sentence],
                "can be") == 0) ||
       (strcmpi(auxiliaries[sentence],
                "can have") == 0)) {
        strcpy(response, "Do you mean\n\t\t");
        subjects[sentence][0] =
            (char) toupper(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
 
        if (tenses[sentence] == PRESENT) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " is");
            else strcat(response, " are");
        }
 
        if (tenses[sentence] == FUTURE)
            strcat(response, " will be");
 
        strcat(response, " able to ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
        strcat(response, subjects[sentence]);
 
        if (tenses[sentence] == PRESENT) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " is");
            else strcat(response, " are");
        }
 
        if (tenses[sentence] == FUTURE)
            strcat(response, " will be");
 
        strcat(response, " permitted to ");
        strcat(response, actions[sentence]);
        return(0);
   }
 
   if ( ((strcmpi(auxiliaries[sentence],
                  "could") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "could be") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "could have") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "could have been") == 0)) &&
        ((tenses[sentence] == PAST) ||
         (tenses[sentence] == PRESENT)) ) {
 
        strcpy(response, "Do you mean\n\t\t");
        subjects[sentence][0] =
            (char) toupper(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
 
        if (tenses[sentence] == PAST) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " was");
            else strcat(response, " were");
        }
 
        if (tenses[sentence] == PRESENT) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " is");
            else strcat(response, " are");
        }
 
        strcat(response, " able to ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
        strcat(response, subjects[sentence]);
 
        if (tenses[sentence] == PAST) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " was");
            else strcat(response, " were");
        }
 
        if (tenses[sentence] == PRESENT) {
            if (numbers[sentence] == SINGULAR)
                strcat(response, " is");
            else strcat(response, " are");
        }
 
        strcat(response, " permitted to ");
        strcat(response, actions[sentence]);
        return(0);
   }
 
   if ( ((strcmpi(auxiliaries[sentence],
                  "may") == 0) ||
         (strcmpi(auxiliaries[sentence],
                  "may be") == 0)) &&
        (tenses[sentence] == FUTURE) ) {
 
        strcpy(response, "Do you mean\n\t\t");
        subjects[sentence][0] =
            (char) toupper(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
        strcat(response, " will be permitted to ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
        strcat(response, subjects[sentence]);
        strcat(response, " will possibly ");
        strcat(response, actions[sentence]);
        return(0);
   }
 
   if ((strcmpi(auxiliaries[sentence], "will") == 0) ||
       (strcmpi(auxiliaries[sentence],
                "will be") == 0)) {
 
        strcpy(response, "Do you mean\n\t\t");
        subjects[sentence][0] =
            (char) toupper(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
 
        if (numbers[sentence] == SINGULAR)
            strcat(response, " is");
        else strcat(response, " are");
 
        strcat(response, " willing to ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
        strcat(response, subjects[sentence]);
 
        if (numbers[sentence] == SINGULAR)
            strcat(response, " is");
        else strcat(response, " are");
 
        strcat(response, " intending to ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
 
        strcat(response, "You insist ");
        if (subjects_type[sentence] == PRONOUN)
           subjects[sentence][0] = (char)
             (char) tolower(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
        strcat(response, " will ");
        strcat(response, actions[sentence]);
        strcat(response, " or,\n\t\t");
 
        strcat(response, "You predict ");
        if (subjects_type[sentence] == PRONOUN)
           subjects[sentence][0] = (char)
             (char) tolower(subjects[sentence][0]);
        strcat(response, subjects[sentence]);
        strcat(response, " will ");
        strcat(response, actions[sentence]);
        return(0);
   }
   return(1);
}
 
/*****************************************************/
/* Create a response based on the meaning of the     */
/* auxiliary in the sentence.                        */
/*****************************************************/
void aux_meaning_response()
{
    switch (aux_meaning[sentence][0]) {
        case LIMITED_DURATION:
            strcpy(response, "When will ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " stop ");
            get_verb(tenses[sentence],
                     numbers[sentence], 'I');
            break;
 
        case PARTICULAR_POINT_OF_TIME:
            strcpy(response, "When did ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " ");
            strcat(response, actions[sentence]);
            break;
 
        case UP_TO_PRESENT:
            strcpy(response, "Will ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " continue ");
            get_verb(tenses[sentence],
                     numbers[sentence], 'I');
            break;
 
        case NOT_COMPLETED:
            strcpy(response, "When did ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " stop ");
            get_verb(tenses[sentence],
                     numbers[sentence], 'I');
            break;
 
        case POSSIBILITY:
            if (tenses[sentence] == PAST)
               strcat(response, "Was this ");
            if (tenses[sentence] == PRESENT)
               strcat(response, "Is this ");
            if (tenses[sentence] == FUTURE)
               strcat(response, "Will this be ");
            strcat(response, "highly possible");
            break;
 
        case PROBABILITY:
            strcpy(response,
                "Will this be highly probable");
            break;
 
        case OBLIGATION:
            strcpy(response, "What ");
 
            if (tenses[sentence] == PAST)
               strcat(response, "happened when ");
            if (tenses[sentence] == FUTURE)
               strcat(response, "will happen if ");
 
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
 
            if (tenses[sentence] == PAST)
               strcat(response, " didn't ");
            if (tenses[sentence] == FUTURE)
               strcat(response, " doesn't ");
 
            strcat(response, actions[sentence]);
            break;
 
        case CHARACTERISTIC:
            strcpy(response, "How often did ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " ");
            strcat(response, actions[sentence]);
            break;
 
        case LOGICAL_NECESSITY:
            strcpy(response,
                   "Why was it necessary that ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            if (numbers[sentence] == SINGULAR)
                strcat(response, " was ");
            else strcat(response, " were ");
 
            get_verb(tenses[sentence],
                     numbers[sentence], 'I');
            break;
 
        case FIXED_PLAN:
            strcpy(response, "Will ");
            if (subjects_type[sentence] == PRONOUN)
               subjects[sentence][0] = (char)
               tolower(subjects[sentence][0]);
            strcat(response, subjects[sentence]);
            strcat(response, " be ready to ");
            strcat(response, actions[sentence]);
            break;
 
        default:      /*  all others                 */
            strcpy(response, "OK");
            break;
    }
}
 
/*****************************************************/
/* Determine if the input sentence words conflict.   */
/*****************************************************/
int  check_agreement()
{
   if (time_meaning[sentence] == LAST) {
       if ( (tenses[sentence] == PRESENT) ||
            (tenses[sentence] == FUTURE) ) {
           agreement_error(TIME_MEANING_ERROR);
           return(1);
       }
   }
 
   if (time_meaning[sentence] == NEXT) {
       if (tenses[sentence] == PAST) {
           agreement_error(TIME_MEANING_ERROR);
           return(1);
       }
   }
 
   if (numbers[sentence] == UNKNOWN) {
       agreement_error(NUMBER_ERROR);
       return(1);
   }
 
   if (tenses[sentence] == UNKNOWN) {
       agreement_error(TENSES_ERROR);
       return(1);
   }
 
   return(0);
}
 
/*****************************************************/
/* Generate a response that explains the time        */
/* agreement error.                                  */
/*****************************************************/
void agreement_error(int error_type)
{
   int i;
   if (error_type == TIME_MEANING_ERROR) {
       strcpy(response, "I don't understand, '");
       strcat(response, auxiliaries[sentence]);
       strcat(response, "' means ");
       for (i=0; (aux_tense[i] != ' ') &&
                 (aux_tense[i]); i++) {
           if (i > 0) strcat(response, " or ");
           if (aux_tense[i] == PAST)
               strcat(response, "past");
           if (aux_tense[i] == PRESENT)
               strcat(response, "present");
           if (aux_tense[i] == FUTURE)
               strcat(response, "future");
       }
 
       strcat(response, " time, but '");
       strcat(response, times[sentence]);
       strcat(response, "' means ");
       if (time_meaning[sentence] == LAST)
           strcat(response, "past");
       if (time_meaning[sentence] == NEXT)
           strcat(response, "future");
       strcat(response, " time ");
   }
 
   if (error_type == NUMBER_ERROR) {
       strcpy(response, "I don't understand, '");
       strcat(response, auxiliaries[sentence]);
       strcat(response, "', '");
       strcat(response, subjects[sentence]);
       strcat(response, "', and that form of '");
       strcat(response, actions[sentence]);
       strcat(response, "' don't agree in number");
   }
 
   if (error_type == TENSES_ERROR) {
       strcpy(response, "I don't understand, '");
       strcat(response, auxiliaries[sentence]);
       strcat(response, "' and that form of '");
       strcat(response, actions[sentence]);
       strcat(response, "' aren't used together");
   }
 
   return;
}
 
/* End of file                                       */
