Welstead: Listing 3

// File UIDATOBJ.CPP  Defines basic data objects

#ifndef UIDATOBJ_CPP
#define UIDATOBJ_CPP

#include "uidialgs.cpp"

class tdata_obj {
   public:
   void * value_addr;
   char * descr_addr;
   int item_no;
   tdata_obj (char * the_descr,void * value_ptr,
     int the_item_no)
     {descr_addr = the_descr;
     value_addr = value_ptr;
     item_no = the_item_no; }
   };

class ttyped_data_obj: public tdata_obj {
   public:
   tdata_type data_type;
   unsigned short display_len;
   boolean check_max_min;
   unsigned short dec_places;
   float cmax,cmin;
   char * wild_str;
   boolean enabled;
   ttyped_data_obj (char * the_descr,void *value_ptr,
      tdata_type the_type,
      unsigned short the_len,
      boolean the_check,
      unsigned short the_dec_places,
      float the_max, const float the_min,
      boolean is_enabled,
      char * the_wild_str,
      int the_item_no) : tdata_obj (the_descr,
		value_ptr,the_item_no){
	 data_type = the_type;
	 display_len = the_len;
	 check_max_min = the_check;
	 dec_places = the_dec_places;
	 cmax = the_max;
	 cmin = the_min;
	 enabled = is_enabled;
	 wild_str = the_wild_str;
	 }
   virtual unsigned int get_data_size ();
   virtual void get_value_str (char *the_string);
   virtual void get_display_str (char *the_string,
       int maxlen);
   void enable () {enabled = TRUE;}
   void disable () {enabled = FALSE;}
   virtual void get_new_value ();
   };

unsigned int ttyped_data_obj::get_data_size ()  {
   switch (data_type) {
   case REAL_DATA:
       return (sizeof(float));
   case PATH_DATA:
       return (sizeof(path_str));
   case INT_DATA:
       return (sizeof(int));
   case BOOLEAN_DATA:
       return (sizeof(boolean));
   default:
       return (1); }  //End switch
       }  //End function

void ttyped_data_obj::get_value_str(char *the_string) 
   {
   switch (data_type) {
   case REAL_DATA:
      sprintf(the_string,"%*.*f",display_len,
       dec_places,*(float *)value_addr);
      break;
   case INT_DATA:
      sprintf(the_string,"%*d",display_len,
          *(int *)value_addr);
      break;
   case BOOLEAN_DATA:
      if (*(boolean *)value_addr)
	 strcpy(the_string,"Yes");
      else
	 strcpy(the_string,"No");
      break;
   case PATH_DATA:
      strcpy (the_string,(char *)value_addr);
      break;
   default:
      strcpy (the_string,"");  }  //End switch
      }  //End function

void ttyped_data_obj::get_display_str 
   (char *the_string,int maxlen) {
   char astring[256],value_str[65];
   strcpy (astring,descr_addr);
   strcat (astring,": ");
   get_value_str (value_str);
   strcat (astring,value_str);
   strncpy (the_string,astring,maxlen);
   the_string[maxlen] = '\0';
   }

void ttyped_data_obj::get_new_value () {
   switch (data_type) {
   case REAL_DATA:
   case INT_DATA:
     numeric_dialog (descr_addr,display_len,
         dec_places,check_max_min,cmin,cmax,data_type,
         value_addr);
     break;
   case BOOLEAN_DATA:
     boolean_dialog (descr_addr,
         *(boolean *)value_addr);
     break;
   case PATH_DATA:
     get_file_name_dlg(wild_str,descr_addr,
         (char *)value_addr);
     break;
     }  //end switch
     }  //end function

#endif
