Welstead: Listing 4

// File UIDIALGS.CPP  General dialog boxes

#ifndef UIDIALGS_CPP
#define UIDIALGS_CPP

#define Uses_TDeskTop
#define Uses_TApplication
#define Uses_TView
#define Uses_TDialog
#define Uses_TLabel
#define Uses_TFileDialog
#define Uses_TSItem
#define Uses_TRadioButtons
#define Uses_TCheckBoxes
#define Uses_TButton
#define Uses_TRect
#define Uses_TInputLine
#define Uses_TEvent
#define Uses_TKeys
#define Uses_MsgBox
#define Uses_TStaticText
#include "uisetvar.cpp"  //includes <tv.h>

//For radio buttons and check boxes: 
const MAX_NO_OF_ITEMS = 16;  
//Center hor position on 80 col text screen:
const SCREEN_H_CENTER = 40;  
//Center vert position on 25 row text screen:
const SCREEN_V_CENTER = 12;  
// Min width to accommodate command buttons:
const MIN_BOX_WIDTH = 40;  
typedef char* tpstring;
typedef tpstring tpstring_array[MAX_NO_OF_ITEMS];

void radio_dialog (const char *p_title,
   const char *p_descr,void *names, int no_of_items, 
   int item_length, ushort *return_val);
void boolean_dialog (const char *p_title, 
   boolean &answer);
void check_box_dialog (const char *p_title,
   const char *p_descr,void *names, int no_of_items, 
   int item_length, ushort *return_val);
void numeric_dialog (const char* p_title,
   int maxlen, int dec_places, boolean check_max_min,
   float min, float max, tdata_type type_of_data,
   void * p_value);
void get_file_name_dlg (const char *pwild_str,
   const char *ptitle_str,char *file_name);

// Implementation

void get_tpstring_array (void *names_addr, 
   int no_of_items,int item_length, 
   tpstring_array &the_array) {
   char *p_chr_array;
   p_chr_array = (char *)names_addr;
   int offs = 0;
   for (int i = 0; i < no_of_items; i++)
      {the_array[i] = &p_chr_array[i + offs];
       offs += item_length - 1;}
   return;
   }

TRect the_rect (int no_of_items,int item_length,
   int title_len,int descr_len)
   {
   int box_width,box_start,box_line_start,box_length,
       tlen,dlen;
   const int MAX_BOX_LENGTH = 21;
   box_width = item_length + 8;
   tlen = title_len + 4;
   dlen = descr_len + 12;
   if (box_width < tlen) box_width = tlen;
   if (box_width < dlen) box_width = dlen;
   if (box_width < MIN_BOX_WIDTH) 
	box_width = MIN_BOX_WIDTH;
   if (descr_len > 0) box_length = 9 + no_of_items;
   else box_length = 7 + no_of_items;
   if (box_length > MAX_BOX_LENGTH) 
	box_length = MAX_BOX_LENGTH;
   box_start = SCREEN_H_CENTER - (box_width/2);
   box_line_start = SCREEN_V_CENTER - (box_length/2) 
	- 1;
   return (TRect(box_start,box_line_start,box_start + 
	box_width,box_line_start + box_length));
   }

class tcluster_dialog : public TDialog{
   public:
   tcluster_dialog(const char *p_title,
       const char *p_descr,
   void *names_addr, int no_of_items, 
       int item_length);
   TSItem *items[MAX_NO_OF_ITEMS];
   tpstring_array str_array;
   };

tcluster_dialog::tcluster_dialog( const char *p_title,
    const char *p_descr, void *names_addr, 
    int no_of_items, int item_length):
    TDialog (the_rect(no_of_items,item_length,
       strlen(p_title),strlen(p_descr)),p_title),
    TWindowInit (&tcluster_dialog::initFrame),
    items ()
   {
   get_tpstring_array (names_addr,no_of_items,
        item_length,str_array);
   //Set up linked list:
   items[no_of_items-1] =
	new TSItem (str_array[no_of_items-1],NULL);
   for (int i = no_of_items - 2; i >=0; --i)
       items[i] = new TSItem (str_array[i],
       items[i+1]);
   TRect r = TRect (2,5+no_of_items,17,7+no_of_items);
   insert (new TButton(r,"O~K~ (Enter)",cmOK,
       bfDefault));
   r = TRect (20,5+no_of_items,35,7+no_of_items);
   insert (new TButton(r,"Cancel (Esc)",cmCancel,
	bfNormal));
   }

void radio_dialog (const char *p_title,
     	const char *p_descr,void *names, int no_of_items, 
	int item_length, ushort *return_val) {
   ushort radio_dialog_data = *return_val - 1;
   tcluster_dialog *dialog = 
	new tcluster_dialog(p_title,p_descr,names,
	no_of_items,item_length);
   TRect box_r = dialog->getExtent();
   int box_width = box_r.b.x - box_r.a.x;
   TView *b = new TRadioButtons (TRect(2,4,
	box_width - 2,4 + no_of_items),dialog->items[0]);
   dialog->insert(b);
   const label_length = 30;
   char the_label[label_length];
   strcpy(the_label,"~S~elect ");
   strcat(the_label,p_descr);
   strcat(the_label,":");
   dialog->insert(new TLabel(TRect(2,2,box_width - 2,
	3),the_label,b));
   b->select();
   dialog->setData(&radio_dialog_data);
   TApplication *the_app = 
	(TApplication *) dialog->owner;
   the_app->validView (dialog);
   if (dialog != 0) {
      if (gdesk_top->execView(dialog) != cmCancel)
	 {
	 dialog->getData(&radio_dialog_data);
	 *return_val = radio_dialog_data + 1;
	 }
      TObject::destroy (dialog);
      }
   }

void boolean_dialog (const char *p_title, 
	boolean &answer)  {
   const char yes_no_str[2][6] = {"~Y~es","~N~o"};
   const int two_items = 2;
   const int item_length = 6;
   ushort response;
   if (answer) response = 1;
   else response = 2;
   radio_dialog (p_title,p_title,(void *)yes_no_str,
	two_items,item_length,&response);
   if (response == 1) answer = TRUE;
   else answer = FALSE;
   }

// Can also derive a check box dialog from 
//     cluster dialog.

class tnum_inputline:public TInputLine {
   public:
   tnum_inputline (const TRect& bounds, int aMaxLen);
   void handleEvent (TEvent& event);
   };

tnum_inputline::tnum_inputline(const TRect& bounds, 
	int aMaxLen):TInputLine (bounds,aMaxLen) { }; 
	//Invokes TInputLine (bounds,aMaxlen)

void tnum_inputline::handleEvent (TEvent& event) {
   if (event.what == evKeyDown) {
   // Allow only numeric and direction keys
      switch (event.keyDown.charScan.charCode) {
      case '0':   case '1':   case '2':
      case '3':   case '4':   case '5':
      case '6':   case '7':   case '8':
      case '9':   case '.':   case '-':
      case kbEsc: TInputLine::handleEvent (event); 
		return;
      }
      switch (event.keyDown.keyCode) {
      case kbTab:   case kbDel:  case kbEnter:
      case kbHome:  case kbEnd:  case kbRight:
      case kbLeft:  case kbBack:
      case kbEsc: TInputLine::handleEvent (event); 
		return;
      }
      /*  Clear other keyboard events */
      clearEvent(event); return;
      }
   else // Not a keystroke
      TInputLine::handleEvent (event);
      return;
      }

void numeric_dialog (const char* p_title,
   int maxlen, int dec_places, boolean check_max_min,
   float min, float max, tdata_type type_of_data,
   void * p_value) {
   const int max_num_length = 10;
   typedef char num_string[max_num_length];
   boolean completed = FALSE;
   do { // until completed
   int line = 5;
   int half_width = maxlen + 8;
   const int MIN_WIDTH = 20;
   if (half_width < MIN_WIDTH) half_width = MIN_WIDTH;
   TRect r (SCREEN_H_CENTER - half_width,
	SCREEN_V_CENTER - line, SCREEN_H_CENTER + 
	half_width, SCREEN_V_CENTER + 1 + line);
   TDialog *dialog = new TDialog (r,p_title);
   half_width = maxlen/2 + 1;
   r = TRect (19 - half_width,4,21 + half_width,
		5);
   tnum_inputline *b = new tnum_inputline (r,
		maxlen + 1);
   dialog -> insert(b);
   r = TRect (2,2,33,3);
   const label_length = 30;
   char the_label[label_length];
   strcpy(the_label,"~E~nter ");
   strcat(the_label,p_title);
   strcat(the_label,":");
   dialog->insert(new TLabel(r,the_label,b));
   line = 6;
   half_width = maxlen + 8;
   if (check_max_min) {
      num_string max_str,min_str;
      sprintf ((char *)&max_str,"%*.*f",maxlen,
		dec_places,max);
      sprintf ((char *)&min_str,"%*.*f",dec_places + 2,
		dec_places,min);
      r = TRect (19 - half_width,line,21 + half_width,
		line + 1);
      strcpy (the_label,"(Min: ");
      strcat (the_label,(char *)&min_str);
      strcat (the_label,", Max: ");
      strcat (the_label,(char *)&max_str);
      strcat (the_label,")");
      dialog->insert(new TStaticText(r,the_label));
      line += 2;
      }
   r = TRect (2,line,17,line + 2);
   dialog -> insert(new TButton(r,"O~K~ (Enter)",cmOK,
	bfDefault));
   r = TRect (20,line,35,line + 2);
   dialog -> insert(new TButton(r,"Cancel (Esc)",
	cmCancel,bfNormal));
   num_string num_data = "";
   switch (type_of_data) {
      case REAL_DATA: {
	 sprintf ((char *)&num_data,"%*.*f",maxlen,
		dec_places,*(float *)p_value);
	 break;}
      case INT_DATA: {
	 sprintf ((char *)&num_data,"%*d",maxlen,
		*(int *)p_value);
	 break;}
	 }
   dialog -> setData (&num_data);
   b -> select();  //Select input line as focused.
   TApplication *the_app = 
		(TApplication *) dialog->owner;
   the_app->validView (dialog);
   if (dialog != 0) {
      if (gdesk_top->execView(dialog) != cmCancel) {
	 dialog -> getData(&num_data);
	 char *err_ptr;
	 double in_value = strtod (num_data,&err_ptr);
	 if (err_ptr != 0) {
	    int the_error = 0;
	    if (check_max_min)
	       if ((in_value < min) || (in_value > max))
		  the_error = -1;
	    if (the_error == 0) {
	       switch (type_of_data) {
		 case REAL_DATA: {
		    *(float *)p_value = in_value;
		    break;}
		 case INT_DATA: {
		    *(int *)p_value = in_value;
		    break;}
		 }  //End switch
		 completed = TRUE;
		 }  //End if (the_error == 0)
	     else
		messageBox ("Value out of range.",
			mfError | mfOKButton);
	     } // End if (err_ptr != 0)
	     else
		messageBox ("Invalid Numeric",
			mfError | mfOKButton);
	 }  // End if (... != cmCancel)
	 else
	    completed = TRUE;  //Cancel command received
     TObject::destroy (dialog);
     } // End if (dialog != 0)
   } while (completed != TRUE);
   } // Function

void get_file_name_dlg (const char *pwild_str,
   const char *ptitle_str,char *file_name)
   {
   TFileDialog *dialog =
      new TFileDialog(pwild_str,ptitle_str,"~N~ame",
		fdOpenButton,100);
   TApplication *the_app = 
		(TApplication *) dialog->owner;
   the_app->validView (dialog);
   if (dialog != 0 &&
      gdesk_top->execView(dialog) != cmCancel)
      {
      dialog->getFileName(file_name);
      TObject::destroy (dialog);
      }
   }

#endif
