Welstead: Listing 6

// File UILSTDLG.CPP  General list box dialog class

#ifndef UILSTDLG_CPP
#define UILSTDLG_CPP
#define Uses_TDialog
#define Uses_TButton
#define Uses_TLabel
#define Uses_TScrollBar

#include "uilstobj.cpp"

const DISPLAY_WIDTH = 50;

TRect display_rect (int title_len,int descr_len,
   tlist_box_data *the_data_rec,
   int& no_of_display_items) {
   no_of_display_items = 0;
   int no_of_collection_items =
	(the_data_rec->item_collection)->getCount() - 1;
   for (int i = 0; i <= no_of_collection_items; i++) 
     if (((ttyped_data_obj *)
        (the_data_rec->item_collection->
	     at(i)))->enabled) no_of_display_items += 1;
   return the_rect(no_of_display_items,DISPLAY_WIDTH,
		title_len,descr_len);
   }

class tlist_dialog:public TDialog {
   public:
   tlist_box_data display_data_rec;
   tdata_list_box *data_list_box;
   int no_of_display_items;
   tlist_dialog (const char *the_title,
      const char *the_descr, 
      tlist_box_data  *the_data_rec, 
      int max_no_of_items);
   virtual void getData (void *rec);
      };

tlist_dialog::tlist_dialog (const char *the_title,
      const char *the_descr, 
      tlist_box_data *the_data_rec, 
      int max_no_of_items):
      TDialog (display_rect(strlen(the_title),
	 strlen(the_descr),the_data_rec,
   		no_of_display_items),the_title),
      TWindowInit (&tlist_dialog::initFrame)
      {
      const MAX_VIEW_LENGTH = 14;
      int view_length;
      ushort line;
      line = 3;
      view_length = no_of_display_items;
      if (view_length > MAX_VIEW_LENGTH) 
		view_length = MAX_VIEW_LENGTH;
      display_data_rec.item_collection = 
		new TDataCollection (
	 max_no_of_items,NO_GROWTH);
// Insert the_data_rec collection into display_data_rec.
// Display only the enabled items from the_data_rec.
      int no_of_collection_items =
	(the_data_rec->item_collection)->getCount() - 1;
      for (int i = 0; i <= no_of_collection_items; i++) 
        {
	  if (((ttyped_data_obj *)((the_data_rec->
            item_collection)->at(i)))->enabled)
	      display_data_rec.item_collection->insert
	      ((ttyped_data_obj *)
	      ((the_data_rec->item_collection)->at(i)));
	  if (i == the_data_rec->focused_item)
	     display_data_rec.focused_item =
		 display_data_rec.item_collection->
			getCount() - 1;
	  }  // end for i
      display_data_rec.selected_item = -1;
      int box_width = zoomRect.b.x - zoomRect.a.x;
      int box_height = zoomRect.b.y - zoomRect.a.y;
      TRect r = TRect(box_width - 3,line - 1,
		box_width - 2,line + 1 + view_length);
      TScrollBar *p_control = new TScrollBar (r);
      insert(p_control);
      r = TRect(2,line,box_width - 5,
		line + view_length);
      data_list_box = new tdata_list_box(r,p_control);
      data_list_box->
		setData((void *) &display_data_rec);
      insert(data_list_box);
      r = TRect (2,line - 1,box_width - 5,line);
      const label_length = 80;
      char the_label[label_length];
      sprintf (the_label,"~S~elect (Enter) %s: ",
		the_descr);
      insert (new TLabel(r,the_label,data_list_box));
      r = TRect (box_width/2 - 9,box_height - 3,
		box_width/2 + 9,box_height - 1);
      insert (new TButton(r,"E~x~it (Esc)",cmCancel,
		bfNormal));
      // Select the list box as the focused view:
      data_list_box->select();
      }  // End constructor

void tlist_dialog::getData (void *rec) {
      data_list_box->getData (&display_data_rec);
      ((tlist_box_data *) rec)->focused_item =
	  ((ttyped_data_obj *) 
		(display_data_rec.item_collection)->
	at(display_data_rec.focused_item))->item_no - 1;
      ((tlist_box_data *) rec)->selected_item =
	  ((ttyped_data_obj *) 
		(display_data_rec.item_collection)->
	at(display_data_rec.selected_item))->item_no - 1;
      }

void list_dialog (const char *the_title,const char 
	*the_descr, tlist_box_data *the_data_rec,
	int max_no_of_items,void (*special_processing) 	(tlist_box_data*,int)) {
   int control = cmCancel;
   int item_no = 1;
   do {
   the_data_rec->focused_item = item_no - 1;
   tlist_dialog *dialog = new tlist_dialog(the_title,
	the_descr, the_data_rec,max_no_of_items);
   TApplication *the_app = (TApplication *) 
	dialog->owner;
   the_app->validView (dialog);
   if (dialog != 0) {
      control = gdesk_top->execView(dialog);
      if (control != cmCancel)
	 {
	 dialog->getData(the_data_rec);
	 item_no = the_data_rec->selected_item + 1;
	 (*special_processing) (the_data_rec,item_no);
	 }  //End if
      TObject::destroy (dialog);
      } // End if
   } while (control != cmCancel);
   return;
   }  // End function

 void standard_processing 
	(tlist_box_data *the_data_rec,int item_no) {
   // This is the 'usual' processing for the function 
   // parameter 'special_processing' above.  
   // Applications can substitute their own special 
   // processing requirements.
   ((ttyped_data_obj *) (the_data_rec->
      item_collection)->at(item_no - 1))->
      get_new_value();
   return;
   }  // End function

#endif

