Welstead: Listing 5

// File UILSTOBJ.CPP  Define the tlist_box class

#ifndef UILSTOBJ_CPP
#define UILSTOBJ_CPP

#define Uses_TCollection
#define Uses_TNSCollection
#define Uses_TListBox
#define Uses_TEvent
#define Uses_opstream
#define Uses_ipstream
#include "uidatobj.cpp"

const cmItemSelect = 300;
const ushort one_col = 1;

class TDataCollection:public TCollection {
    public:
    //Create a non-abstract version of TCollection.
    TDataCollection (ccIndex aLimit, ccIndex aDelta):
       TCollection (aLimit,aDelta) {
       };
//We won't use stream I/O, so just override these.
    void *readItem( ipstream& is );
    void writeItem( void *obj, opstream& os );
    };

void TDataCollection::writeItem(void *obj,
		opstream& os) {
    os.writeString( (const char *)obj );
}

void *TDataCollection::readItem( ipstream& is )
{
    return is.readString();
}

typedef struct {
    TDataCollection *item_collection;
    short focused_item;
    short selected_item;
    } tlist_box_data;

class tlist_box:public TListBox {
    public:
    // short focused is inherited. Need to distinguish 
    // between 'focused' and 'selected'.
    short selected;     
tlist_box (const TRect& bounds,TScrollBar *aScrollBar):
      TListBox(bounds,one_col,aScrollBar) {
    };
    virtual ushort dataSize()
       {return (sizeof (TDataCollection*) + 
		sizeof (focused) + sizeof (selected));}
    virtual void setData (void *rec);
    virtual void getData (void *rec);
    virtual void handleEvent (TEvent& event);
    };

void tlist_box::setData (void *rec)
       {tlist_box_data *the_listbox_rec = 
		(tlist_box_data *)rec;
	selected = the_listbox_rec->selected_item;
	TListBox::setData(the_listbox_rec);
	return;}

void tlist_box::getData (void *rec)
     {
     ((tlist_box_data *)rec)->focused_item = focused;
     ((tlist_box_data *)rec)->selected_item = selected;
     return;}

void tlist_box::handleEvent (TEvent& event)
    {
    short old_focused = focused;
    if (event.what == evKeyDown) {
       if (event.keyDown.keyCode == kbEnter) {
	  selected = focused;
	  owner -> endModal (cmItemSelect);
	  clearEvent (event);
	  return;
	  }
       if (event.keyDown.charScan.charCode == ' ') {
	  selected = focused;
	  owner -> endModal (cmItemSelect);
	  clearEvent (event);
	  return;
	  }
       switch (event.keyDown.keyCode) {
       case kbUp:    case kbDown:     case kbPgUp:
       case kbPgDn:  case kbCtrlPgUp: case kbCtrlPgDn:
       case kbHome:  case kbEnd:
       case kbEsc: TListBox::handleEvent (event); 
          return;
       default: /* Other Keys  */; return;
       } /*  end switch  */
      }  /*  end if  */
    if ((event.what == evMouseDown) && 
    	(event.mouse.doubleClick)) {
	selected = focused;
	owner -> endModal (cmItemSelect);
	clearEvent (event);
	return;
	}
    TListBox::handleEvent (event);
    if (focused != old_focused) TListBox::drawView();
    }

class tdata_list_box:public tlist_box {
    public:
    tdata_list_box(const TRect& bounds,
	TScrollBar *aScrollBar): 
	tlist_box(bounds,aScrollBar) { };
    virtual void getText (char *dest, short item, 
	short maxlen);
    };

void tdata_list_box::getText (char *dest, short item, 
	short maxlen)
    {
    if (list() != 0)
      ((ttyped_data_obj *) (list()->at(item)))->
	get_display_str(dest,maxlen);
    else
      dest = "No items.";
    return;}

#endif
