Welstead: Listing 7

// UISETCOL.CPP Example of a typical function assigning
//   setup structure fields to a TDataCollection

#ifndef UISETCOL_CPP
#define UISETCOL.CPP

#include "uilstdlg.cpp"

typedef struct {
      float error_threshold;
      int no_of_inputs;
      boolean input_weights_from_file;
      path_str input_file_name;
      } setup_record;

// Global setup record
setup_record g_setup;

void setup_to_collection (setup_record *the_setup,
   TDataCollection *the_collection)
   {
      void * value_ptr = NULL;
      tdata_type the_type;
      unsigned short len;
      boolean the_check = TRUE;
      unsigned short dec_places = 0;
      float the_max = 0.0;
      float the_min = 0.0;
      boolean enable = TRUE;
      int item_no = 0;

   value_ptr = &the_setup->error_threshold;
   the_type = REAL_DATA;
   len = 8;
   dec_places = 6;
   the_max = 1.0;
   the_min = 1e-6;
   item_no++;
   the_collection->insert (new ttyped_data_obj (
	 "Error Threshold",
	 value_ptr,the_type,len,the_check,dec_places,
	 the_max,the_min,
	 enable,"",item_no));

   value_ptr = &the_setup->no_of_inputs;
   the_type = INT_DATA;
   len = 5;
   dec_places = 0;
   the_max = 100;
   the_min = 1;
   item_no++;
   the_collection->insert (new ttyped_data_obj (
	 "No. of Inputs",
	 value_ptr,the_type,len,the_check,dec_places,
	 the_max,the_min,
	 enable,"",item_no));

   value_ptr = &the_setup->input_weights_from_file;
   the_type = BOOLEAN_DATA;
   len = 3;
   item_no++;
   the_collection->insert (new ttyped_data_obj (
	 "Input Wts from File?",
	 value_ptr,the_type,len,the_check,dec_places,
	 the_max,the_min,
	 enable,"",item_no));

   value_ptr = &the_setup->input_file_name;
   the_type = PATH_DATA;
   len = MAX_PATH;
   item_no++;
   the_collection->insert (new ttyped_data_obj (
	 "Input Wts File Name",
	 value_ptr,the_type,len,the_check,dec_places,
	 the_max,the_min,
	 enable,"*.WTS",item_no));
   return;
   }

#endif
