// class FileFilter:
//
// The FileFilter class encapsulates reading an
// input file, filtering its contents through a function,
// and writing the result to an output file.  It uses two
// threads of execution, one for reading the file, the other
// for writing the output file.
//
// Author:	Michael Kelly
//
// Date:	July 26, 1993
//
// Copyright:	Copyright (c) 1993 Michael Kelly,
//		all rights reserved.
//
#if !defined(FFILTER_HPP)
#define FFILTER_HPP

#if !defined(INCL_DOSPROCESS)
#define INCL_DOSPROCESS
#endif
#if !defined(INCL_DOSSEMAPHORES)
#define INCL_DOSSEMAPHORES
#endif
#if !defined(INCL_DOSQUEUES)
#define INCL_DOSQUEUES
#endif
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>


#define INBUF_SIZE 4096
#define QNAME_LEN  32

struct data_block  {
  int  data_size;
  char *block;
};

class FileFilter  {
  protected:
    HEV   done_sem;
    HQUEUE qhandle;
    char   qname[ QNAME_LEN ];
    ULONG max_sem_wait;

    static int count;
    int in_line_mode;
    int blocks2read;
    int blocks2write;
    int filter_valid;
    data_block* (*filter)( data_block *inblock );

    ULONG filter_error;
    FILE *rfile;
    FILE *wfile;

    friend void read_thread( void *filterptr );
    friend void write_thread( void *filterptr );
    int create_sem();

    int		create_queue();
    data_block *get_queue();
    int		put_queue( data_block *data );

  public:
    FileFilter() {}
    FileFilter( const char *file2read,
		const char *file2write,
		data_block* (*filter_func)
			( data_block *inblock ) );


   ~FileFilter();

    ULONG	error_code() 	{ return filter_error; }
    int		valid()		{ return filter_valid; }
    APIRET	wait4completion( ULONG max_wait );
};


#endif
