#include "ffilter.hpp"
#include "filtfunc.hpp"

data_block *unix_filter( data_block *inblock )
{
  data_block *outblock;
  // int i = 0, j = 0, k;
  int k;

    if( !inblock || !inblock->data_size )
	return 0;

    k = inblock->data_size;

    outblock = new data_block;
    if( !outblock )
	return 0;

    outblock->block = new char[ k << 1 ];
    if( !outblock->block )  {
	delete outblock;
	return 0;
    }

#if 0
    while( i < k )  {
	if( inblock->block[ i ] == '\n' )
	    outblock->block[ j++ ] = '\r';

	outblock->block[ j++ ] = inblock->block[ i++ ];
    }
#endif

    outblock->data_size =
	filter_function( inblock->block, outblock->block, k );

    return outblock;
}

int main( int argc, char *argv[] )
{
   APIRET rc;
   FileFilter *my_filter = 0, *my_filter2 = 0;
   const ULONG max_millisec = 30000UL;

    if( argc < 3 )  {
	printf(
	 "\n\tUsage: gofilter  UnixFile PCFile [UnixFile] [PCFile]\n\n"
	);
	printf(
	 "\tCopies unix ascii(LF only) file(s) to pc ascii(CR/LF) file(s)."
	);
	printf("\n\n\tNOTE: TEST STUB for FileFilter C++ class\n");
	return 1;
    }

    my_filter = new FileFilter( argv[ 1 ], argv[ 2 ], unix_filter );

    if( !my_filter || !my_filter->valid() )  {
	printf("\n\n\tCould Not Create First Filter!\n");
	return 1;
    }

    if( argc >= 5 )  {
	my_filter2 = new FileFilter( argv[ 3 ],
				     argv[ 4 ],
				     unix_filter );
	if( !my_filter2 || !my_filter2->valid() )  {
	    if( my_filter2 )  {
		delete my_filter2;
		my_filter2 = 0;
	    }
	    printf("\n\n\tCould Not Create Second Filter!\n");
	}
    }

    rc = my_filter->wait4completion( max_millisec );
    if( !rc )
	printf("\nFile: %s Filtered\n", argv[ 2 ] );

    if( my_filter2 && my_filter2->valid() )  {
	rc = my_filter2->wait4completion( max_millisec );
	if( !rc )
	    printf("\nFile: %s Filtered\n", argv[ 4 ] );
    }
    return 0;
}



