@CSOURCE6 = /* <R>
 *Header: pstring.h (string handling support)<R>
 *	by Martin.Weitzel@rent-a-guru.DE<R>
 */<R>
#ifndef PSTRING_H<R>
#define PSTRING_H<R>
/*<R>
 * Interface macros to "pstr_x" for fixed number of<R>
 * arguments. (Using this macros instead of direct<R>
 * calls to the function helps to make the source<R>
 * more readable.)<R>
 */<R>
char *pstr_x(const char *str, ...);<R>
#define pstr_1(s1)\<R>
	(pstr_x(s1, (const char *)0))<R>
#define pstr_2(s1, s2)\<R>
	(pstr_x(s1, s2, (const char *)0))<R>
#define pstr_3(s1, s2, s3)\<R>
	(pstr_x(s1, s2, s3, (const char *)0))<R>
#define pstr_4(s1, s2, s3, s4)\<R>
	(pstr_x(s1, s2, s3, s4, (const char *)0))<R>
/* .... may be extended .... */<R>
<R>
/*<R>
 * Strings that are used only once may be build with<R>
 * help of the "tmpstr"-function or (preferably) with<R>
 * one of the "TMPSTR"-macros. The space occupied by<R>
 * a string build in this way is freed with the next<R>
 * call to one of this macros, so its contents should<R>
 * be accessed IMMEDIATELY. To reduce the risk of<R>
 * inappropriate use, the result of calls to "tmpstr"<R>
 * should NEVER be stored into a pointer, and when<R>
 * calling a function that needs several string<R>
 * arguments, AT MOST ONE may be initialized with the<R>
 * result of a call to "tmpstr". In both cases this<R>
 * includes indirect calls to "tmpstr" through one of<R>
 * the "TMPSTR"-macros.<R>
 */<R>
char *tmpstr(char *str);<R>
#define TMPSTR1(s1)\<R>
	(tmpstr(pstr_1(s1)))<R>
#define TMPSTR2(s1, s2)\<R>
	(tmpstr(pstr_2(s1, s2)))<R>
#define TMPSTR3(s1, s2, s3)\<R>
	(tmpstr(pstr_3(s1, s2, s3)))<R>
#define TMPSTR4(s1, s2, s3, s4)\<R>
	(tmpstr(pstr_4(s1, s2, s3, s4)))<R>
/* .... may be extended .... */<R>
<R>
#endif

