Listing 4 - class and inline member function definitions for a type-safe 
queue of str wrapped around a genq

//
// strq3.h - a type-safe wrapper for a queue of str
// wrapped around a genq
//

#include "genq3.h"
#include "str.h"

class strq
    {
public:
    ~strq();
    void append(const str &e);
    void apply(void f(void *p));
    void clear();
    int remove(str &e);
private:
    genq gq;
    };

inline strq::~strq()
    {
    clear();
    }

inline void strq::append(const str &e)
    {
    gq.append(new str (e));
    }

inline void strq::apply(void f(void *))
    {
    gq.apply(f);
    }
