Listing 6 - A test program for the strq wrapper class with an output 
operator

//
// strtst3c.cpp - test genq3 using str elements
//

#include <iostream.h>

#include "showheap.h"
#include "strq3.h"

ostream *os_ptr;

void print_str(void *e)
    {
    *os_ptr << ' ' << *(str *)e;
    }

ostream &operator<<(ostream &os, strq &q)
    {
    os_ptr = &os;
    q.apply(print_str);
    return os;
    }

#define DIM(a) (sizeof(a)/sizeof(a[0]))

void test()
    {
    char c;
    size_t qn;
    str qe;
    strq q[4];
    while (cin >> c)
        {
        showheap();
        if (c == 'q')
            break;
        if (c == 'a')
            {
            cin >> qn >> qe;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].append(qe);
            }
        else if (c == 'c')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].clear();
            }
        else if (c == 'r')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else if (q[qn].remove(qe))
                cout << "removed " << qe << '\n';
            else
                cout << "q[" << qn << "] is empty\n";
            }
        else
            continue;
        for (size_t i = 0; i < DIM(q); ++i)
            cout << i << ':' << q[i] << '\n';
        }
    }

int main()
    {
    showheap();
    test();
    showheap();
    return 0;
    }
