/************************************************
 * file: ARGS.H
 * purpose: structures and definitions for parseargs()
 *          and findfile() functions
 * author: David Weber
 * history:
 *  02-15-91 - initial code
 ************************************************/

/* Arguments are of two types, switches and nonswitches.  Switches are
 * preceded by a '-' or a '/' and are a single letter optionally followed
 * by an argument value.  Switches are parsed anywhere they are found in
 * the command list.  Multiple switches may be concatenated behind a single
 * '-' or '/' if they do not require values.  Nonswitches are simply character
 * arrays which are not preceded by a switch character.  Nonswitchvalues are
 * put into the array until a NULL value is found. If more nonswitches
 * are found than allowed by the array or an illegal switch character is
 * encountered then usage(); is called.
 *  ARGS example =
 *      {
 *      "vcd",          switches "-v -cname -d98" would set verbose to 1, copy "name" into str and set digit to 98
 *      formatlist      char formatlist[] = {NOARG,CHARARG,INTARG}; type of values to expect as arguments
 *      valuelist       void *valuelist[] = {&verbose,str,&digit}; int *verbose, char *name, int *digit;
 *      64,             maximum size of a nonswitch array or a CHARARG switch value
 *      namelist,       char *namelist[] = {file1,file2,NULL}; char *file1, char *file2; storage for nonswitches
 *      };
 * The special switches -? and -h always call usage();
 */

typedef struct
    {
    char *switches;             /* set to NULL if no switches are allowed */
    char *formats;
    void **switchvalues;
    int nonswitchsize;
    char **nonswitchvalues;     /* set to NULL if no nonswitches are allowed */
    } ARGS;

#define NOARG 1         /* no value expected for switch */
#define CHARARG 2       /* switch followed by a character value */
#define INTARG 3        /* switch followed by an integer value */
#define LONGARG 4       /* switch followed by a long value */

void parseargs(int argc,char *argv[],ARGS *style);
