LISTING 6 - Illustrates the string class

// tstr.cpp:     Test the C++ string class
#include <iostream.h>
#include <stddef.h>
#include <cstring.h>    // Borland's name for <string>

main()
{
    string s1("Mary had a little lamb"),
           s2 = "Old McDonald had a farm";

    // Test some operators
    string s3 = s1 + ", but " + s2;
    cout << s3 << endl;
    s3.resize(s1.length());
    cout << "s1 == s3? " << (s1 == s3 ? "yes" : "no") << endl;

    // Search and replace
    size_t pos = s2.find("farm");
    s2.insert(pos,"little ");
    cout << "s2 == " << s2 << endl;

    // Subscripting
    s1[s1.length()-1] = 'p';
    cout << "s1 == " << s1 << endl;
    return 0 ;
}

// Output:
Mary had a little lamb, but Old McDonald had a farm
s1 == s3? yes
s2 == Old McDonald had a little farm
s1 == Mary had a little lamp
