/**************************************************************************
*  File Name     : XLATE.H
*  Description   : XLATE Header File
*  Author        : R. Scott Guthrie  /  All Rights Reserved
**************************************************************************/
/* FUNCTION PROTOTYPES */
void  XlateSet(char *source_file_name);
int   XlateLoad(char *source_file_name);
int   XlateLoadBinary(FILE *fd);
int   XlateLoadText(FILE *fd);
int   XlateGetString(FILE *fd, char *string);
int   XlateCreateTable(int entries);
int   XlateSearchCompare(const void *a, const void *b);
int   XlateSortCompare(const void *a, const void *b);
char* Xlate(char *s);
void  XlateFree(void);

/* CONSTANTS */
#define XlateDefaultFileName    "DEFAULT"
#define XlateOpenDelimeter      '['
#define XlateCloseDelimeter     ']'
#define XlateEscapeCharacter    '\\'
#define XlateMaxLength          128

/* Translate Node Definition */
typedef struct
{
  char *translate_key;
  char *translated_value;
} XLATE;

/* end source file 'XLATE.H' */
