/* Listing 2 */
/* ARCH.C */
/*  Copyright 1993 by P.J. LaBrocca
    All rights reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sea.h"

/* Forms a filename plus extension,
   if any, from the full or partial path
   pointed to by path and stores it in
   buffer pointed to by name.
*/
char *filename( char *path, char *name )
{
    char *p;

    /* Start at last character */
    p = path + strlen( path ) - 1;
    while( p != path ) {
        if( *p == '\\' || *p == ':' )
            break;
        --p;
    }
    if( p == path && *p != '\\')
        strcpy( name, path );
    else
        strcpy( name, ++p );
    return name;
}

void main( int argc, char **argv )
{
    FILE *input, *output;
    int c;
    int count = 1;
    HEADER header;
    long i;
    /* char extension[5];  for _splitpath() */

    if( argc == 1 ) {
        printf("Usage: arch file [file ...]\n");
        printf("    Wild cards * and ?.\n");
        exit( 0 );
    }    

/* open extractor module */
    if((input = fopen("extr.exe", "rb")) == NULL) {
        printf( "error opening extr.exe\n" );
        exit( 0 );
    } /* if( ( archive = */

/* open the final archive file */
    if((output = fopen("out.exe", "wb")) == NULL) {
        printf( "error opening output\n" );
        exit( 0 );
    } /* if( ( output =  */

/* copy extractor to final output file */
    while( ( c = getc( input ) ) != EOF ) {
        putc( c, output );
    } /* while( ( c = */

    fclose( input );

    while( count < argc ) {
        if((input = fopen( argv[count], "rb"))==NULL) {
            printf( "Can't open %s\n", argv[count] );
            ++count;
            continue;
        } /* if( ( input = */
        printf( "Adding %-15s", argv[count] );
        fseek( input, 0, SEEK_END );
        header.filesize = ftell( input );
        fseek( input, 0, SEEK_SET );

#if 0
        _splitpath( argv[count], NULL, NULL,
                    header.filename, extension );
        strcat( header.filename, extension );
#endif
        filename( argv[count], header.filename );

        fwrite( &header, sizeof( HEADER ), 1, output );

        for( i = 0; i < header.filesize; ++i ) {
            putc( getc( input ), output );
        } /* for( i = 0; i < */
        fclose( input );
        printf("Done!\n");
        ++count;
    } /* while(  ) */
    header.filesize = -1L;
    fwrite( &header, sizeof( HEADER ), 1, output );
    fclose( output );
} /* main */

/* End of File */
